/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.client.loader;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEventListener;
import edu.uiuc.ncsa.security.core.configuration.provider.TypedProvider;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.NotImplementedException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPoolProvider;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import edu.uiuc.ncsa.security.util.jwk.JWKUtil2;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.oa4mp.client.api.Asset;
import org.oa4mp.client.api.ClientEnvironment;
import org.oa4mp.client.api.ClientXMLTags;
import org.oa4mp.client.api.OA4MPServiceProvider;
import org.oa4mp.client.api.loader.AbstractClientLoader;
import org.oa4mp.client.api.storage.AssetProvider;
import org.oa4mp.client.api.storage.AssetStore;
import org.oa4mp.client.api.storage.FSAssetStoreProvider;
import org.oa4mp.client.api.storage.MemoryAssetStore;
import org.oa4mp.client.api.storage.MultiAssetStoreProvider;
import org.oa4mp.client.loader.OA2AssetConverter;
import org.oa4mp.client.loader.OA2AssetProvider;
import org.oa4mp.client.loader.OA2AssetSerializationKeys;
import org.oa4mp.client.loader.OA2ClientEnvironment;
import org.oa4mp.client.loader.OA2MPServiceProvider;
import org.oa4mp.client.loader.OA2SQLAssetStoreProvider;
import org.oa4mp.delegation.client.DelegationService;
import org.oa4mp.delegation.client.server.AGServer;
import org.oa4mp.delegation.client.server.ATServer;
import org.oa4mp.delegation.client.server.PAServer;
import org.oa4mp.delegation.client.server.RFC7009Server;
import org.oa4mp.delegation.client.server.RFC7662Server;
import org.oa4mp.delegation.client.server.RTServer;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.common.token.TokenForge;
import org.oa4mp.delegation.server.OA2ConfigurationLoaderUtils;
import org.oa4mp.delegation.server.OA2TokenForge;
import org.oa4mp.delegation.server.client.AGServer2;
import org.oa4mp.delegation.server.client.ATServer2;
import org.oa4mp.delegation.server.client.DS2;
import org.oa4mp.delegation.server.client.PAServer2;
import org.oa4mp.delegation.server.client.RFC6749_4_4Server;
import org.oa4mp.delegation.server.client.RFC7009Server2;
import org.oa4mp.delegation.server.client.RFC7523Server;
import org.oa4mp.delegation.server.client.RFC7662Server2;
import org.oa4mp.delegation.server.client.RFC8623Server;
import org.oa4mp.delegation.server.client.RTServer2;
import org.oa4mp.delegation.server.client.UIServer2;

public class OA2ClientLoader<T extends ClientEnvironment>
extends AbstractClientLoader<T> {
    protected Collection<String> scopes = null;
    Map<String, List<String>> additionalParameters = null;
    AssetProvider assetProvider = null;
    Boolean showIDToken = null;
    Boolean oidcEnabled = null;
    JWKUtil2 jwkUtil;
    JSONWebKeys jwks = null;
    Boolean useBasicAuth = null;

    public OA2ClientLoader(ConfigurationNode node) {
        super(node);
    }

    public OA2ClientLoader(ConfigurationNode node, MyLoggingFacade logger) {
        super(node, logger);
    }

    public String getVersionString() {
        return "OA4MP Client OAuth 2 configuration loader, version 6.2.1";
    }

    public OA4MPServiceProvider getServiceProvider() {
        return new OA2MPServiceProvider(this.load());
    }

    public Collection<String> getScopes() {
        if (this.scopes == null) {
            this.scopes = OA2ConfigurationLoaderUtils.getScopes((ConfigurationNode)this.cn);
        }
        return this.scopes;
    }

    public Map<String, List<String>> getAdditionalParameters() {
        if (this.additionalParameters == null) {
            this.additionalParameters = OA2ConfigurationLoaderUtils.getAdditionalParameters((ConfigurationNode)this.cn);
        }
        return this.additionalParameters;
    }

    public T createInstance(Provider<TokenForge> tokenForgeProvider, Provider<Client> clientProvider, HashMap<String, String> constants) {
        try {
            if (StringUtils.isTrivial((String)this.myLogger.getClassName())) {
                this.myLogger.setClassName("oa4mp-client");
            }
            return (T)((Object)new OA2ClientEnvironment(this.myLogger, constants, this.getAccessTokenURI(), this.getAuthorizeURI(), this.getCallback(), this.getAssetURI(), this.getCertLifetime(), this.getId(), this.getSkin(), this.isEnableAssetCleanup(), this.getMaxAssetLifetime(), this.getKeypairLifetime(), this.getAssetProvider(), clientProvider, tokenForgeProvider, this.getDSP(), this.getAssetStoreProvider(), this.isShowRedirectPage(), this.getErrorPagePath(), this.getRedirectPagePath(), this.getSuccessPagePath(), this.getSecret(), this.getKID(), this.getKeys(), this.getScopes(), this.getWellKnownURI(), this.isOIDCEnabled(), this.isShowIDToken(), this.isUseBasicAuth(), this.getAdditionalParameters(), this.getDeviceAuthorizationURI(), this.getIssuer(), this.getDebugger()));
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new GeneralException("Unable to create client environment", e);
        }
    }

    public AssetProvider getAssetProvider() {
        if (this.assetProvider == null) {
            this.assetProvider = new OA2AssetProvider();
        }
        return this.assetProvider;
    }

    public boolean isShowIDToken() {
        if (this.showIDToken == null) {
            String showIDTokenValue = this.getCfgValue("showIDToken");
            if (showIDTokenValue == null) {
                this.showIDToken = Boolean.FALSE;
                this.info("No value for showIDToken is configured, using default \"" + this.showIDToken + "\"");
            } else {
                this.showIDToken = Boolean.parseBoolean(showIDTokenValue);
                this.debug("Value for showIDToken parsed as " + this.showIDToken);
                ServletDebugUtil.trace((Object)((Object)this), (String)("setting showIDToken to " + this.showIDToken));
            }
        }
        return this.showIDToken;
    }

    public boolean isOIDCEnabled() {
        if (this.oidcEnabled == null) {
            this.oidcEnabled = Boolean.TRUE;
            String content = this.getCfgValue("OIDCEnabled");
            if (content == null || content.isEmpty()) {
                return this.oidcEnabled;
            }
            try {
                this.oidcEnabled = Boolean.parseBoolean(content);
            }
            catch (Throwable t) {
                this.warn("Unable to parse OIDCEnabled element content of \"" + content + "\". Using default of true.");
            }
        }
        return this.oidcEnabled;
    }

    public Provider<AssetStore> getAssetStoreProvider() {
        if (this.assetStoreProvider == null) {
            MultiAssetStoreProvider masp = new MultiAssetStoreProvider(this.cn, this.isDefaultStoreDisabled(new boolean[0]), (MyLoggingFacade)this.loggerProvider.get());
            OA2AssetSerializationKeys keys = new OA2AssetSerializationKeys();
            OA2AssetConverter assetConverter = new OA2AssetConverter((SerializationKeys)keys, (IdentifiableProvider<Asset>)this.getAssetProvider());
            this.assetStoreProvider = masp;
            masp.addListener((CfgEventListener)new FSAssetStoreProvider(this.cn, this.getAssetProvider(), (MapConverter)assetConverter));
            masp.addListener((CfgEventListener)new OA2SQLAssetStoreProvider(this.cn, "postgresql", (ConnectionPoolProvider<? extends ConnectionPool>)this.getPgConnectionPoolProvider(), this.getAssetProvider(), (MapConverter)assetConverter));
            masp.addListener((CfgEventListener)new OA2SQLAssetStoreProvider(this.cn, "derby", (ConnectionPoolProvider<? extends ConnectionPool>)this.getDerbyConnectionPoolProvider(), this.getAssetProvider(), (MapConverter)assetConverter));
            masp.addListener((CfgEventListener)new OA2SQLAssetStoreProvider(this.cn, "mysql", (ConnectionPoolProvider<? extends ConnectionPool>)this.getMySQLConnectionPoolProvider(), this.getAssetProvider(), (MapConverter)assetConverter));
            masp.addListener((CfgEventListener)new OA2SQLAssetStoreProvider(this.cn, "mariadb", (ConnectionPoolProvider<? extends ConnectionPool>)this.getMariaDBConnectionPoolProvider(), this.getAssetProvider(), (MapConverter)assetConverter));
            masp.addListener((CfgEventListener)new TypedProvider<MemoryAssetStore>(this.cn, "memoryStore", "assetStore"){

                public Object componentFound(CfgEvent configurationEvent) {
                    if (this.checkEvent(configurationEvent)) {
                        return this.get();
                    }
                    return null;
                }

                public MemoryAssetStore get() {
                    return new MemoryAssetStore((IdentifiableProvider)OA2ClientLoader.this.getAssetProvider());
                }
            });
        }
        return this.assetStoreProvider;
    }

    protected String getErrorPagePath() {
        return this.getCfgValue("errorPagePath");
    }

    public String getSecret() {
        return this.getCfgValue("secret");
    }

    public String getKID() {
        return this.getCfgValue(ClientXMLTags.JWK_KEY_ID);
    }

    protected JSONWebKeys getKeysFromFile() {
        String fname = this.getCfgValue("jwksFile");
        if (StringUtils.isTrivial((String)fname)) {
            return null;
        }
        try {
            return this.getJwkUtil().fromJSON(new File(fname));
        }
        catch (Throwable t) {
            if (this.debugger.isEnabled()) {
                t.printStackTrace();
            }
            return null;
        }
    }

    protected JSONWebKeys getKeysFromString() {
        String raw = this.getCfgValue("jwks");
        if (StringUtils.isTrivial((String)raw)) {
            return null;
        }
        try {
            return this.getJwkUtil().fromJSON(raw);
        }
        catch (Throwable t) {
            if (this.debugger.isEnabled()) {
                t.printStackTrace();
            }
            return null;
        }
    }

    public JWKUtil2 getJwkUtil() {
        if (this.jwkUtil == null) {
            this.jwkUtil = new JWKUtil2();
        }
        return this.jwkUtil;
    }

    public void setJwkUtil(JWKUtil2 jwkUtil) {
        this.jwkUtil = jwkUtil;
    }

    public JSONWebKeys getKeys() {
        if (this.jwks == null) {
            this.jwks = this.getKeysFromFile();
            if (this.jwks == null) {
                this.jwks = this.getKeysFromString();
            } else {
                JSONWebKeys jwks2 = this.getKeysFromString();
                if (jwks2 != null) {
                    throw new GeneralException("two JWKs specified in the configuration. Only one is allowed");
                }
            }
        }
        return this.jwks;
    }

    protected boolean hasJWKS() {
        return this.getKeys() != null;
    }

    protected String getSuccessPagePath() {
        return this.getCfgValue("successPagePath");
    }

    protected String getRedirectPagePath() {
        return this.getCfgValue("redirectPagePath");
    }

    protected boolean isShowRedirectPage() {
        String temp = this.getCfgValue("showRedirectPage");
        if (temp == null || temp.length() == 0) {
            return false;
        }
        return Boolean.parseBoolean(this.getCfgValue("showRedirectPage"));
    }

    public T createInstance() {
        Provider<TokenForge> tokenForgeProvider = new Provider<TokenForge>(){

            public TokenForge get() {
                return new OA2TokenForge(OA2ClientLoader.this.getId());
            }
        };
        Provider<Client> clientProvider = new Provider<Client>(){

            public Client get() {
                return new Client(BasicIdentifier.newID((String)OA2ClientLoader.this.getId()));
            }
        };
        HashMap<String, String> constants = new HashMap<String, String>();
        constants.put("oa4mp:callback_uri", "redirect_uri");
        constants.put("oa4mp:form_encoding", "application/x-www-form-urlencoded");
        constants.put("oa4mp:token", "code");
        T t = this.createInstance(tokenForgeProvider, clientProvider, constants);
        t.setDebugOn(DebugUtil.isEnabled());
        return t;
    }

    public Boolean isUseBasicAuth() {
        if (this.useBasicAuth == null) {
            try {
                this.useBasicAuth = Boolean.parseBoolean(this.getCfgValue("useHTTPBasicAuth"));
            }
            catch (Throwable t) {
                this.useBasicAuth = Boolean.FALSE;
            }
        }
        return this.useBasicAuth;
    }

    public void setUseBasicAuth(Boolean useBasicAuth) {
        this.useBasicAuth = useBasicAuth;
    }

    protected Provider<DelegationService> getDSP() {
        if (this.dsp == null) {
            this.dsp = new Provider<DelegationService>(){

                public DelegationService get() {
                    return new DS2((AGServer)new AGServer2(OA2ClientLoader.this.createServiceClient(OA2ClientLoader.this.getAuthorizeURI())), (ATServer)new ATServer2(OA2ClientLoader.this.createServiceClient(OA2ClientLoader.this.getAccessTokenURI()), OA2ClientLoader.this.getIssuer(), OA2ClientLoader.this.getWellKnownURI(), OA2ClientLoader.this.isOIDCEnabled(), OA2ClientLoader.this.getMaxAssetLifetime(), OA2ClientLoader.this.isUseBasicAuth().booleanValue()), (PAServer)new PAServer2(OA2ClientLoader.this.createServiceClient(OA2ClientLoader.this.getAssetURI())), new UIServer2(OA2ClientLoader.this.createServiceClient(OA2ClientLoader.this.getUIURI())), (RTServer)new RTServer2(OA2ClientLoader.this.createServiceClient(OA2ClientLoader.this.getAccessTokenURI()), OA2ClientLoader.this.getIssuer(), OA2ClientLoader.this.getWellKnownURI(), OA2ClientLoader.this.isOIDCEnabled()), new RFC6749_4_4Server(OA2ClientLoader.this.createServiceClient(OA2ClientLoader.this.getAccessTokenURI()), OA2ClientLoader.this.getIssuer(), OA2ClientLoader.this.getWellKnownURI(), OA2ClientLoader.this.isOIDCEnabled()), (RFC7009Server)new RFC7009Server2(OA2ClientLoader.this.createServiceClient(OA2ClientLoader.this.getRFC7009Endpoint()), OA2ClientLoader.this.getIssuer(), OA2ClientLoader.this.getWellKnownURI(), OA2ClientLoader.this.isOIDCEnabled()), (RFC7662Server)new RFC7662Server2(OA2ClientLoader.this.createServiceClient(OA2ClientLoader.this.getRFC7662Endpoint()), OA2ClientLoader.this.getIssuer(), OA2ClientLoader.this.getWellKnownURI(), OA2ClientLoader.this.isOIDCEnabled()), new RFC7523Server(OA2ClientLoader.this.createServiceClient(OA2ClientLoader.this.getAccessTokenURI()), OA2ClientLoader.this.getIssuer(), OA2ClientLoader.this.getWellKnownURI(), OA2ClientLoader.this.isOIDCEnabled()), new RFC8623Server(OA2ClientLoader.this.createServiceClient(OA2ClientLoader.this.getDeviceAuthorizationURI()), OA2ClientLoader.this.getIssuer(), OA2ClientLoader.this.getWellKnownURI(), OA2ClientLoader.this.isOIDCEnabled()));
                }
            };
        }
        return this.dsp;
    }

    public URI getUIURI() {
        return this.createServiceURI(this.getCfgValue("userInfoUri"), "userinfo", "userinfo_endpoint");
    }

    public URI getDeviceAuthorizationURI() {
        return this.createServiceURI(this.getCfgValue("deviceAuthorizationUri"), "device_authorization", "device_authorization_endpoint");
    }

    public URI getRFC7009Endpoint() {
        return this.createServiceURI(this.getCfgValue("revocationUri"), "revoke", "revocation_endpoint");
    }

    public URI getRFC7662Endpoint() {
        return this.createServiceURI(this.getCfgValue("introspectionUri"), "introspect", "introspection_endpoint");
    }

    public HashMap<String, String> getConstants() {
        throw new NotImplementedException("Error: This method is not implemented.");
    }
}

