/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.client.loader;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import edu.uiuc.ncsa.security.core.util.LoggerProvider;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.servlet.ServiceClient;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.inject.Provider;
import net.sf.json.JSONObject;
import org.oa4mp.client.api.Asset;
import org.oa4mp.client.api.ClientEnvironment;
import org.oa4mp.client.api.ClientLoaderInterface;
import org.oa4mp.client.api.storage.AssetProvider;
import org.oa4mp.client.loader.OA2AssetConverter;
import org.oa4mp.client.loader.OA2AssetProvider;
import org.oa4mp.client.loader.OA2AssetSerializationKeys;
import org.oa4mp.client.loader.OA2ClientEnvironment;
import org.oa4mp.client.loader.OA2MPServiceProvider;
import org.oa4mp.delegation.client.DelegationService;
import org.oa4mp.delegation.client.server.AGServer;
import org.oa4mp.delegation.client.server.ATServer;
import org.oa4mp.delegation.client.server.PAServer;
import org.oa4mp.delegation.client.server.RFC7009Server;
import org.oa4mp.delegation.client.server.RFC7662Server;
import org.oa4mp.delegation.client.server.RTServer;
import org.oa4mp.delegation.common.token.TokenForge;
import org.oa4mp.delegation.server.OA2TokenForge;
import org.oa4mp.delegation.server.client.AGServer2;
import org.oa4mp.delegation.server.client.ATServer2;
import org.oa4mp.delegation.server.client.DS2;
import org.oa4mp.delegation.server.client.PAServer2;
import org.oa4mp.delegation.server.client.RFC6749_4_4Server;
import org.oa4mp.delegation.server.client.RFC7009Server2;
import org.oa4mp.delegation.server.client.RFC7523Server;
import org.oa4mp.delegation.server.client.RFC7662Server2;
import org.oa4mp.delegation.server.client.RFC8623Server;
import org.oa4mp.delegation.server.client.RTServer2;
import org.oa4mp.delegation.server.client.UIServer2;

public abstract class OA2ClientLoaderImpl<T extends OA2ClientEnvironment>
implements ClientLoaderInterface<T> {
    ServiceClient wellKnownClient = null;
    JSONObject wellKnownConfiguration = null;
    Provider<DelegationService> dsp = null;
    protected AssetProvider assetProvider = new OA2AssetProvider();
    protected OA2AssetSerializationKeys assetKeys = new OA2AssetSerializationKeys();
    protected OA2AssetConverter assetConverter = new OA2AssetConverter((SerializationKeys)this.assetKeys, (IdentifiableProvider<Asset>)this.assetProvider);
    protected Provider<TokenForge> tokenForgeProvider = new Provider<TokenForge>(){

        public TokenForge get() {
            return new OA2TokenForge(OA2ClientLoaderImpl.this.getId());
        }
    };
    LoggerProvider loggerProvider = null;

    public OA2MPServiceProvider getServiceProvider() {
        return new OA2MPServiceProvider((ClientEnvironment)this.load());
    }

    public ServiceClient createServiceClient(URI host) {
        return new ServiceClient(host, this.getSSLConfiguration());
    }

    public ServiceClient getWellKnownClient() {
        if (this.wellKnownClient == null) {
            this.wellKnownClient = this.createServiceClient(URI.create(this.getWellKnownURI()));
        }
        return this.wellKnownClient;
    }

    public String getWellKnownString(String key) {
        if (this.getWellKnownConfiguration().containsKey((Object)key)) {
            return this.getWellKnownConfiguration().getString(key);
        }
        return null;
    }

    public Object getWellKnownValue(String key) {
        if (this.getWellKnownConfiguration().containsKey((Object)key)) {
            return this.getWellKnownConfiguration().get(key);
        }
        return null;
    }

    public JSONObject getWellKnownConfiguration() {
        if (this.wellKnownConfiguration == null) {
            String response = this.getWellKnownClient().doGet(new HashMap());
            this.wellKnownConfiguration = JSONObject.fromObject((Object)response);
        }
        return this.wellKnownConfiguration;
    }

    protected Provider<DelegationService> getDSP() {
        if (this.dsp == null) {
            this.dsp = new Provider<DelegationService>(){

                public DelegationService get() {
                    return new DS2((AGServer)new AGServer2(OA2ClientLoaderImpl.this.createServiceClient(OA2ClientLoaderImpl.this.getAuthorizeURI())), (ATServer)new ATServer2(OA2ClientLoaderImpl.this.createServiceClient(OA2ClientLoaderImpl.this.getAccessTokenURI()), OA2ClientLoaderImpl.this.getIssuer(), OA2ClientLoaderImpl.this.getWellKnownURI(), OA2ClientLoaderImpl.this.isOIDCEnabled(), OA2ClientLoaderImpl.this.getMaxAssetLifetime(), false), (PAServer)new PAServer2(OA2ClientLoaderImpl.this.createServiceClient(OA2ClientLoaderImpl.this.getAssetURI())), new UIServer2(OA2ClientLoaderImpl.this.createServiceClient(OA2ClientLoaderImpl.this.getUIURI())), (RTServer)new RTServer2(OA2ClientLoaderImpl.this.createServiceClient(OA2ClientLoaderImpl.this.getAccessTokenURI()), OA2ClientLoaderImpl.this.getIssuer(), OA2ClientLoaderImpl.this.getWellKnownURI(), OA2ClientLoaderImpl.this.isOIDCEnabled()), new RFC6749_4_4Server(OA2ClientLoaderImpl.this.createServiceClient(OA2ClientLoaderImpl.this.getAccessTokenURI()), OA2ClientLoaderImpl.this.getIssuer(), OA2ClientLoaderImpl.this.getWellKnownURI(), OA2ClientLoaderImpl.this.isOIDCEnabled()), (RFC7009Server)new RFC7009Server2(OA2ClientLoaderImpl.this.createServiceClient(OA2ClientLoaderImpl.this.getRFC7009Endpoint()), OA2ClientLoaderImpl.this.getIssuer(), OA2ClientLoaderImpl.this.getWellKnownURI(), OA2ClientLoaderImpl.this.isOIDCEnabled()), (RFC7662Server)new RFC7662Server2(OA2ClientLoaderImpl.this.createServiceClient(OA2ClientLoaderImpl.this.getRFC7662Endpoint()), OA2ClientLoaderImpl.this.getIssuer(), OA2ClientLoaderImpl.this.getWellKnownURI(), OA2ClientLoaderImpl.this.isOIDCEnabled()), new RFC7523Server(OA2ClientLoaderImpl.this.createServiceClient(OA2ClientLoaderImpl.this.getAccessTokenURI()), OA2ClientLoaderImpl.this.getIssuer(), OA2ClientLoaderImpl.this.getWellKnownURI(), OA2ClientLoaderImpl.this.isOIDCEnabled()), new RFC8623Server(OA2ClientLoaderImpl.this.createServiceClient(OA2ClientLoaderImpl.this.getDeviceAuthorizationURI()), OA2ClientLoaderImpl.this.getIssuer(), OA2ClientLoaderImpl.this.getWellKnownURI(), OA2ClientLoaderImpl.this.isOIDCEnabled()));
                }
            };
        }
        return this.dsp;
    }

    protected URI createServiceURI(String foundURI, String endpoint, String wellKnownEntry) {
        if (!StringUtils.isTrivial((String)foundURI)) {
            return this.checkURI(foundURI, wellKnownEntry);
        }
        if (this.getWellKnownURI() != null) {
            return this.checkURI(this.getWellKnownString(wellKnownEntry), wellKnownEntry);
        }
        if (StringUtils.isTrivial((String)this.getServiceURI())) {
            return null;
        }
        return this.checkURI(this.getServiceURI() + "/" + endpoint, endpoint);
    }

    protected URI checkURI(String uri, String componentName) {
        if (StringUtils.isTrivial((String)uri)) {
            throw new MyConfigurationException("Error: There is no " + componentName + " URI specified.");
        }
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new MyConfigurationException("Error: The specified " + componentName + " is not a valid URI", (Throwable)e);
        }
    }

    public AssetProvider getAssetProvider() {
        return this.assetProvider;
    }

    public abstract LoggerProvider getLoggerProvider();

    public abstract MetaDebugUtil getDebugger();

    protected MetaDebugUtil getDebugger(String debugLevel) {
        MetaDebugUtil debugger = new MetaDebugUtil();
        try {
            if (debugLevel == null || debugLevel.isEmpty()) {
                debugger.setDebugLevel(10);
            } else {
                debugger.setDebugLevel(debugLevel);
            }
        }
        catch (Throwable t) {
            debugger.setIsEnabled(Boolean.parseBoolean(debugLevel));
        }
        return debugger;
    }
}

