/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.client.loader;

import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.cache.Cleanup;
import edu.uiuc.ncsa.security.core.cache.LockingCleanup;
import edu.uiuc.ncsa.security.core.cache.RetentionPolicy;
import edu.uiuc.ncsa.security.core.cache.ValidTimestampPolicy;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.servlet.AbstractServlet;
import edu.uiuc.ncsa.security.servlet.ExceptionHandler;
import edu.uiuc.ncsa.security.servlet.Initialization;
import edu.uiuc.ncsa.security.storage.sql.SQLStore;
import java.sql.SQLException;
import javax.servlet.ServletException;
import org.oa4mp.client.api.servlet.ClientServlet;
import org.oa4mp.client.loader.AssetRetentionPolicy;
import org.oa4mp.client.loader.OA2ClientEnvironment;
import org.oa4mp.client.loader.servlet.OA2ClientExceptionHandler;

public class OA2ClientServletInitializer
implements Initialization {
    protected ExceptionHandler exceptionHandler;
    protected boolean hasRun = false;
    AbstractEnvironment environment;
    AbstractServlet servlet;

    public AbstractEnvironment getEnvironment() {
        return this.environment;
    }

    public void init() throws ServletException {
        if (this.hasRun) {
            return;
        }
        this.hasRun = true;
        MyLoggingFacade logger = this.getEnvironment().getMyLogger();
        OA2ClientEnvironment ce = (OA2ClientEnvironment)this.getEnvironment();
        DebugUtil.setInstance((MetaDebugUtil)ce.getMetaDebugUtil());
        if (ce.hasAssetStore()) {
            if (ce.getAssetStore() instanceof SQLStore) {
                SQLStore sqlStore = (SQLStore)ce.getAssetStore();
                try {
                    sqlStore.checkTable();
                    sqlStore.checkColumns();
                }
                catch (SQLException sqlX) {
                    logger.warn("Could not update store table:" + sqlX.getMessage());
                }
            }
            Cleanup assetCleanup = ClientServlet.assetCleanup;
            if (ce.isEnableAssetCleanup() && assetCleanup == null) {
                LockingCleanup ac = new LockingCleanup(logger, "asset cleanup");
                ac.setStopThread(false);
                ac.setStore((Store)ce.getAssetStore());
                ac.addRetentionPolicy((RetentionPolicy)new ValidTimestampPolicy(ce.getMaxAssetLifetime()));
                logger.info("Starting asset cleanup thread");
                assetCleanup = ac;
                assetCleanup.start();
                ClientServlet.assetCleanup = assetCleanup;
            }
            if (ce.isEnableAssetCleanup()) {
                ClientServlet.assetCleanup.getRetentionPolicies().clear();
                ClientServlet.assetCleanup.addRetentionPolicy((RetentionPolicy)new AssetRetentionPolicy(ce.getAssetStore()));
                ce.getMyLogger().info("Finished setting up asset store retention policies");
            }
        } else {
            logger.info("No assets store, so no cleanup possible.");
        }
    }

    public void setEnvironment(AbstractEnvironment environment) {
        this.environment = environment;
    }

    public AbstractServlet getServlet() {
        return this.servlet;
    }

    public void setServlet(AbstractServlet servlet) {
        this.servlet = servlet;
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new OA2ClientExceptionHandler((ClientServlet)this.getServlet(), this.getEnvironment().getMyLogger());
        }
        return this.exceptionHandler;
    }
}

