/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.client.loader;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.NFWException;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.servlet.ServiceClient;
import edu.uiuc.ncsa.security.util.crypto.CertUtil;
import edu.uiuc.ncsa.security.util.crypto.KeyUtil;
import edu.uiuc.ncsa.security.util.crypto.MyPKCS10CertRequest;
import edu.uiuc.ncsa.security.util.crypto.PEMFormatUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import java.net.URI;
import java.security.KeyPair;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.sf.json.JSONObject;
import org.oa4mp.client.api.Asset;
import org.oa4mp.client.api.AssetResponse;
import org.oa4mp.client.api.ClientEnvironment;
import org.oa4mp.client.api.OA4MPService;
import org.oa4mp.client.loader.NoSuchAssetException;
import org.oa4mp.client.loader.OA2Asset;
import org.oa4mp.client.loader.OA2ClientEnvironment;
import org.oa4mp.delegation.client.request.ATResponse;
import org.oa4mp.delegation.client.request.DelegatedAssetRequest;
import org.oa4mp.delegation.client.request.DelegatedAssetResponse;
import org.oa4mp.delegation.client.request.RFC6749_4_4Request;
import org.oa4mp.delegation.client.request.RFC6749_4_4_Response;
import org.oa4mp.delegation.client.request.RFC7009Request;
import org.oa4mp.delegation.client.request.RFC7523Request;
import org.oa4mp.delegation.client.request.RFC7523Response;
import org.oa4mp.delegation.client.request.RFC7662Request;
import org.oa4mp.delegation.client.request.RTRequest;
import org.oa4mp.delegation.client.request.RTResponse;
import org.oa4mp.delegation.client.request.UIRequest;
import org.oa4mp.delegation.client.request.UIResponse;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.common.token.MyX509Certificates;
import org.oa4mp.delegation.common.token.RefreshToken;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.AuthorizationGrantImpl;
import org.oa4mp.delegation.common.token.impl.IDTokenImpl;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenFactory;
import org.oa4mp.delegation.common.token.impl.TokenImpl;
import org.oa4mp.delegation.server.NonceHerder;
import org.oa4mp.delegation.server.UserInfo;
import org.oa4mp.delegation.server.client.ATResponse2;
import org.oa4mp.delegation.server.client.ATServer2;
import org.oa4mp.delegation.server.client.DS2;
import org.oa4mp.delegation.server.client.RFC7523Utils;
import org.oa4mp.delegation.server.jwt.MyOtherJWTUtil2;
import org.oa4mp.delegation.server.server.InvalidNonceException;

public class OA2MPService
extends OA4MPService {
    public static final int EXCHANGE_ID_TOKEN = 100;
    public static final int EXCHANGE_ACCESS_TOKEN = 50;
    public static final int EXCHANGE_REFRESH_TOKEN = 10;
    public static final int EXCHANGE_DEFAULT = 0;

    public void preGetCert(Asset asset, Map parameters) {
        super.preGetCert(asset, parameters);
        OA2Asset a = (OA2Asset)asset;
        parameters.put("certreq", PEMFormatUtil.bytesToChunkedString((byte[])asset.getCertReq().getEncoded()));
        if (!parameters.containsKey(this.getEnvironment().getConstants().get("oa4mp:callback_uri"))) {
            parameters.put(this.getEnvironment().getConstants().get("oa4mp:callback_uri"), this.getEnvironment().getCallback().toString());
        }
        if (0L <= this.getEnvironment().getCertLifetime()) {
            parameters.put("certlifetime", this.getEnvironment().getCertLifetime());
        }
        if (asset.getCertificates() != null) {
            MyPKCS10CertRequest certRequest = asset.getCertReq();
            KeyPair keyPair = null;
            if (certRequest == null) {
                try {
                    keyPair = KeyUtil.generateKeyPair();
                }
                catch (Throwable e) {
                    String msg = "Unable to generate a new keypair.";
                    this.getEnvironment().getMyLogger().warn(msg, e);
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new GeneralException(msg, e);
                }
                asset.setPrivateKey(keyPair.getPrivate());
            } else {
                keyPair = new KeyPair(certRequest.getPublicKey(), asset.getPrivateKey());
            }
            if (asset.getPrivateKey() == null) {
                String msg = "The private key is missing. The internal state of the asset is invalid";
                NFWException x = new NFWException(msg);
                this.getEnvironment().getMyLogger().warn(msg, (Throwable)x);
                throw x;
            }
            try {
                asset.setCertReq(CertUtil.createCertRequest((KeyPair)keyPair));
            }
            catch (Throwable t) {
                String msg = "could not create cert request.";
                this.getEnvironment().getMyLogger().warn(msg, t);
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new GeneralException(msg, t);
            }
        }
    }

    protected Map<String, Object> getATParameters(Asset asset, AuthorizationGrant ag) {
        Map m = super.getATParameters(asset, ag);
        OA2Asset a = (OA2Asset)asset;
        if (a == null) {
            throw new GeneralException("Asset not found. You may need to clear your browser cookies.");
        }
        m.put("nonce", a.getNonce());
        m.put("state", a.getState());
        return m;
    }

    public String getRequestedScopes() {
        boolean firstPass = true;
        Object requestedScopes = "";
        HashSet<String> targetScopes = new HashSet<String>();
        Collection<String> scopeList = ((OA2ClientEnvironment)this.getEnvironment()).getScopes();
        targetScopes.addAll(scopeList);
        for (String scope : targetScopes) {
            if (firstPass) {
                requestedScopes = scope;
                firstPass = false;
                continue;
            }
            requestedScopes = (String)requestedScopes + " " + scope;
        }
        return requestedScopes;
    }

    public ATResponse2 rfc8628Request(OA2Asset asset, String deviceCode, Map<String, String> additionalParameters) {
        DelegatedAssetRequest dar = new DelegatedAssetRequest();
        dar.setRfc8628(true);
        dar.setAuthorizationGrant((AuthorizationGrant)new AuthorizationGrantImpl(URI.create(deviceCode)));
        dar.setClient(this.getEnvironment().getClient());
        dar.setKeyID(this.getEnvironment().getKid());
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(additionalParameters);
        dar.setParameters(map);
        return this.processAtRequest(asset, dar);
    }

    public void preRequestCert(Asset asset, Map parameters) {
        if (!parameters.containsKey(this.getEnvironment().getConstants().get("oa4mp:callback_uri"))) {
            if (this.getEnvironment().getCallback() == null) {
                throw new IllegalArgumentException("missing callback in configuration");
            }
            parameters.put(this.getEnvironment().getConstants().get("oa4mp:callback_uri"), this.getEnvironment().getCallback().toString());
        }
        OA2Asset a = (OA2Asset)asset;
        a.setNonce(NonceHerder.createNonce());
        parameters.put("response_type", "code");
        Object s = this.getRequestedScopes();
        if (parameters.containsKey("scope")) {
            s = (String)s + " " + String.valueOf(parameters.get("scope"));
        }
        parameters.put("scope", s);
        if (parameters.containsKey("state")) {
            a.setState((String)parameters.get("state"));
        } else {
            String state = NonceHerder.createNonce();
            a.setState(state);
            parameters.put("state", state);
        }
        if (parameters.containsKey("nonce")) {
            a.setNonce((String)parameters.get("nonce"));
        } else {
            String none = NonceHerder.createNonce();
            parameters.put("nonce", none);
            a.setNonce(none);
        }
        parameters.put("prompt", "login");
        parameters.putAll(((OA2ClientEnvironment)this.getEnvironment()).getAdditionalParameters());
    }

    public OA2MPService(ClientEnvironment environment) {
        super(environment);
    }

    public ATResponse2 getAccessToken(OA2Asset asset, AuthorizationGrant ag, Map<String, Object> additionalParameters) {
        DelegatedAssetRequest dar = new DelegatedAssetRequest();
        dar.setAuthorizationGrant(ag);
        dar.setClient(this.getEnvironment().getClient());
        dar.setKeyID(this.getEnvironment().getKid());
        HashMap<String, Object> m1 = new HashMap<String, Object>();
        m1.putAll(this.getATParameters(asset, ag));
        if (additionalParameters != null) {
            m1.putAll(additionalParameters);
        }
        dar.setParameters(m1);
        return this.processAtRequest(asset, dar);
    }

    private ATResponse2 processAtRequest(OA2Asset asset, DelegatedAssetRequest dar) {
        ATResponse2 atResponse2 = (ATResponse2)this.getEnvironment().getDelegationService().getAT(dar);
        asset.setIssuedAt(new Date(atResponse2.getAccessToken().getIssuedAt()));
        if (atResponse2.hasIDToken() && atResponse2.getIdToken().getPayload().containsKey((Object)"sub")) {
            asset.setUsername(atResponse2.getIdToken().getPayload().getString("sub"));
            asset.setIdToken(atResponse2.getIdToken());
        }
        if (atResponse2.getParameters().containsKey("nonce") && !NonceHerder.hasNonce((String)((String)atResponse2.getParameters().get("nonce")))) {
            throw new InvalidNonceException("Unknown nonce.");
        }
        NonceHerder.removeNonce((String)((String)atResponse2.getParameters().get("nonce")));
        asset.setAccessToken((AccessTokenImpl)atResponse2.getAccessToken());
        if (atResponse2.hasRefreshToken()) {
            asset.setRefreshToken(atResponse2.getRefreshToken());
        }
        this.getAssetStore().save((Identifiable)asset);
        return atResponse2;
    }

    public ATResponse2 getAccessToken(OA2Asset asset, AuthorizationGrant ag) {
        return this.getAccessToken(asset, ag, null);
    }

    public AssetResponse getCert(OA2Asset a, ATResponse2 atResponse2) {
        KeyPair keyPair = this.getNextKeyPair();
        MyPKCS10CertRequest certReq = null;
        try {
            certReq = CertUtil.createCertRequest((KeyPair)keyPair, (String)a.getUsername());
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new GeneralException("Could not create cert request", e);
        }
        a.setPrivateKey(keyPair.getPrivate());
        a.setCertReq(certReq);
        HashMap m1 = new HashMap();
        m1.putAll(this.getAssetParameters(a));
        this.preGetCert(a, m1);
        DelegatedAssetResponse daResp = this.getEnvironment().getDelegationService().getCert((ATResponse)atResponse2, this.getEnvironment().getClient(), m1);
        AssetResponse par = new AssetResponse();
        MyX509Certificates myX509Certificate = (MyX509Certificates)daResp.getProtectedAsset();
        par.setX509Certificates(myX509Certificate.getX509Certificates());
        this.postGetCert(a, par);
        a.setCertificates(par.getX509Certificates());
        this.getEnvironment().getAssetStore().save((Identifiable)a);
        return par;
    }

    protected AssetResponse getCert(Asset a, AuthorizationGrant ag) {
        OA2Asset asset = (OA2Asset)a;
        ATResponse2 atResp = this.getAccessToken(asset, ag);
        return this.getCert(asset, atResp);
    }

    public RTResponse refresh(String identifier) {
        return this.refresh(identifier, null);
    }

    public RTResponse refresh(String assetID, Map additionalParameters) {
        OA2Asset asset = this.getAsset2(assetID);
        if (asset == null) {
            throw new NoSuchAssetException("Asset with id \"" + assetID + "\" not found.");
        }
        DS2 ds2 = (DS2)this.getEnvironment().getDelegationService();
        RTRequest rtRequest = new RTRequest(this.getEnvironment().getClient(), this.getEnvironment().getKid(), additionalParameters);
        rtRequest.setAccessToken((AccessToken)asset.getAccessToken());
        rtRequest.setRefreshToken((RefreshToken)asset.getRefreshToken());
        RTResponse rtResponse = ds2.refresh(rtRequest);
        asset.setAccessToken((AccessTokenImpl)rtResponse.getAccessToken());
        if (rtResponse.hasRefreshToken()) {
            asset.setRefreshToken(rtResponse.getRefreshToken());
        }
        if (rtResponse.hasIDToken()) {
            asset.setIdToken(rtResponse.getIdToken());
        }
        this.getAssetStore().remove((Object)asset.getIdentifier());
        this.getAssetStore().save((Identifiable)asset);
        return rtResponse;
    }

    public UserInfo getUserInfo(String identifier) {
        OA2Asset asset = this.getAsset2(identifier);
        if (asset == null || asset.getAccessToken() == null) {
            return null;
        }
        UIRequest uiRequest = new UIRequest((AccessToken)asset.getAccessToken());
        uiRequest.setClient(this.getEnvironment().getClient());
        DS2 ds2 = (DS2)this.getEnvironment().getDelegationService();
        UIResponse resp = ds2.getUserInfo(uiRequest);
        JSONObject json = JSONObject.fromObject((Object)resp.getRawJSON());
        UserInfo ui = new UserInfo();
        ui.setMap((Map)json);
        return ui;
    }

    protected OA2Asset getAsset2(String id) {
        return (OA2Asset)this.getAssetStore().get(id);
    }

    public OA2Asset getCert(String id) {
        OA2Asset asset = this.getAsset2(id);
        if (asset == null) {
            throw new NoSuchAssetException("Asset \"" + id + "\" not found");
        }
        AssetResponse assetResponse = this.getCert(asset.getAccessToken().getToken(), null);
        asset.setCertificates(assetResponse.getX509Certificates());
        asset.setUsername(assetResponse.getUsername());
        this.getAssetStore().save((Identifiable)asset);
        return asset;
    }

    public JSONObject exchangeRefreshToken(OA2Asset asset, TokenImpl subjectToken, Map additionalParameters, int requestedTokenType, String subjectType, boolean isErsatz) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("subject_token", subjectToken.getToken());
        switch (subjectType) {
            case "access_token": {
                parameterMap.put("subject_token_type", "urn:ietf:params:oauth:token-type:access_token");
                break;
            }
            case "refresh_token": {
                parameterMap.put("subject_token_type", "urn:ietf:params:oauth:token-type:refresh_token");
                break;
            }
            case "id_token": {
                parameterMap.put("subject_token_type", "urn:ietf:params:oauth:token-type:id_token");
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown subject type \"" + subjectType + "\"");
            }
        }
        switch (requestedTokenType) {
            case 50: {
                parameterMap.put("requested_token_type", "urn:ietf:params:oauth:token-type:access_token");
                break;
            }
            case 10: {
                parameterMap.put("requested_token_type", "urn:ietf:params:oauth:token-type:refresh_token");
                break;
            }
            case 100: {
                parameterMap.put("requested_token_type", "urn:ietf:params:oauth:token-type:id_token");
                break;
            }
        }
        if (additionalParameters != null) {
            parameterMap.putAll(additionalParameters);
        }
        return this.exchangeIt(asset, parameterMap, isErsatz);
    }

    protected JSONObject exchangeIt(OA2Asset asset, Map<String, String> additionalParameters, boolean isErsatz) {
        ServiceClient serviceClient = this.getServiceClient();
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (additionalParameters != null) {
            parameterMap.putAll(additionalParameters);
        }
        parameterMap.put("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange");
        Client client = this.getEnvironment().getClient();
        OA2ClientEnvironment oa2ClientEnvironment = (OA2ClientEnvironment)this.getEnvironment();
        String rawResponse = oa2ClientEnvironment.hasJWKS() ? RFC7523Utils.doPost((ServiceClient)serviceClient, (BaseClient)client, (URI)oa2ClientEnvironment.getAccessTokenUri(), (String)oa2ClientEnvironment.getKid(), parameterMap) : serviceClient.doGet(parameterMap, client.getIdentifierString(), client.getSecret());
        DebugUtil.trace((Object)((Object)this), (String)("raw response = " + rawResponse));
        JSONObject json = JSONObject.fromObject((Object)rawResponse);
        JSONWebKeys keys = MyOtherJWTUtil2.getJsonWebKeys((ServiceClient)serviceClient, (String)((OA2ClientEnvironment)this.getEnvironment()).getWellKnownURI());
        if (isErsatz) {
            asset.setRefreshToken(TokenFactory.createRT((String)json.getString("refresh_token")));
            if (!json.getString("issued_token_type").equals("urn:ietf:params:oauth:token-type:refresh_token")) {
                asset.setIdToken(TokenFactory.createIDT((String)json.getString("access_token")));
                asset.setAccessToken(TokenFactory.createAT((String)json.getString("access_token")));
            }
        } else {
            switch (json.getString("issued_token_type")) {
                case "urn:ietf:params:oauth:token-type:refresh_token": {
                    asset.setRefreshToken(TokenFactory.createRT((String)json.getString("refresh_token")));
                    break;
                }
                case "urn:ietf:params:oauth:token-type:access_token": {
                    asset.setAccessToken(TokenFactory.createAT((String)json.getString("access_token")));
                    break;
                }
                case "urn:ietf:params:oauth:token-type:id_token": {
                    asset.setIdToken(TokenFactory.createIDT((String)json.getString("access_token")));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown token type \"" + json.getString("issued_token_type") + "\"");
                }
            }
        }
        this.getEnvironment().getAssetStore().save((Identifiable)asset);
        return json;
    }

    public ServiceClient getServiceClient() {
        ATServer2 atServer2 = (ATServer2)this.getEnvironment().getDelegationService().getAtServer();
        return atServer2.getServiceClient();
    }

    public ServiceClient getRFC8623ServiceClient() {
        DS2 ds2 = (DS2)this.getEnvironment().getDelegationService();
        return ds2.getRfc8623Server().getServiceClient();
    }

    protected void updateExchangedAsset(OA2Asset asset, JSONObject claims) {
    }

    protected TokenImpl figureOutToken(String rawToken, boolean isRT) {
        try {
            JSONObject[] json = MyOtherJWTUtil2.readJWT((String)rawToken);
            URI jti = URI.create(json[1].getString("jti"));
            if (isRT) {
                return new RefreshTokenImpl(rawToken, jti);
            }
            return new AccessTokenImpl(rawToken, jti);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (isRT) {
                return new RefreshTokenImpl(URI.create(rawToken));
            }
            return new AccessTokenImpl(URI.create(rawToken));
        }
    }

    protected void OLDupdateExchangedAsset(OA2Asset asset, JSONObject claims) {
        boolean saveAsset = false;
        if (claims.containsKey((Object)"issued_token_type")) {
            String token = claims.getString("access_token");
            if (claims.getString("issued_token_type").equals("urn:ietf:params:oauth:token-type:access_token") && token != null && !token.isEmpty()) {
                AccessTokenImpl at = new AccessTokenImpl(URI.create(token));
                asset.setAccessToken(at);
                saveAsset = true;
            }
            if (claims.getString("issued_token_type").equals("urn:ietf:params:oauth:token-type:refresh_token") && token != null && !token.isEmpty()) {
                RefreshTokenImpl refreshToken = new RefreshTokenImpl(URI.create(token));
                asset.setRefreshToken(refreshToken);
                saveAsset = true;
            }
        }
        if (saveAsset) {
            this.getEnvironment().getAssetStore().save((Identifiable)asset);
        }
    }

    public boolean revoke(OA2Asset dummyAsset, boolean revokeRT) {
        RFC7009Request request = new RFC7009Request();
        request.setAccessToken(dummyAsset.getAccessToken());
        request.setClient(this.getEnvironment().getClient());
        request.setKeyID(this.getEnvironment().getKid());
        request.setTokenEndpoint(this.getEnvironment().getAccessTokenUri());
        if (revokeRT) {
            request.setRefreshToken(dummyAsset.getRefreshToken());
        }
        DS2 ds2 = (DS2)this.getEnvironment().getDelegationService();
        ds2.rfc7009(request);
        return true;
    }

    public JSONObject introspect(OA2Asset asset, boolean doRT) {
        RFC7662Request request = new RFC7662Request();
        if (doRT) {
            request.setRefreshToken(asset.getRefreshToken());
        } else {
            request.setAccessToken(asset.getAccessToken());
        }
        request.setClient(this.getEnvironment().getClient());
        request.setKeyID(this.getEnvironment().getKid());
        request.setTokenEndpoint(this.getEnvironment().getAccessTokenUri());
        DS2 ds2 = (DS2)this.getEnvironment().getDelegationService();
        return ds2.rfc7662(request).getResponse();
    }

    public JSONObject rfc6749_4_4(OA2Asset asset, Map parameters, boolean useRFC7523) {
        RFC6749_4_4Request req;
        if (useRFC7523) {
            if (!this.getEnvironment().hasJWKS()) {
                throw new IllegalArgumentException("sorry, but this client does not have any keys.");
            }
            req = new RFC6749_4_4Request(this.getEnvironment().getClient(), parameters, this.getEnvironment().getKid());
        } else {
            if (StringUtils.isTrivial((String)this.getEnvironment().getClient().getSecret())) {
                throw new IllegalArgumentException("sorry, but this client does not have a secret. Cannot start a flow that requires a secret.");
            }
            parameters.put("client_id", this.getEnvironment().getClient().getIdentifierString());
            parameters.put("client_secret", this.getEnvironment().getClient().getSecret());
            req = new RFC6749_4_4Request();
        }
        req.setParameters(parameters);
        DS2 ds2 = (DS2)this.getEnvironment().getDelegationService();
        RFC6749_4_4_Response response = ds2.rfc6749_4_4(req);
        JSONObject json = response.getJSON();
        if (json.containsKey((Object)"nonce") && !NonceHerder.hasNonce((String)((String)json.get("nonce")))) {
            throw new InvalidNonceException("Unknown nonce.");
        }
        NonceHerder.removeNonce((String)((String)json.get("nonce")));
        if (!json.containsKey((Object)"access_token")) {
            throw new IllegalArgumentException("No access token found in server response");
        }
        AccessTokenImpl at = TokenFactory.createAT((String)json.getString("access_token"));
        asset.setAccessToken(at);
        if (json.containsKey((Object)"id_token")) {
            IDTokenImpl idt = TokenFactory.createIDT((String)json.getString("id_token"));
            asset.setIdToken(idt);
        }
        if (json.containsKey((Object)"refresh_token")) {
            RefreshTokenImpl rt = TokenFactory.createRT((String)json.getString("refresh_token"));
            asset.setRefreshToken(rt);
        } else {
            asset.setRefreshToken(null);
        }
        this.getAssetStore().save((Identifiable)asset);
        return json;
    }

    public JSONObject rfc7523(OA2Asset asset, Map parameters) {
        RFC7523Request request = new RFC7523Request();
        request.setKeyID(this.getEnvironment().getKid());
        request.setClient(this.getEnvironment().getClient());
        request.setParameters(parameters);
        DS2 ds2 = (DS2)this.getEnvironment().getDelegationService();
        RFC7523Response response = ds2.rfc7523(request);
        JSONObject json = response.getResponse();
        asset.setUsername((String)json.get("sub"));
        if (json.containsKey((Object)"nonce") && !NonceHerder.hasNonce((String)((String)json.get("nonce")))) {
            throw new InvalidNonceException("Unknown nonce.");
        }
        NonceHerder.removeNonce((String)((String)json.get("nonce")));
        if (!json.containsKey((Object)"access_token")) {
            throw new IllegalArgumentException("No access token found in server response");
        }
        AccessTokenImpl at = TokenFactory.createAT((String)json.getString("access_token"));
        asset.setIssuedAt(new Date(at.getIssuedAt()));
        asset.setAccessToken(at);
        RefreshTokenImpl rt = null;
        if (json.containsKey((Object)"refresh_token")) {
            rt = TokenFactory.createRT((String)json.getString("refresh_token"));
            asset.setRefreshToken(rt);
        }
        if (response.getIdToken() != null) {
            asset.setIdToken(response.getIdToken());
        }
        this.getAssetStore().save((Identifiable)asset);
        return response.getResponse();
    }
}

