/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.client.loader.servlet;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.servlet.AbstractServlet;
import edu.uiuc.ncsa.security.servlet.ExceptionHandlerThingie;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import edu.uiuc.ncsa.security.servlet.ServiceClientHTTPException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.oa4mp.client.api.servlet.ClientExceptionHandler;
import org.oa4mp.client.api.servlet.ClientServlet;
import org.oa4mp.delegation.server.OA2RedirectableError;

public class OA2ClientExceptionHandler
extends ClientExceptionHandler {
    public OA2ClientExceptionHandler(ClientServlet clientServlet, MyLoggingFacade myLogger) {
        super(clientServlet, myLogger);
    }

    public void handleException(ExceptionHandlerThingie xh) throws IOException, ServletException {
        Throwable t = xh.throwable;
        HttpServletRequest request = xh.request;
        HttpServletResponse response = xh.response;
        int status = 500;
        if (this.getLogger() != null) {
            String message = "error(" + AbstractServlet.getRequestIPAddress((HttpServletRequest)request) + "):\"" + t.getMessage() + "\"";
            this.getLogger().warn(message);
        }
        if (t instanceof OA2RedirectableError) {
            this.getLogger().info("get a standard error with a redirect");
            OA2RedirectableError oa2RedirectableError = (OA2RedirectableError)t;
            request.setAttribute("error", (Object)oa2RedirectableError.getError());
            request.setAttribute("error_description", (Object)oa2RedirectableError.getDescription());
            request.setAttribute("state", (Object)oa2RedirectableError.getState());
            status = oa2RedirectableError.getHttpStatus();
        } else if (t instanceof ServiceClientHTTPException) {
            ServiceClientHTTPException tt = (ServiceClientHTTPException)t;
            this.getLogger().info("got standard error with http status code = " + tt.getStatus());
            if (!tt.hasContent()) {
                this.defaultSCXresponse(tt, request);
                Object error = request.getAttribute("error");
                Object error_description = request.getAttribute("error_description");
                this.getLogger().warn("Forwarding error = \"" + (error != null ? error.toString() : "NOT SET") + "\", error_description = \"" + (error_description != null ? error_description.toString() : "NOT SET") + "\"");
            } else {
                try {
                    this.parseContent(tt.getContent(), request);
                }
                catch (GeneralException xx) {
                    this.defaultSCXresponse(tt, request);
                }
            }
        } else {
            this.getLogger().warn("Got exception of type " + t.getClass().getSimpleName(), t);
            response.setStatus(status);
            request.setAttribute("error", (Object)t.getClass().getSimpleName());
            request.setAttribute("error_description", (Object)t.getMessage());
        }
        request.setAttribute("action", (Object)this.getNormalizedContextPath());
        JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)this.clientServlet.getCE().getErrorPagePath());
    }

    protected void parseContent(String content, HttpServletRequest request) {
        boolean hasValidContent = false;
        StringTokenizer st = new StringTokenizer(content, "\n");
        while (st.hasMoreElements()) {
            String currentLine = st.nextToken();
            StringTokenizer clST = new StringTokenizer(currentLine, "=");
            if (!clST.hasMoreTokens() || clST.countTokens() != 2) continue;
            try {
                request.setAttribute(clST.nextToken(), (Object)URLDecoder.decode(clST.nextToken(), "UTF-8"));
            }
            catch (UnsupportedEncodingException xx) {
                request.setAttribute(clST.nextToken(), (Object)clST.nextToken());
            }
            hasValidContent = true;
        }
        if (!hasValidContent) {
            this.getLogger().warn("Body or error was not parseable");
            throw new GeneralException();
        }
    }

    protected void defaultSCXresponse(ServiceClientHTTPException tt, HttpServletRequest request) {
        request.setAttribute("error", (Object)tt.getClass().getSimpleName());
        request.setAttribute("error_description", (Object)("Status code=" + tt.getStatus() + ", message=\"" + tt.getMessage() + "\""));
        if (tt.getStatus() > 0) {
            request.setAttribute("error_description", (Object)("Status code=" + tt.getStatus() + ", message=\"" + tt.getMessage() + "\""));
        } else {
            request.setAttribute("error_description", (Object)tt.getMessage());
        }
    }
}

