/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.client.loader.servlet;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.NFWException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.core.util.TokenUtil;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import edu.uiuc.ncsa.security.util.crypto.CertUtil;
import edu.uiuc.ncsa.security.util.crypto.KeyUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKey;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import java.net.URI;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import net.sf.json.util.JSONUtils;
import org.apache.commons.codec.binary.Base64;
import org.oa4mp.client.api.AssetResponse;
import org.oa4mp.client.api.servlet.ClientServlet;
import org.oa4mp.client.loader.OA2Asset;
import org.oa4mp.client.loader.OA2ClientEnvironment;
import org.oa4mp.client.loader.OA2MPService;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.common.token.impl.AuthorizationGrantImpl;
import org.oa4mp.delegation.common.token.impl.IDTokenImpl;
import org.oa4mp.delegation.server.JWTUtil;
import org.oa4mp.delegation.server.OA2GeneralError;
import org.oa4mp.delegation.server.UserInfo;
import org.oa4mp.delegation.server.client.ATResponse2;
import org.oa4mp.delegation.server.client.ATServer2;
import org.oa4mp.delegation.server.jwt.MyOtherJWTUtil2;

public class OA2ReadyServlet
extends ClientServlet {
    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        AccessToken accessToken;
        if (request.getParameterMap().containsKey("error")) {
            throw new OA2GeneralError(request.getParameter("error"), request.getParameter("error_description"), 400, request.getParameter("state"));
        }
        this.info("2.a.0 Getting token.");
        String token = request.getParameter(OA2ReadyServlet.CONST((String)"oa4mp:token"));
        if (TokenUtil.isBase32((String)token)) {
            token = TokenUtil.b32DecodeToken((String)token);
        }
        String state = request.getParameter("state");
        if (token == null) {
            this.warn("2.a.1 The token is " + (token == null ? "null" : token) + ".");
            GeneralException ge = new GeneralException(" This servlet requires parameters for the token.");
            request.setAttribute("exception", (Object)ge);
            JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)this.getCE().getErrorPagePath());
            return;
        }
        this.info("2.a.2 Token found.");
        DebugUtil.trace((Object)((Object)this), (String)("token = '" + token + "'"));
        DebugUtil.trace((Object)((Object)this), (String)("state = '" + state + "'"));
        OA2ClientEnvironment oa2ce = (OA2ClientEnvironment)this.getCE();
        AuthorizationGrantImpl grant = new AuthorizationGrantImpl(URI.create(token));
        this.info("2.a.3 Getting the token from the service");
        String identifier = this.clearCookie(request, response);
        OA2Asset asset = null;
        if (identifier == null && (asset = (OA2Asset)this.getCE().getAssetStore().getByToken(BasicIdentifier.newID((String)token))) != null) {
            identifier = asset.getIdentifierString();
        }
        AssetResponse assetResponse = null;
        OA2MPService oa2MPService = (OA2MPService)this.getOA4MPService();
        String rawAT = null;
        UserInfo ui = null;
        boolean getCerts = oa2ce.getScopes().contains("edu.uiuc.ncsa.myproxy.getcert");
        boolean gotCertX = false;
        String certXMessage = null;
        if (identifier == null) {
            String msg = " no cookie found. Cannot save certificates";
            this.warn(msg);
            this.debug("No cookie found");
            ATResponse2 atResponse2 = oa2MPService.getAccessToken(asset, (AuthorizationGrant)grant);
            accessToken = atResponse2.getAccessToken();
            rawAT = accessToken.getToken();
            ui = oa2MPService.getUserInfo(atResponse2.getAccessToken().toString());
            if (getCerts) {
                try {
                    assetResponse = oa2MPService.getCert(asset, atResponse2);
                }
                catch (Throwable t) {
                    getCerts = false;
                }
            }
        } else {
            asset = (OA2Asset)this.getCE().getAssetStore().get(identifier);
            if (asset.getState() == null || !asset.getState().equals(state)) {
                this.warn("The expected state from the server was \"" + asset.getState() + "\", but instead \"" + state + "\" was returned. Transaction aborted.");
                throw new IllegalArgumentException(" The state returned by the server is invalid.");
            }
            ATResponse2 atResponse2 = oa2MPService.getAccessToken(asset, (AuthorizationGrant)grant);
            accessToken = atResponse2.getAccessToken();
            rawAT = accessToken.getToken();
            ui = oa2MPService.getUserInfo(identifier);
            if (getCerts) {
                this.info("2.b.0 Certs requested, retrieving...");
                try {
                    assetResponse = oa2MPService.getCert(asset, atResponse2);
                }
                catch (Throwable t) {
                    this.info("2.b.1 Error getting cert: " + t.getMessage());
                    gotCertX = true;
                    certXMessage = t.getMessage();
                }
            }
        }
        this.setATInfo(request, accessToken);
        ServletDebugUtil.trace((Object)((Object)this), (String)("show ID token? " + oa2ce.isShowIDToken()));
        if (oa2ce.isOidcEnabled() && oa2ce.isShowIDToken()) {
            ATServer2 atServer2 = (ATServer2)oa2ce.getDelegationService().getAtServer();
            JSONWebKeys jsonWebKeys = atServer2.getJsonWebKeys();
            ServletDebugUtil.trace((Object)((Object)this), (String)("JSON webkeys = " + String.valueOf(jsonWebKeys)));
            IDTokenImpl idToken = (IDTokenImpl)ATServer2.getIDTokenStore().get(accessToken.getJti());
            this.setIDTInfo(request, idToken.getToken(), jsonWebKeys);
        } else {
            this.setIDTInfo(request, null, null);
        }
        this.setATInfo(request, accessToken);
        if (getCerts) {
            if (gotCertX) {
                request.setAttribute("certSubject", (Object)("There was a problem getting the cert:" + certXMessage));
            } else if (assetResponse.getX509Certificates() == null) {
                request.setAttribute("certSubject", (Object)"(no cert returned)");
            } else {
                X509Certificate cert = assetResponse.getX509Certificates()[0];
                request.setAttribute("certSubject", (Object)cert.getSubjectDN());
                request.setAttribute("cert", (Object)CertUtil.toPEM((X509Certificate[])assetResponse.getX509Certificates()));
                request.setAttribute("username", (Object)assetResponse.getUsername());
                if (asset.getPrivateKey() != null) {
                    request.setAttribute("privateKey", (Object)KeyUtil.toPKCS8PEM((PrivateKey)asset.getPrivateKey()));
                } else {
                    request.setAttribute("privateKey", (Object)"(none)");
                }
            }
        } else {
            request.setAttribute("certSubject", (Object)"(no cert)");
        }
        this.info("2.b.2 Done! Displaying success page.");
        if (ui != null) {
            String output = JSONUtils.valueToString((Object)ui.toJSon(), (int)1, (int)0);
            request.setAttribute("userinfo", (Object)output);
        } else {
            request.setAttribute("userinfo", (Object)"no user info returned.");
        }
        Object contextPath = request.getContextPath();
        if (!((String)contextPath).endsWith("/")) {
            contextPath = (String)contextPath + "/";
        }
        request.setAttribute("action", contextPath);
        this.info("2.b.3 Completely finished with delegation.");
        response.setCharacterEncoding("UTF-8");
        this.logOK(request);
        JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)this.getCE().getSuccessPagePath());
    }

    protected void setIDTInfo(HttpServletRequest request, String rawJWT, JSONWebKeys jsonWebKeys) {
        if (rawJWT == null || rawJWT.isEmpty()) {
            request.setAttribute("id_token", (Object)"(none)");
        } else {
            String[] atParts = JWTUtil.decat((String)rawJWT);
            String h = atParts[0];
            JSONObject header = null;
            String p = atParts[1];
            header = JSONObject.fromObject((Object)new String(Base64.decodeBase64((String)h)));
            JSONObject payload = JSONObject.fromObject((Object)new String(Base64.decodeBase64((String)p)));
            request.setAttribute("id_token", (Object)rawJWT);
            request.setAttribute("id_payload", (Object)payload.toString(2));
            request.setAttribute("id_header", (Object)header.toString(2));
            JSONWebKey webKey = (JSONWebKey)jsonWebKeys.get(header.get(JWTUtil.KEY_ID));
            String keyPEM = KeyUtil.toX509PEM((PublicKey)webKey.publicKey);
            request.setAttribute("id_public_key", (Object)StringUtils.wrap((String)keyPEM, (int)80));
        }
    }

    protected void setATInfo(HttpServletRequest request, AccessToken accessToken) {
        this.info("2.b. Formatting access token.");
        String rawAT = accessToken.getToken();
        if (rawAT == null || rawAT.length() == 0) {
            throw new NFWException(" no access token returned.");
        }
        OA2ClientEnvironment oa2ce = (OA2ClientEnvironment)OA2ReadyServlet.getEnvironment();
        ATServer2 atServer2 = (ATServer2)oa2ce.getDelegationService().getAtServer();
        JSONWebKeys jsonWebKeys = atServer2.getJsonWebKeys();
        boolean isVerified = false;
        boolean isSciToken = false;
        try {
            JSONObject scitoken = MyOtherJWTUtil2.verifyAndReadJWT((String)rawAT, (JSONWebKeys)jsonWebKeys);
            request.setAttribute("at_payload", (Object)scitoken.toString(2));
            isVerified = true;
            isSciToken = true;
        }
        catch (Throwable t) {
            request.setAttribute("at_payload", (Object)rawAT);
            isSciToken = false;
        }
        if (isSciToken) {
            int width = 80;
            request.setAttribute("accessToken", (Object)StringUtils.wrap((String)rawAT, (int)width));
            String[] atParts = MyOtherJWTUtil2.decat((String)rawAT);
            String h = atParts[0];
            JSONObject header = null;
            String p = atParts[1];
            try {
                header = JSONObject.fromObject((Object)new String(Base64.decodeBase64((String)h)));
                request.setAttribute("at_accessToken", (Object)rawAT);
                request.setAttribute("at_accessToken2", (Object)StringUtils.wrap((String)rawAT, (int)width));
                request.setAttribute("at_header", (Object)header.toString(2));
                request.setAttribute("at_verified", (Object)Boolean.toString(isVerified));
                JSONWebKey webKey = (JSONWebKey)jsonWebKeys.get(header.get(JWTUtil.KEY_ID));
                String keyPEM = KeyUtil.toX509PEM((PublicKey)webKey.publicKey);
                request.setAttribute("at_public_key", (Object)keyPEM);
            }
            catch (Throwable t) {
                this.getMyLogger().warn("Error decoding header from response", t);
            }
        } else {
            request.setAttribute("at_accessToken", (Object)rawAT);
            request.setAttribute("at_accessToken2", (Object)StringUtils.wrap((String)rawAT, (int)80));
            request.setAttribute("at_header", (Object)"(none)");
            request.setAttribute("at_verified", (Object)"(n/a)");
            request.setAttribute("at_public_key", (Object)"(n/a)");
        }
    }
}

