/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.client.test;

import edu.uiuc.ncsa.security.core.exceptions.InvalidCertRequestException;
import edu.uiuc.ncsa.security.util.crypto.CertUtil;
import edu.uiuc.ncsa.security.util.crypto.MyPKCS10CertRequest;
import junit.framework.TestCase;
import org.junit.Test;

public class PKCS10_CSR_Test
extends TestCase {
    String TEST_WITH_SUBJECT = "MIICVjCCAT4CAQAwETEPMA0GA1UEAwwGaWdub3JlMIIBIjANBgkqhkiG9w0BAQEF\nAAOCAQ8AMIIBCgKCAQEAmvZZgw7WDiXJZYsxQvMc+o+2BRk062MFdeQf8N8W+z/A\ntyUtXu2UWcHW2TX898ZAoNleBMCe7geSKFs4w+v26VeUOCh1bEE3cH3grE/U5Nt1\nRrjM0qyNKB2F4h04nk8fHKLXYl3PaX2gC4WoYroti+wHFnA89mGMJjtuGMQ9wMdH\nsj+Cd52g4ZF08EWE27HkhCpJvylEPVVXIcP9ICsXKjO3bjnq2gs/SzUB1enNugD+\ndHCsr9V7KKmtSsSUDyz2vbm1nAcuNrlNVzC6GSgG04WNyuwY881eUT6oY2kNqClv\noF//PbgB3RTsyI3/0rw131aZIabGJGE0hxysWR8pVQIDAQABoAAwDQYJKoZIhvcN\nAQEFBQADggEBAG21I3LnVcwwkEVqWen2GafHT8tNwkGS7EQGMAIEWZr91bfHkXlI\nspayDEuvVBwf1euIxTyRD7PPEH0FHkUbRXa+tYp9vW+nQY2DvXkT8aVAhUUEaa6V\nBb/8mypQovD1JoUvoOXHXweINUb7D1OSXZ3UkXaKzFK5HSaS6cG/QaVbA5CSbfUD\nyeckoOFWcV1iZPqXxumBH3298LbPGzrrFtL7283CpGJG1CeOBi0grGqOPUDe/2st\nz2IT1KiJQUfCRuYhKTfEX6IePqagtveSTnElbCYOZsIFbzrKnrbtwDzpC7SWd77x\nohGfbITbBDU/9c0GMpItghetvtqcz3W8e+k=\n";
    String TEST_NO_SUBJECT = "MIICRTCCAS0CAQAwADCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALaH\noKW4VCMRfwt1lgisoSMsA5XuEmkFinGbtSUildk4hlvF/6LSkkcOfBZBRsfgIHZv\naX5ppPWSzcXwnY7diN8lgq+o7D9v9qwf878RiONV6o3vti4kjXpGTyRPbbUalSlp\n3mS0G2uBO0hwhOKBv4npqHApxEdgNLSPPzyK2OH8biRRhKOe505eZRSVufzEbxGX\nOsTJTQfp2mQC34Nc2aPBRmhDm/WVDIKCPCKtzYwGvaP1zWaMCPrwzfOw4b0WKJDr\nI+ocgoQOiuOWV6nubw+7R9HzP5YjEaxJQwiyA+0gqhugCZp4iBA6GDdN7KbtXXBz\nT4ymCk1cnCypAVa4gtUCAwEAAaAAMA0GCSqGSIb3DQEBBQUAA4IBAQB8dVDM2Xov\nCmt07czxedn6Afb6ldP7wPbfKZ7NwAeD38pex4G1s72USuProLyE49FjLFhvBxZk\nfk6KQpZSsWI2wsd5YdgO6F3+kKkSjJaRimkuOgd1wYEdOm1WHQHayJafbjhWiTJ8\nOugFWiUzsHnd2Vm77RQDSC00Qk4UGau4N/ww/S4ildGyxCHLVzAW6838aT1Bdqq2\n2JS0JvSUq5ymT8o7N6tF8mTDnHPWkotVXDCpjWo8l2Sv59vfVcvY+m7Qp9cPq0+x\nilHSHXnR6Hbwkn/bwy6/O6IzGCUM0ZwchsiWwdlCMm0EcVWWN5tUPg5jmID8mTwX\nsjl2GAlxGMZ2";
    String BAD_GLOBUS_CR = "MIICRDCCASwCADAAMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAtdf1uEiBpLEeJJd16Ed/4Azz8S2jJ6SxqVK+qY74EjwdzMWK+VuIFzZTXJW66hgH2hbncFwTHXs/m/DrEn7yK2tiI3wcjiEQadOKbL8mBTqDGnXHyKyd0KkP0jwN+jVKNm0HdEn/rLK+jTInXZZptCbUs3pzEv/Mv2pD0ic5TbyvxjpbZOQpnpQPU/o2Ag46ybjl0rsrV4eJok/rE5gn3pLGToHkyzjHYa3cKfdyGszcpzoLXdYKXW9YtlqX1uWsIrHprJkViEkcboGddUTOXE343/CpswRpP2XuAuA65EHDPesPO9HjZxLWvz77pH3R6fgvfNWMvPzrRxfuETFcGwIDAQABoAAwDQYJKoZIhvcNAQEFBQADggEBAASns2q27eu1162Jce9mVNe0uPqAPCxLMU5h2tbbGO2os0fCd5RmZAZIXIRTRveEzFfHiHe1MKB77l69nFQXub+9RRLtooSChrJndJz+3GJtls051Q0hUkQyV1JX52zQQrEC7mYiBqzkcb3OocMa3GnkxfuxL2U/E4wL+IYLxG1SrRoqRL+DB6UPW1giGFGZf2B5KRLQhME+GKIho9QtbOjbwmsNCT9VNCEcz0yvp0UYyNzlbMlauOIpsweootEsrbIvFdldvZ2chWArRaD3/75VArvilE32QMRJlz8cddd3Ije7tk3VNMDPELq2Hi+9fUcwL5xtW8QREUeutL3cN/w=";
    String GOOD_GLOBUS_CR = "MIICRTCCAS0CAQAwADCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMM1\nOjUH6+CAuJwUjNWjqtIdYc4iPyNFKn2RDnuzl5w0znlrB6JBqG7yuQtrbboJ2lZ/\nFayM9VfTYu+IPIrrMI9C29/4Rd9+O4+QqgFl2DiD0TblEpd/ub6pqCRGHv+rgT7z\nLG/xJYrWFjoSfilToOT6NHAoHkQP1V1I2t/TW2YqQBS61EbhX2zci+8ctnYBQBTR\nnNSyTMYqwpUSux7kVZp0yIr7udo4izA/maTd7ab3hQpaX+4P9ue18fcx5gqhG/CA\nkFoqIvWBXOdzC3dJLICR3VOLcC5S8Yt9z9SQ8bNpB6mYYZikte5+70Qy+kKpZB8r\nufEbNw1PmxCb4IBmsy8CAwEAAaAAMA0GCSqGSIb3DQEBBQUAA4IBAQCc7+rbfGPz\noP1WGe1AeUKYODmpSAp1dEzbMyfjccseT3x7WKlUJELUEcWwu95D4BZn+F9DClhJ\nJP+sCdMkWS+LTha+F3ezah/5Htie9Usu3deWmGnZa7FNw0QFYKw3WWGT+HXpVeAK\nTmy0mJ/GqoRzGc7RBJy1mK1qzs09A1Ko1vJVgnUQQZ098QGFewt/aQ3QJaVvGFwZ\ngAB40svp+oCDBguJ2MAdRo6m8klY0IWmg+hwpycW0z/Mk7gP/kYz0CeMzT5TQ/Mn\n78lx7Y0ujC6umb7gMnHZ5MQMYNsjPs7sLH3MqeR2dlL7dx0TEHsHeCT+sUt2Wik0\nblpsel1Ayyew\n";

    @Test
    public void testSubjects() throws Exception {
        MyPKCS10CertRequest certReq = CertUtil.fromStringToCertReq((String)this.GOOD_GLOBUS_CR);
        assert (certReq.getPublicKey() != null);
        certReq = CertUtil.fromStringToCertReq((String)this.TEST_WITH_SUBJECT);
        assert (certReq.getPublicKey() != null);
        certReq = CertUtil.fromStringToCertReq((String)this.TEST_NO_SUBJECT);
        assert (certReq.getPublicKey() != null);
    }

    @Test
    public void testBadCSR() throws Exception {
        block6: {
            MyPKCS10CertRequest certReq2;
            try {
                certReq2 = CertUtil.fromStringToCertReq((String)this.BAD_GLOBUS_CR);
                System.out.println(certReq2.getPublicKey());
                assert (false) : "Was able to process a bad cert request.";
            }
            catch (InvalidCertRequestException certReq2) {
                // empty catch block
            }
            try {
                certReq2 = CertUtil.fromStringToCertReq((String)this.GOOD_GLOBUS_CR);
                assert (certReq2.getPublicKey() != null);
            }
            catch (InvalidCertRequestException iox) {
                iox.printStackTrace();
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)"Good cert request failed to parse correctly.");
            }
        }
    }
}

