/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.client;

import java.net.URI;
import java.util.Map;
import org.oa4mp.delegation.client.request.AGRequest;
import org.oa4mp.delegation.client.request.AGResponse;
import org.oa4mp.delegation.client.request.ATRequest;
import org.oa4mp.delegation.client.request.ATResponse;
import org.oa4mp.delegation.client.request.DelegatedAssetRequest;
import org.oa4mp.delegation.client.request.DelegatedAssetResponse;
import org.oa4mp.delegation.client.request.DelegationRequest;
import org.oa4mp.delegation.client.request.DelegationResponse;
import org.oa4mp.delegation.client.request.PARequest;
import org.oa4mp.delegation.client.request.PAResponse;
import org.oa4mp.delegation.client.server.AGServer;
import org.oa4mp.delegation.client.server.ATServer;
import org.oa4mp.delegation.client.server.PAServer;
import org.oa4mp.delegation.common.services.Request;
import org.oa4mp.delegation.common.services.Response;
import org.oa4mp.delegation.common.services.Server;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.common.token.AuthorizationGrant;

public abstract class DelegationService
implements Server {
    ATServer atServer;
    AGServer agServer;
    PAServer paServer;

    protected DelegationService(AGServer agServer, ATServer atServer, PAServer paServer) {
        this.agServer = agServer;
        this.atServer = atServer;
        this.paServer = paServer;
    }

    public DelegationResponse processDelegationRequest(DelegationRequest delegationRequest) {
        AGRequest agReq = new AGRequest();
        agReq.setClient(delegationRequest.getClient());
        agReq.setParameters(delegationRequest.getParameters());
        AGResponse agResp = (AGResponse)this.getAgServer().process(agReq);
        DelegationResponse delResp = new DelegationResponse(agResp.getAuthorizationGrant());
        delResp.setRedirectUri(this.createRedirectURL(delegationRequest, agResp));
        return delResp;
    }

    protected ATResponse getAT(AuthorizationGrant grant, Client client, Map<String, String> parameters) {
        return this.getAT(grant, client, parameters);
    }

    protected ATResponse getAT(ATRequest atRequest) {
        ATResponse atresp = (ATResponse)this.getAtServer().process(atRequest);
        return atresp;
    }

    public ATResponse getAT(DelegatedAssetRequest delegationAssetRequest) {
        return this.getAT(new ATRequest(delegationAssetRequest));
    }

    public DelegatedAssetResponse processAssetRequest(DelegatedAssetRequest delegationAssetRequest) {
        ATResponse atResp = this.getAT(delegationAssetRequest);
        return this.getCert(atResp, delegationAssetRequest.getClient(), delegationAssetRequest.getAssetParameters());
    }

    public DelegatedAssetResponse getCert(ATResponse atResponse, Client client, Map<String, Object> assetParameters) {
        PARequest paReq = new PARequest();
        paReq.setClient(client);
        paReq.setAccessToken(atResponse.getAccessToken());
        paReq.setParameters(assetParameters);
        PAResponse paResp = (PAResponse)this.getPaServer().process(paReq);
        DelegatedAssetResponse dap = new DelegatedAssetResponse(paResp.getProtectedAsset());
        dap.setAdditionalInformation(paResp.getAdditionalInformation());
        return dap;
    }

    public abstract URI createRedirectURL(DelegationRequest var1, AGResponse var2);

    public Response process(Request request) {
        return request.process((Server)this);
    }

    public ATServer getAtServer() {
        return this.atServer;
    }

    public PAServer getPaServer() {
        return this.paServer;
    }

    public AGServer getAgServer() {
        return this.agServer;
    }
}

