/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.client.request;

import net.sf.json.JSONObject;
import org.oa4mp.delegation.client.request.ATResponse;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.IDTokenImpl;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenFactory;

public class RTResponse
extends ATResponse {
    public static final String REFRESH_TOKEN = "refresh_token";
    public static final String ACCESS_TOKEN = "access_token";
    public static final String VERSION = "version";
    public static final String TYPE = "type";
    public static final String PARAMETERS = "parameters";
    public static final String ID_TOKEN = "id_token";
    RefreshTokenImpl refreshToken = null;
    IDTokenImpl idToken = null;

    public RTResponse(AccessTokenImpl accessToken) {
        super((AccessToken)accessToken);
    }

    public RTResponse(AccessTokenImpl accessToken, RefreshTokenImpl refreshToken, IDTokenImpl idToken) {
        super((AccessToken)accessToken);
        this.refreshToken = refreshToken;
        this.idToken = idToken;
    }

    public RefreshTokenImpl getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(RefreshTokenImpl refreshToken) {
        this.refreshToken = refreshToken;
    }

    public boolean hasRefreshToken() {
        return this.refreshToken != null;
    }

    public IDTokenImpl getIdToken() {
        return this.idToken;
    }

    public void setIdToken(IDTokenImpl idToken) {
        this.idToken = idToken;
    }

    public boolean hasIDToken() {
        return this.idToken != null;
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put((Object)TYPE, (Object)"rt_response");
        json.put((Object)VERSION, (Object)"1.0");
        json.put((Object)ACCESS_TOKEN, (Object)this.getAccessToken().toJSON().toString());
        if (this.hasRefreshToken()) {
            json.put((Object)REFRESH_TOKEN, (Object)this.getRefreshToken().toJSON().toString());
        }
        if (this.hasIDToken()) {
            json.put((Object)ID_TOKEN, (Object)this.getIdToken().toJSON().toString());
        }
        if (!this.parameters.isEmpty()) {
            JSONObject p = new JSONObject();
            p.putAll(this.parameters);
            json.put((Object)PARAMETERS, (Object)p.toString());
        }
        return json;
    }

    public void fromJSON(JSONObject json) {
        if (!json.containsKey((Object)TYPE)) {
            throw new IllegalArgumentException("unknown type for RTResponse deserialization");
        }
        if (!json.getString(TYPE).equals("rt_response")) {
            throw new IllegalArgumentException("unknown type for RTResponse deserialization");
        }
        if (json.getString(VERSION).equals("1.0")) {
            this.setAccessToken((AccessToken)TokenFactory.createAT((JSONObject)JSONObject.fromObject((Object)json.getString(ACCESS_TOKEN))));
            if (json.containsKey((Object)REFRESH_TOKEN)) {
                this.setRefreshToken(TokenFactory.createRT((JSONObject)JSONObject.fromObject((Object)json.getString(REFRESH_TOKEN))));
            }
            if (json.containsKey((Object)ID_TOKEN)) {
                this.setIdToken(TokenFactory.createIDT((JSONObject)JSONObject.fromObject((Object)json.getString(ID_TOKEN))));
            }
            if (json.containsKey((Object)PARAMETERS)) {
                this.parameters = JSONObject.fromObject((Object)json.getString(PARAMETERS));
            }
            return;
        }
        throw new IllegalArgumentException("unknown version for RTResponse deserialization");
    }
}

