/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.client.test.common.storage;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Initializable;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.util.TestBase;
import java.net.URI;
import org.junit.Test;
import org.oa4mp.delegation.client.test.common.storage.FileStoreTest;
import org.oa4mp.delegation.common.storage.TransactionStore;
import org.oa4mp.delegation.common.storage.transactions.BasicTransaction;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.AuthorizationGrant;

public abstract class BaseTransactionStoreTest
extends TestBase {
    protected abstract AuthorizationGrant newAG(URI var1);

    protected AuthorizationGrant newAG() {
        return this.newAG(BaseTransactionStoreTest.createToken((String)"authorizationGrant"));
    }

    protected abstract AccessToken newAT(URI var1);

    protected AccessToken newAT() {
        return this.newAT(BaseTransactionStoreTest.createToken((String)"accessToken"));
    }

    public abstract TransactionStore<? extends BasicTransaction> getStore() throws Exception;

    public TransactionStore getInitializedStore() throws Exception {
        TransactionStore<? extends BasicTransaction> store = this.getStore();
        if (store instanceof Initializable) {
            Initializable initializable = (Initializable)store;
            if (!initializable.isCreated()) {
                initializable.createNew();
            }
            if (!initializable.isInitialized()) {
                initializable.init();
            }
        }
        return store;
    }

    protected BasicTransaction createTransaction(TransactionStore store) {
        String identifier = "urn:test:identifier/" + BaseTransactionStoreTest.getRandomString() + "/" + System.currentTimeMillis();
        FileStoreTest.FakeAuthorizationGrant fag = new FileStoreTest.FakeAuthorizationGrant(identifier);
        BasicTransaction t = (BasicTransaction)store.create();
        t.setAuthorizationGrant((AuthorizationGrant)fag);
        return t;
    }

    @Test
    public void testInitializable() throws Exception {
        TransactionStore<? extends BasicTransaction> store = this.getStore();
        if (!(store instanceof Initializable)) {
            return;
        }
        Initializable initializable = (Initializable)store;
        if (!initializable.isCreated()) {
            initializable.createNew();
        }
        if (!initializable.isInitialized()) {
            initializable.init();
        }
        String identifier = "urn:test:identifier/" + String.valueOf(BaseTransactionStoreTest.getRandom());
        BasicTransaction t = (BasicTransaction)store.create();
        t.setAuthorizationGrant(this.newAG());
        initializable.init();
        assert (!store.containsValue((Object)t));
        t = (BasicTransaction)store.create();
        t.setAuthorizationGrant(this.newAG());
        initializable.destroy();
        assert (!initializable.isCreated());
    }

    @Test
    public void testStore() throws Exception {
        TransactionStore<? extends BasicTransaction> store = this.getInitializedStore();
        AccessToken at = this.newAT();
        BasicTransaction t = this.createTransaction((TransactionStore)store);
        t.setAccessToken(at);
        AuthorizationGrant ag = t.getAuthorizationGrant();
        store.save((Identifiable)t);
        BasicTransaction t2 = (BasicTransaction)store.get((Object)t.getIdentifier());
        assert (t2 != null) : "Could not save file for id=\"" + t.getIdentifierString() + "\"";
        assert (t.equals((Object)t2));
        assert (t.equals((Object)store.get(ag)));
        assert (t.equals((Object)store.get(at)));
        store = this.getStore();
        assert (t.equals((Object)store.get(ag)));
        store = this.getStore();
        assert (t.equals((Object)store.get(at)));
        assert (store.get(this.newAG(BaseTransactionStoreTest.createToken((String)"fake"))) == null);
    }

    public boolean testMapAllValues() {
        return true;
    }

    @Test
    public void testMap() throws Exception {
        TransactionStore store = this.getInitializedStore();
        BasicTransaction t = (BasicTransaction)store.create();
        AuthorizationGrant ag = this.newAG();
        t.setAuthorizationGrant(ag);
        assert (null == store.get((Object)BasicIdentifier.newID((String)ag.getToken())));
        try {
            store.update((Identifiable)t);
            assert (false) : " was able to update an non-existent transaction";
        }
        catch (GeneralException generalException) {
            // empty catch block
        }
        ag = this.newAG();
        AccessToken at = this.newAT();
        t.setAuthorizationGrant(ag);
        t.setAccessToken(at);
        int beforeSaveSize = store.size();
        store.save((Identifiable)t);
        assert (beforeSaveSize + 1 == store.size());
        assert (!store.isEmpty());
        assert (store.containsValue((Object)t));
        assert (store.containsKey((Object)t.getIdentifier()));
        t.setAccessToken(at);
        store.save((Identifiable)t);
        assert (t.equals(store.get((Object)t.getIdentifier())));
        store.remove((Object)t.getIdentifier());
        if (this.testMapAllValues()) {
            assert (beforeSaveSize == store.keySet().size());
            assert (store.keySet().size() == beforeSaveSize);
            assert (store.values().size() == beforeSaveSize);
            assert (store.entrySet().size() == beforeSaveSize);
        }
    }
}

