/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.client.test.common.storage;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.XMLConverter;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.NotImplementedException;
import edu.uiuc.ncsa.security.core.util.IdentifiableProviderImpl;
import edu.uiuc.ncsa.security.core.util.IdentifierProvider;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.oa4mp.delegation.client.test.common.storage.BaseTransactionStoreTest;
import org.oa4mp.delegation.client.test.common.storage.FakeTokenImpl;
import org.oa4mp.delegation.common.storage.TransactionStore;
import org.oa4mp.delegation.common.storage.transactions.BasicTransaction;
import org.oa4mp.delegation.common.storage.transactions.BasicTransactionConverter;
import org.oa4mp.delegation.common.storage.transactions.BasicTransactionProvider;
import org.oa4mp.delegation.common.storage.transactions.FSTransactionStore;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.common.token.TokenForge;

public class FileStoreTest
extends BaseTransactionStoreTest {
    static TransactionStore fileStore = null;

    @Override
    protected AuthorizationGrant newAG(URI id) {
        return new FakeAuthorizationGrant(id.toString());
    }

    @Override
    protected AccessToken newAT(URI id) {
        return new FakeAccessToken(id.toString());
    }

    public static File getTempDir() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File testDir = null;
        try {
            testDir = File.createTempFile("ncsa-test", "", tempDir);
        }
        catch (IOException e) {
            throw new GeneralException("Could not create testing directory \"" + String.valueOf(testDir) + "\"");
        }
        testDir.delete();
        testDir.mkdirs();
        return testDir;
    }

    public TransactionStore<BasicTransaction> getStore() throws IOException {
        if (fileStore == null) {
            TestTokenForge ttf = new TestTokenForge();
            IdentifierProvider<Identifier> idp = new IdentifierProvider<Identifier>("transactions"){};
            BasicTransactionProvider btp = new BasicTransactionProvider((IdentifierProvider)idp);
            fileStore = new TestFileStore(FileStoreTest.getTempDir(), (IdentifiableProviderImpl<BasicTransaction>)btp, ttf);
        }
        return fileStore;
    }

    public static class FakeAccessToken
    extends FakeTokenImpl
    implements AccessToken {
        public FakeAccessToken(String token) {
            super(token);
        }

        public FakeAccessToken(URI token) {
            super(token);
        }

        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            return obj instanceof AccessToken;
        }
    }

    public static class FakeAuthorizationGrant
    extends FakeTokenImpl
    implements AuthorizationGrant {
        public FakeAuthorizationGrant(String token) {
            super(token);
        }

        public FakeAuthorizationGrant(URI token) {
            super(token);
        }

        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            return obj instanceof AuthorizationGrant;
        }
    }

    public static class TestFileStore
    extends FSTransactionStore<BasicTransaction> {
        public List<BasicTransaction> getMostRecent(int n, List<String> attributes) {
            return null;
        }

        public BasicTransaction getByProxyID(Identifier proxyID) {
            throw new NotImplementedException(" This is not yet implemented for cache");
        }

        public XMLConverter getXMLConverter() {
            throw new NotImplementedException(" Method not implemented");
        }

        public TestFileStore(File file, IdentifiableProviderImpl<BasicTransaction> btp, TestTokenForge ttf) throws IOException {
            super(new File(file, "data"), new File(file, "index"), btp, (TokenForge)ttf, (MapConverter)new BasicTransactionConverter(btp, (TokenForge)ttf), true, true);
        }

        public MapConverter getMapConverter() {
            throw new NotImplementedException("  Method not implemented");
        }

        public BasicTransaction create() {
            return new BasicTransaction((Identifier)null);
        }
    }

    protected static class TestTokenForge
    implements TokenForge {
        protected TestTokenForge() {
        }

        public AccessToken getAccessToken(Map<String, String> parameters) {
            return null;
        }

        public AuthorizationGrant getAuthorizationGrant(Map<String, String> parameters) {
            return null;
        }

        public AuthorizationGrant getAuthorizationGrant(HttpServletRequest request) {
            return null;
        }

        public AuthorizationGrant getAuthorizationGrant(String ... tokens) {
            if (tokens.length == 0) {
                return new FakeAuthorizationGrant((String)null);
            }
            return new FakeAuthorizationGrant(tokens[0]);
        }

        public AccessToken getAccessToken(HttpServletRequest request) {
            return null;
        }

        public AccessToken getAccessToken(String ... tokens) {
            if (tokens.length == 0) {
                return new FakeAccessToken((String)null);
            }
            return new FakeAccessToken(tokens[0]);
        }
    }
}

