/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.client.test.common.storage;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.cache.CachedMapFacade;
import edu.uiuc.ncsa.security.core.cache.Cleanup;
import edu.uiuc.ncsa.security.core.cache.MaxCacheSizePolicy;
import edu.uiuc.ncsa.security.core.cache.RetentionPolicy;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.junit.Test;
import org.oa4mp.delegation.client.test.common.storage.BaseTransactionStoreTest;
import org.oa4mp.delegation.client.test.common.storage.FileStoreTest;
import org.oa4mp.delegation.common.storage.TransactionStore;
import org.oa4mp.delegation.common.storage.transactions.BasicTransaction;
import org.oa4mp.delegation.common.storage.transactions.TransactionCache;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.AuthorizationGrant;

public class TransactionCacheTest
extends BaseTransactionStoreTest {
    static TransactionStore transactionStore;

    @Override
    protected AuthorizationGrant newAG(URI id) {
        return new FileStoreTest.FakeAuthorizationGrant(id.toString());
    }

    @Override
    protected AccessToken newAT(URI id) {
        return new FileStoreTest.FakeAccessToken(id.toString());
    }

    public TransactionStore<BasicTransaction> getStore() {
        if (transactionStore == null) {
            transactionStore = new TransactionCache();
        }
        return transactionStore;
    }

    public CachedMapFacade getTransactionCache() {
        return (CachedMapFacade)this.getStore();
    }

    @Test
    public void testCleanup() throws Exception {
        int maxCacheSize = 10;
        Cleanup cc = new Cleanup(new MyLoggingFacade(((Object)((Object)this)).getClass().getSimpleName() + ".testCleanup", true), "test cleanup");
        cc.addRetentionPolicy((RetentionPolicy)new MaxCacheSizePolicy((Map)this.getTransactionCache().getCache(), maxCacheSize));
        cc.setMap((Map)this.getTransactionCache().getCache());
        cc.setEnabledLocking(false);
        HashMap<Identifier, BasicTransaction> hashMap = new HashMap<Identifier, BasicTransaction>();
        for (int i = 0; i < maxCacheSize + 5; ++i) {
            BasicTransaction bt = (BasicTransaction)this.getStore().create();
            bt.setAuthorizationGrant(this.newAG(URI.create("foo:bar" + i + "/baz" + System.currentTimeMillis())));
            hashMap.put(bt.getIdentifier(), bt);
            this.getStore().put((Object)bt.getIdentifier(), (Object)bt);
            this.getStore().save((Identifiable)bt);
        }
        cc.age();
        assert (maxCacheSize == cc.getMap().size());
    }
}

