/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.common.servlet;

import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.LoggingConfigLoader;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.storage.sql.derby.DerbyConnectionPoolProvider;
import edu.uiuc.ncsa.security.storage.sql.mariadb.MariaDBConnectionPoolProvider;
import edu.uiuc.ncsa.security.storage.sql.mysql.MySQLConnectionPoolProvider;
import edu.uiuc.ncsa.security.storage.sql.postgres.PGConnectionPoolProvider;
import org.apache.commons.configuration.tree.ConfigurationNode;

public abstract class DBConfigLoader<T extends AbstractEnvironment>
extends LoggingConfigLoader<T> {
    boolean disableDefaultStore = true;
    MySQLConnectionPoolProvider mySQLConnectionPoolProvider;
    MariaDBConnectionPoolProvider mariaDBConnectionPoolProvider;
    protected DerbyConnectionPoolProvider derbyConnectionPoolProvider;
    PGConnectionPoolProvider pgConnectionPoolProvider = null;

    protected DBConfigLoader(ConfigurationNode node, MyLoggingFacade logger) {
        super(node, logger);
    }

    protected DBConfigLoader(ConfigurationNode node) {
        super(node, null);
    }

    protected boolean isDefaultStoreDisabled(boolean ... x) {
        if (x.length != 0) {
            this.disableDefaultStore = x[0];
        }
        return this.disableDefaultStore;
    }

    public MySQLConnectionPoolProvider getMySQLConnectionPoolProvider() {
        if (this.mySQLConnectionPoolProvider == null) {
            this.mySQLConnectionPoolProvider = this.getMySQLConnectionPoolProvider("oauth", "oauth");
        }
        return this.mySQLConnectionPoolProvider;
    }

    public MariaDBConnectionPoolProvider getMariaDBConnectionPoolProvider() {
        if (this.mariaDBConnectionPoolProvider == null) {
            this.mariaDBConnectionPoolProvider = this.getMariaDBConnectionPoolProvider("oauth", "oauth");
        }
        return this.mariaDBConnectionPoolProvider;
    }

    public PGConnectionPoolProvider getPgConnectionPoolProvider() {
        return this.getPgConnectionPoolProvider("oauth", "oauth");
    }

    public MySQLConnectionPoolProvider getMySQLConnectionPoolProvider(String databaseName, String schema) {
        if (this.mySQLConnectionPoolProvider == null) {
            this.mySQLConnectionPoolProvider = new MySQLConnectionPoolProvider(databaseName, schema);
        }
        return this.mySQLConnectionPoolProvider;
    }

    public MariaDBConnectionPoolProvider getMariaDBConnectionPoolProvider(String databaseName, String schema) {
        if (this.mariaDBConnectionPoolProvider == null) {
            this.mariaDBConnectionPoolProvider = new MariaDBConnectionPoolProvider(databaseName, schema);
        }
        return this.mariaDBConnectionPoolProvider;
    }

    public DerbyConnectionPoolProvider getDerbyConnectionPoolProvider() {
        return this.getDerbyConnectionPoolProvider("", "");
    }

    public DerbyConnectionPoolProvider getDerbyConnectionPoolProvider(String databaseName, String schema) {
        if (this.derbyConnectionPoolProvider == null) {
            this.derbyConnectionPoolProvider = new DerbyConnectionPoolProvider(databaseName, schema);
        }
        return this.derbyConnectionPoolProvider;
    }

    public PGConnectionPoolProvider getPgConnectionPoolProvider(String databaseName, String schema) {
        if (this.pgConnectionPoolProvider == null) {
            this.pgConnectionPoolProvider = new PGConnectionPoolProvider(databaseName, schema);
        }
        return this.pgConnectionPoolProvider;
    }
}

