/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.common.storage;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class JSONUtil {
    String componentName;

    public JSONUtil(String componentName) {
        this.componentName = componentName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public Object getJSONValue(JSONObject json, String key) {
        if (!this.hasKey(json, key)) {
            return null;
        }
        return json.getJSONObject(this.getComponentName()).get(key);
    }

    public JSONObject getJSONObject(JSONObject json, String key) {
        if (!this.hasKey(json, key)) {
            return null;
        }
        return json.getJSONObject(this.getComponentName()).getJSONObject(key);
    }

    public JSONArray getJSONArray(JSONObject json, String key) {
        if (!this.hasKey(json, key)) {
            return null;
        }
        Object object = this.getJSONValue(json, key);
        JSONArray array = JSONArray.fromObject((Object)object);
        return array;
    }

    public String getJSONValueString(JSONObject json, String key) {
        if (!this.hasKey(json, key)) {
            return null;
        }
        Object object = this.getJSONValue(json, key);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public boolean hasKey(JSONObject json, String key) {
        return json.getJSONObject(this.getComponentName()).containsKey((Object)key);
    }

    public boolean getJSONValueBoolean(JSONObject json, String key) {
        if (!this.hasKey(json, key)) {
            return false;
        }
        return json.getJSONObject(this.getComponentName()).getBoolean(key);
    }

    public long getJSONValueLong(JSONObject json, String key) {
        if (!this.hasKey(json, key)) {
            return 0L;
        }
        return json.getJSONObject(this.getComponentName()).getLong(key);
    }

    public int getJSONValueInt(JSONObject json, String key) {
        if (!this.hasKey(json, key)) {
            return 0;
        }
        return json.getJSONObject(this.getComponentName()).getInt(key);
    }

    public void setJSONValue(JSONObject json, String key, Object value) {
        if (value == null) {
            return;
        }
        json.getJSONObject(this.getComponentName()).put((Object)key, value);
    }
}

