/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.common.storage.clients;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.BeanUtils;
import edu.uiuc.ncsa.security.core.util.DateUtils;
import edu.uiuc.ncsa.security.storage.monitored.Monitored;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class BaseClient
extends Monitored {
    JSONWebKeys jwks;
    URI jwksURI;
    String secret;
    String name;
    Date creationTS = new Timestamp(new Date().getTime());
    String email;
    Date lastModifiedTS = new Timestamp(new Date().getTime());
    boolean debugOn = false;
    boolean serviceClient = false;
    Collection<String> serviceClientUsers = null;

    public BaseClient(Identifier identifier) {
        super(identifier);
    }

    public BaseClient clone() {
        BaseClient c = new BaseClient(this.getIdentifier());
        this.populateClone(c);
        return c;
    }

    protected void populateClone(BaseClient c) {
        c.setCreationTS(this.getCreationTS());
        c.setEmail(this.getEmail());
        c.setName(this.getName());
        c.setSecret(this.getSecret());
        c.setJWKS(this.getJWKS());
        c.setJwksURI(this.getJwksURI());
    }

    public URI getJwksURI() {
        return this.jwksURI;
    }

    public void setJwksURI(URI jwksURI) {
        this.jwksURI = jwksURI;
    }

    public boolean hasJWKSURI() {
        return this.jwksURI != null;
    }

    public JSONWebKeys getJWKS() {
        return this.jwks;
    }

    public void setJWKS(JSONWebKeys jwks) {
        this.jwks = jwks;
    }

    public boolean hasJWKS() {
        return this.jwks != null;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getCreationTS() {
        return this.creationTS;
    }

    public void setCreationTS(Date creationTS) {
        this.creationTS = creationTS;
    }

    public Date getLastModifiedTS() {
        return this.lastModifiedTS;
    }

    public void setLastModifiedTS(Date lastModifiedTS) {
        this.lastModifiedTS = lastModifiedTS;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        BaseClient c = (BaseClient)((Object)obj);
        if (!BeanUtils.checkEquals((Object)this.getSecret(), (Object)c.getSecret())) {
            return false;
        }
        if (!BeanUtils.checkEquals((Object)this.getName(), (Object)c.getName())) {
            return false;
        }
        if (!BeanUtils.checkEquals((Object)this.getJwksURI(), (Object)c.getJwksURI())) {
            return false;
        }
        if (!BeanUtils.checkEquals((Object)this.getEmail(), (Object)c.getEmail())) {
            return false;
        }
        return DateUtils.equals((Date)this.getCreationTS(), (Date)c.getCreationTS());
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[name=\"" + this.getName() + "\", id=\"" + this.getIdentifierString() + "\", email=\"" + this.getEmail() + "\", jwks=\"" + String.valueOf(this.hasJWKS() ? this.getJWKS() : "(none)") + "\", jwksURI=\"" + String.valueOf(this.hasJWKS() ? this.getJwksURI() : "(none)") + "\", secret=" + (this.getSecret() == null ? "(none)" : this.getSecret().substring(0, 25)) + "]";
    }

    public boolean isDebugOn() {
        return this.debugOn;
    }

    public void setDebugOn(boolean debugOn) {
        this.debugOn = debugOn;
    }

    public boolean isServiceClient() {
        return this.serviceClient;
    }

    public void setServiceClient(boolean serviceClient) {
        this.serviceClient = serviceClient;
    }

    public Collection<String> getServiceClientUsers() {
        if (this.serviceClientUsers == null) {
            this.serviceClientUsers = new ArrayList<String>();
            this.serviceClientUsers.add("*");
        }
        return this.serviceClientUsers;
    }

    public void setServiceClientUsers(Collection<String> serviceClientUsers) {
        this.serviceClientUsers = serviceClientUsers;
    }

    public boolean hasServiceClientUsers() {
        return this.serviceClientUsers != null;
    }
}

