/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.common.storage.clients;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.Iso8601;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.monitored.MonitoredConverter;
import edu.uiuc.ncsa.security.storage.monitored.MonitoredKeys;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeyUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import edu.uiuc.ncsa.security.util.jwk.JWKUtil2;
import java.net.URI;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.oa4mp.delegation.common.storage.JSONUtil;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.storage.clients.BaseClientKeys;

public class BaseClientConverter<V extends BaseClient>
extends MonitoredConverter<V> {
    JSONUtil jsonUtil;
    protected JWKUtil2 jwkUtil2 = new JWKUtil2();

    public String getJSONComponentName() {
        return "client";
    }

    public JSONUtil getJsonUtil() {
        if (this.jsonUtil == null) {
            this.jsonUtil = new JSONUtil(this.getJSONComponentName());
        }
        return this.jsonUtil;
    }

    public BaseClientConverter(BaseClientKeys keys, IdentifiableProvider<V> provider) {
        super((MonitoredKeys)keys, provider);
    }

    protected BaseClientKeys getBKK() {
        return (BaseClientKeys)this.keys;
    }

    public V fromMap(ConversionMap<String, Object> map, V v) {
        BaseClient value = (BaseClient)super.fromMap(map, v);
        value.setSecret(map.getString((Object)this.getBKK().secret(new String[0])));
        value.setName(map.getString((Object)this.getBKK().name(new String[0])));
        value.setCreationTS(map.getDate((Object)this.getBKK().creationTS(new String[0])));
        value.setLastModifiedTS(map.getDate((Object)this.getBKK().lastModifiedTS(new String[0])));
        value.setEmail(map.getString((Object)this.getBKK().email(new String[0])));
        value.setDebugOn(map.getBoolean((Object)this.getBKK().debugOn(new String[0])));
        if (map.containsKey((Object)this.getBKK().jwksURI(new String[0]))) {
            value.setJwksURI(map.getURI((Object)this.getBKK().jwksURI(new String[0])));
        }
        if (map.containsKey((Object)this.getBKK().jwks(new String[0])) && map.get((Object)this.getBKK().jwks(new String[0])) != null) {
            try {
                JSONWebKeys jwks = this.jwkUtil2.fromJSON(map.getString((Object)this.getBKK().jwks(new String[0])));
                value.setJWKS(jwks);
            }
            catch (Throwable e) {
                if (DebugUtil.isEnabled()) {
                    e.printStackTrace();
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new GeneralException("error getting JWKS", e);
            }
        }
        if (map.containsKey((Object)this.getBKK().rfc7523Client(new String[0]))) {
            value.setServiceClient(map.getBoolean((Object)this.getBKK().rfc7523Client(new String[0])));
        }
        if (map.containsKey((Object)this.getBKK().rfc7523ClientUsers(new String[0])) && map.get((Object)this.getBKK().rfc7523ClientUsers(new String[0])) != null) {
            value.setServiceClientUsers(this.jsonArrayToCollection(map, this.getBKK().rfc7523ClientUsers(new String[0])));
        } else {
            JSONArray array = new JSONArray();
            array.add((Object)"*");
            value.setServiceClientUsers((Collection<String>)array);
        }
        return (V)((Object)value);
    }

    public void toMap(V client, ConversionMap<String, Object> map) {
        super.toMap(client, map);
        map.put((Object)this.getBKK().secret(new String[0]), (Object)((BaseClient)((Object)client)).getSecret());
        map.put((Object)this.getBKK().email(new String[0]), (Object)((BaseClient)((Object)client)).getEmail());
        map.put((Object)this.getBKK().name(new String[0]), (Object)((BaseClient)((Object)client)).getName());
        map.put((Object)this.getBKK().creationTS(new String[0]), (Object)((BaseClient)((Object)client)).getCreationTS());
        map.put((Object)this.getBKK().lastModifiedTS(new String[0]), (Object)((BaseClient)((Object)client)).getLastModifiedTS());
        map.put((Object)this.getBKK().debugOn(new String[0]), (Object)((BaseClient)((Object)client)).isDebugOn());
        if (((BaseClient)((Object)client)).hasJWKS()) {
            map.put((Object)this.getBKK().jwks(new String[0]), (Object)JSONWebKeyUtil.toJSON((JSONWebKeys)((BaseClient)((Object)client)).getJWKS()).toString());
        }
        if (((BaseClient)((Object)client)).hasJWKSURI()) {
            map.put((Object)this.getBKK().jwksURI(new String[0]), (Object)((BaseClient)((Object)client)).getJwksURI().toString());
        }
        map.put((Object)this.getBKK().rfc7523Client(new String[0]), (Object)((BaseClient)((Object)client)).isServiceClient());
        if (((BaseClient)((Object)client)).hasServiceClientUsers()) {
            JSONArray jsonArray = new JSONArray();
            jsonArray.addAll(((BaseClient)((Object)client)).getServiceClientUsers());
            map.put((Object)this.getBKK().rfc7523ClientUsers(new String[0]), (Object)jsonArray.toString());
        } else {
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)"*");
            map.put((Object)this.getBKK().rfc7523ClientUsers(new String[0]), (Object)jsonArray.toString());
        }
    }

    public V fromJSON(JSONObject json) {
        Object raw;
        JSONObject keys;
        String jwksuri;
        BaseClient v = (BaseClient)this.createIfNeeded(null);
        v.setIdentifier(BasicIdentifier.newID((String)this.getJsonUtil().getJSONValueString(json, this.getBKK().identifier(new String[0]))));
        v.setSecret(this.getJsonUtil().getJSONValueString(json, this.getBKK().secret(new String[0])));
        v.setName(this.getJsonUtil().getJSONValueString(json, this.getBKK().name(new String[0])));
        v.setEmail(this.getJsonUtil().getJSONValueString(json, this.getBKK().email(new String[0])));
        v.setDebugOn(this.getJsonUtil().getJSONValueBoolean(json, this.getBKK().debugOn(new String[0])));
        v.setServiceClient(this.getJsonUtil().getJSONValueBoolean(json, this.getBKK().rfc7523Client(new String[0])));
        if (json.containsKey((Object)this.getBKK().rfc7523ClientUsers(new String[0]))) {
            v.setServiceClientUsers((Collection<String>)this.getJsonUtil().getJSONArray(json, this.getBKK().rfc7523ClientUsers(new String[0])));
        }
        if ((jwksuri = this.getJsonUtil().getJSONValueString(json, this.getBKK().jwksURI(new String[0]))) != null) {
            v.setJwksURI(URI.create(jwksuri));
        }
        if ((keys = this.getJsonUtil().getJSONObject(json, this.getBKK().jwks(new String[0]))) != null) {
            try {
                v.setJWKS(this.jwkUtil2.fromJSON((JSON)keys));
            }
            catch (Throwable e) {
                if (DebugUtil.isEnabled()) {
                    e.printStackTrace();
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new GeneralException("error getting JWKS", e);
            }
        }
        if ((raw = this.getJsonUtil().getJSONValue(json, this.getBKK().creationTS(new String[0]))) instanceof Long) {
            v.setCreationTS(new Date((Long)raw));
        } else if (raw != null) {
            if (raw instanceof String) {
                try {
                    v.setCreationTS(Iso8601.string2Date((String)((String)raw)).getTime());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            } else {
                throw new IllegalArgumentException("Unknown date format " + String.valueOf(raw));
            }
        }
        raw = this.getJsonUtil().getJSONValue(json, this.getBKK().lastModifiedTS(new String[0]));
        if (raw instanceof Long) {
            v.setLastModifiedTS(new Date((Long)raw));
        } else if (raw != null) {
            if (raw instanceof String) {
                try {
                    v.setLastModifiedTS(Iso8601.string2Date((String)((String)raw)).getTime());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            } else {
                throw new IllegalArgumentException("Unknown date format " + String.valueOf(raw));
            }
        }
        return (V)((Object)v);
    }

    public void toJSON(V client, JSONObject json) {
        if (json == null) {
            json = new JSONObject();
        }
        JSONObject content = new JSONObject();
        json.put((Object)this.getJSONComponentName(), (Object)content);
        this.getJsonUtil().setJSONValue(json, this.getBKK().identifier(new String[0]), client.getIdentifierString());
        this.getJsonUtil().setJSONValue(json, this.getBKK().email(new String[0]), ((BaseClient)((Object)client)).getEmail());
        this.getJsonUtil().setJSONValue(json, this.getBKK().name(new String[0]), ((BaseClient)((Object)client)).getName());
        this.getJsonUtil().setJSONValue(json, this.getBKK().secret(new String[0]), ((BaseClient)((Object)client)).getSecret());
        this.getJsonUtil().setJSONValue(json, this.getBKK().debugOn(new String[0]), ((BaseClient)((Object)client)).isDebugOn());
        this.getJsonUtil().setJSONValue(json, this.getBKK().rfc7523Client(new String[0]), ((BaseClient)((Object)client)).isServiceClient());
        this.getJsonUtil().setJSONValue(json, this.getBKK().rfc7523ClientUsers(new String[0]), ((BaseClient)((Object)client)).getServiceClientUsers());
        if (((BaseClient)((Object)client)).hasJWKSURI()) {
            this.getJsonUtil().setJSONValue(json, this.getBKK().jwksURI(new String[0]), ((BaseClient)((Object)client)).getJwksURI().toString());
        }
        if (((BaseClient)((Object)client)).hasJWKS()) {
            this.getJsonUtil().setJSONValue(json, this.getBKK().jwks(new String[0]), JSONWebKeyUtil.toJSON((JSONWebKeys)((BaseClient)((Object)client)).getJWKS()));
        }
        if (((BaseClient)((Object)client)).getCreationTS() != null) {
            this.getJsonUtil().setJSONValue(json, this.getBKK().creationTS(new String[0]), Iso8601.date2String((Date)((BaseClient)((Object)client)).getCreationTS()));
        }
        if (((BaseClient)((Object)client)).getLastModifiedTS() != null) {
            this.getJsonUtil().setJSONValue(json, this.getBKK().lastModifiedTS(new String[0]), Iso8601.date2String((Date)((BaseClient)((Object)client)).getLastModifiedTS()));
        }
    }

    protected Collection<String> jsonArrayToCollection(ConversionMap<String, Object> map, String key) {
        JSONArray json;
        try {
            json = (JSONArray)JSONSerializer.toJSON((Object)map.get((Object)key));
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        Collection zzz = (Collection)JSONSerializer.toJava((JSON)json);
        return zzz;
    }
}

