/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.common.storage.clients;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.BeanUtils;
import java.util.Collection;
import java.util.LinkedList;
import org.oa4mp.delegation.common.storage.clients.BaseClient;

public class Client
extends BaseClient {
    boolean proxyLimited = false;
    String homeUri;
    String errorUri;
    Collection<String> scopes = new LinkedList<String>();

    @Override
    public Client clone() {
        Client c = new Client(this.getIdentifier());
        this.populateClone(c);
        return c;
    }

    @Override
    protected void populateClone(BaseClient client) {
        Client c = (Client)client;
        super.populateClone(c);
        c.setErrorUri(this.getErrorUri());
        c.setHomeUri(this.getHomeUri());
        c.setProxyLimited(this.isProxyLimited());
        c.setServiceClient(this.isServiceClient());
    }

    public boolean isProxyLimited() {
        return this.proxyLimited;
    }

    public void setProxyLimited(boolean proxyLimited) {
        this.proxyLimited = proxyLimited;
    }

    public Client(Identifier identifier) {
        super(identifier);
    }

    public String getHomeUri() {
        return this.homeUri;
    }

    public void setHomeUri(String homeUri) {
        this.homeUri = homeUri;
    }

    public String getErrorUri() {
        return this.errorUri;
    }

    public void setErrorUri(String errorUri) {
        this.errorUri = errorUri;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Client c = (Client)((Object)obj);
        if (!BeanUtils.checkEquals((Object)this.getHomeUri(), (Object)c.getHomeUri())) {
            return false;
        }
        if (!BeanUtils.checkEquals((Object)this.getErrorUri(), (Object)c.getErrorUri())) {
            return false;
        }
        return this.isProxyLimited() == c.isProxyLimited();
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[name=\"" + this.getName() + "\", id=\"" + this.getIdentifierString() + "\", homeUri=\"" + this.getHomeUri() + "\", errorUri=\"" + this.getErrorUri() + "\", email=\"" + this.getEmail() + "\", serviceClient=\"" + this.isServiceClient() + "\", secret=" + (this.getSecret() == null ? "(none)" : this.getSecret().substring(0, Math.min(25, this.getSecret().length()))) + "\", proxy limited=" + this.isProxyLimited() + "]";
    }

    public Collection<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(Collection<String> scopes) {
        this.scopes = scopes;
    }
}

