/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.common.storage.transactions;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.cache.Cacheable;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.IdentifiableImpl;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.common.token.NewToken;
import org.oa4mp.delegation.common.token.ProtectedAsset;

public class BasicTransaction
extends IdentifiableImpl
implements Cacheable {
    protected AuthorizationGrant authorizationGrant;
    AccessToken accessToken = null;
    ProtectedAsset protectedAsset;

    public BasicTransaction(Identifier identifier) {
        super(identifier);
    }

    public BasicTransaction(AuthorizationGrant ag) {
        super(BasicIdentifier.newID((String)ag.getToken()));
        this.setAuthorizationGrant(ag);
    }

    public boolean hasAccessToken() {
        return this.accessToken != null;
    }

    public boolean hasAuthorizationGrant() {
        return this.authorizationGrant != null;
    }

    public boolean hasProtectedAsset() {
        return this.protectedAsset != null;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(AccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public AuthorizationGrant getAuthorizationGrant() {
        return this.authorizationGrant;
    }

    public void setAuthorizationGrant(AuthorizationGrant authorizationGrant) {
        this.authorizationGrant = authorizationGrant;
        if (this.getIdentifier() == null) {
            this.setIdentifier(BasicIdentifier.newID((String)authorizationGrant.getToken()));
        }
    }

    public ProtectedAsset getProtectedAsset() {
        return this.protectedAsset;
    }

    public void setProtectedAsset(ProtectedAsset protectedAsset) {
        this.protectedAsset = protectedAsset;
    }

    protected boolean checkTokenEquals(NewToken token1, NewToken token2) {
        if (token1 == null) {
            return token2 == null;
        }
        if (token2 == null) {
            return false;
        }
        return token1.equals(token2);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof BasicTransaction)) {
            return false;
        }
        BasicTransaction t = (BasicTransaction)((Object)obj);
        if (!this.checkTokenEquals(this.getAuthorizationGrant(), t.getAuthorizationGrant())) {
            return false;
        }
        return this.checkTokenEquals(this.getAccessToken(), t.getAccessToken());
    }

    public String toString() {
        Object out = "Transaction[";
        out = (String)out + "id=" + this.getIdentifierString() + ", auth grant=" + String.valueOf(this.hasAuthorizationGrant() ? this.getAuthorizationGrant() : "(none)");
        out = (String)out + ", access token=" + String.valueOf(this.hasAccessToken() ? this.getAccessToken() : "(none)");
        return (String)out + "]";
    }
}

