/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.common.storage.transactions;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;
import java.net.URI;
import org.oa4mp.delegation.common.storage.transactions.BasicTransaction;
import org.oa4mp.delegation.common.storage.transactions.BasicTransactionKeys;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.common.token.TokenForge;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.AuthorizationGrantImpl;
import org.oa4mp.delegation.common.token.impl.TokenFactory;

public class BasicTransactionConverter<V extends BasicTransaction>
extends MapConverter<V> {
    protected TokenForge tokenForge;

    public TokenForge getTokenForge() {
        return this.tokenForge;
    }

    protected BasicTransactionKeys getBTKeys() {
        return (BasicTransactionKeys)this.keys;
    }

    public BasicTransactionConverter(IdentifiableProvider<V> identifiableProvider, TokenForge tokenForge) {
        this(new BasicTransactionKeys(), identifiableProvider, tokenForge);
    }

    public BasicTransactionConverter(SerializationKeys keys, IdentifiableProvider<V> identifiableProvider, TokenForge tokenForge) {
        super(keys, identifiableProvider);
        this.tokenForge = tokenForge;
    }

    public V fromMap(ConversionMap<String, Object> data, V v) {
        BasicTransaction b = (BasicTransaction)super.fromMap(data, v);
        Identifier id = b.getIdentifier();
        Object token = data.get((Object)this.getBTKeys().authGrant(new String[0]));
        if (token == null) {
            b.setAuthorizationGrant(null);
        } else if (token instanceof AuthorizationGrant) {
            b.setAuthorizationGrant((AuthorizationGrant)token);
        } else {
            b.setAuthorizationGrant(new AuthorizationGrantImpl(URI.create(token.toString())));
        }
        token = data.get((Object)this.getBTKeys().accessToken(new String[0]));
        if (token == null) {
            b.setAccessToken(null);
        } else if (token instanceof AccessToken) {
            b.setAccessToken((AccessToken)token);
        } else {
            AccessTokenImpl at = TokenFactory.createAT(token.toString());
            b.setAccessToken(at);
        }
        b.setIdentifier(id);
        return (V)((Object)b);
    }

    public void toMap(V value, ConversionMap<String, Object> data) {
        super.toMap(value, data);
        if (((BasicTransaction)((Object)value)).hasAuthorizationGrant()) {
            data.put((Object)this.getBTKeys().authGrant(new String[0]), (Object)((BasicTransaction)((Object)value)).getAuthorizationGrant().getToken());
        }
        if (((BasicTransaction)((Object)value)).hasAccessToken()) {
            data.put((Object)this.getBTKeys().accessToken(new String[0]), (Object)((BasicTransaction)((Object)value)).getAccessToken().getJti().toString());
        }
    }
}

