/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.common.storage.transactions;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.storage.FileStore;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import java.io.File;
import java.io.IOException;
import org.oa4mp.delegation.common.storage.TransactionStore;
import org.oa4mp.delegation.common.storage.transactions.BasicTransaction;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.common.token.TokenForge;

public abstract class FSTransactionStore<V extends BasicTransaction>
extends FileStore<V>
implements TransactionStore<V> {
    protected TokenForge tokenForge;

    protected FSTransactionStore(File storeDirectory, File indexDirectory, IdentifiableProvider<V> idp, TokenForge tokenForge, MapConverter<V> mp, boolean removeEmptyFiles, boolean removeFailedFiles) {
        super(storeDirectory, indexDirectory, idp, mp, removeEmptyFiles, removeFailedFiles);
        this.tokenForge = tokenForge;
    }

    public FSTransactionStore(File file, IdentifiableProvider<V> idp, TokenForge tokenForge, MapConverter<V> mp, boolean removeEmptyFiles, boolean removeFailedFiles) {
        super(file, idp, mp, removeEmptyFiles, removeFailedFiles);
        this.tokenForge = tokenForge;
    }

    public void realSave(boolean checkExists, V t) {
        super.realSave(checkExists, t);
        try {
            if (((BasicTransaction)((Object)t)).hasAuthorizationGrant()) {
                this.createIndexEntry(((BasicTransaction)((Object)t)).getAuthorizationGrant().getToken(), t.getIdentifierString());
            }
            if (((BasicTransaction)((Object)t)).hasAccessToken()) {
                this.createIndexEntry(((BasicTransaction)((Object)t)).getAccessToken().getToken(), t.getIdentifierString());
            }
        }
        catch (IOException e) {
            throw new GeneralException("Error serializing item " + String.valueOf(t) + "to file ");
        }
    }

    public V realRemove(V thingie) {
        super.realRemove(thingie);
        if (((BasicTransaction)((Object)thingie)).getAccessToken() != null) {
            this.removeIndexEntry(((BasicTransaction)((Object)thingie)).getAccessToken().getToken());
        }
        return thingie;
    }

    @Override
    public V get(AuthorizationGrant authorizationGrant) {
        return (V)((Object)((BasicTransaction)this.getIndexEntry(authorizationGrant.getToken())));
    }

    @Override
    public V get(AccessToken accessToken) {
        return (V)((Object)((BasicTransaction)this.getIndexEntry(accessToken.getToken())));
    }

    @Override
    public MapConverter getMapConverter() {
        return this.converter;
    }
}

