/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.common.storage.transactions;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.TransactionNotFoundException;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionRecord;
import edu.uiuc.ncsa.security.storage.sql.SQLStore;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnMap;
import edu.uiuc.ncsa.security.storage.sql.internals.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.inject.Provider;
import org.oa4mp.delegation.common.storage.TransactionStore;
import org.oa4mp.delegation.common.storage.transactions.BasicTransaction;
import org.oa4mp.delegation.common.storage.transactions.BasicTransactionTable;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.common.token.TokenForge;

public abstract class SQLBaseTransactionStore<V extends BasicTransaction>
extends SQLStore<V>
implements TransactionStore<V> {
    protected TokenForge tokenForge;

    protected SQLBaseTransactionStore(TokenForge tokenForge, ConnectionPool connectionPool, Table table, Provider<V> idp, MapConverter converter) {
        super(connectionPool, table, idp, converter);
        this.tokenForge = tokenForge;
    }

    public BasicTransactionTable getTransactionTable() {
        return (BasicTransactionTable)this.getTable();
    }

    protected V getTransaction(String identifier, String statement) {
        if (identifier == null) {
            throw new IllegalStateException("a null identifier was supplied");
        }
        ConnectionRecord cr = this.getConnection();
        Connection c = cr.connection;
        BasicTransaction t = null;
        try {
            PreparedStatement stmt = c.prepareStatement(statement);
            stmt.setString(1, identifier);
            stmt.executeQuery();
            ResultSet rs = stmt.getResultSet();
            if (!rs.next()) {
                rs.close();
                stmt.close();
                this.releaseConnection(cr);
                throw new TransactionNotFoundException("No transaction found for identifier \"" + identifier + "\"");
            }
            ColumnMap map = SQLBaseTransactionStore.rsToMap((ResultSet)rs);
            rs.close();
            stmt.close();
            this.releaseConnection(cr);
            t = (BasicTransaction)this.create();
            this.populate(map, (Identifiable)t);
        }
        catch (SQLException e) {
            throw new GeneralException("Error getting transaction with identifier \"" + identifier + "\"", (Throwable)e);
        }
        return (V)((Object)t);
    }

    @Override
    public V get(AuthorizationGrant tempCred) {
        try {
            V t = this.getTransaction(tempCred.getJti().toString(), this.getTransactionTable().getByTempCredStatement());
            return t;
        }
        catch (TransactionNotFoundException x) {
            return null;
        }
    }

    @Override
    public V get(AccessToken accessToken) {
        try {
            V t = this.getTransaction(accessToken.getJti().toString(), this.getTransactionTable().getByAccessTokenStatement());
            return t;
        }
        catch (TransactionNotFoundException x) {
            return null;
        }
    }

    public String getCreationTSField() {
        this.getMapConverter().getKeys();
        return null;
    }
}

