/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.common.storage.transactions;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.XMLConverter;
import edu.uiuc.ncsa.security.core.exceptions.NotImplementedException;
import edu.uiuc.ncsa.security.storage.MemoryStore;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import java.util.HashMap;
import java.util.List;
import org.oa4mp.delegation.common.storage.TransactionStore;
import org.oa4mp.delegation.common.storage.transactions.BasicTransaction;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.AuthorizationGrant;

public class TransactionMemoryStore<V extends BasicTransaction>
extends MemoryStore<V>
implements TransactionStore<V> {
    TokenIndex agIndex;
    TokenIndex atIndex;
    TokenIndex vIndex;
    TokenIndex proxyIDIndex = null;

    public TransactionMemoryStore(IdentifiableProvider<V> vIdentifiableProvider) {
        super(vIdentifiableProvider);
    }

    public List<V> getMostRecent(int n, List<String> attributes) {
        return null;
    }

    public TokenIndex getAgIndex() {
        if (this.agIndex == null) {
            this.agIndex = new TokenIndex();
        }
        return this.agIndex;
    }

    public TokenIndex getAtIndex() {
        if (this.atIndex == null) {
            this.atIndex = new TokenIndex();
        }
        return this.atIndex;
    }

    public TokenIndex getProxyIDIndex() {
        if (this.proxyIDIndex == null) {
            this.proxyIDIndex = new TokenIndex();
        }
        return this.proxyIDIndex;
    }

    public TokenIndex getvIndex() {
        if (this.vIndex == null) {
            this.vIndex = new TokenIndex();
        }
        return this.vIndex;
    }

    @Override
    public V get(AuthorizationGrant authorizationGrant) {
        return (V)((Object)((BasicTransaction)((Object)this.getAgIndex().get(authorizationGrant.getToken()))));
    }

    @Override
    public V get(AccessToken accessToken) {
        return (V)((Object)((BasicTransaction)((Object)this.getAtIndex().get(accessToken.getToken()))));
    }

    @Override
    public V getByProxyID(Identifier proxyID) {
        return (V)((Object)((BasicTransaction)((Object)this.getProxyIDIndex().get(proxyID.toString()))));
    }

    protected void updateIndices(V v) {
        if (((BasicTransaction)((Object)v)).getAccessToken() != null) {
            this.getAtIndex().put(((BasicTransaction)((Object)v)).getAccessToken().getToken(), v);
        }
        if (((BasicTransaction)((Object)v)).getAuthorizationGrant() != null) {
            this.getAgIndex().put(((BasicTransaction)((Object)v)).getAuthorizationGrant().getToken(), v);
        }
    }

    public void register(V value) {
        super.register(value);
        this.updateIndices(value);
    }

    public void save(V value) {
        super.save(value);
        this.updateIndices(value);
    }

    public void update(V value) {
        super.update(value);
        this.updateIndices(value);
    }

    public void clear() {
        super.clear();
        this.clearIndices();
    }

    protected void clearIndices() {
        this.agIndex = null;
        this.atIndex = null;
        this.vIndex = null;
    }

    protected void removeItem(V value) {
        this.getAgIndex().remove(((BasicTransaction)((Object)value)).getAuthorizationGrant());
        this.getAtIndex().remove(((BasicTransaction)((Object)value)).getAccessToken());
    }

    public V remove(Object key) {
        BasicTransaction item = (BasicTransaction)((Object)super.remove(key));
        if (item != null) {
            this.removeItem(item);
        }
        return (V)((Object)item);
    }

    public XMLConverter<V> getXMLConverter() {
        throw new NotImplementedException(" Method not implemented");
    }

    @Override
    public MapConverter getMapConverter() {
        throw new NotImplementedException(" This is not yet implemented for memory stores");
    }

    public List<V> search(String key, String condition, boolean isRegEx, List<String> attr) {
        throw new NotImplementedException(" This is not yet implemented for memory stores");
    }

    protected class TokenIndex
    extends HashMap<String, V> {
    }
}

