/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.common.token;

import edu.uiuc.ncsa.security.util.pkcs.MyCertUtil;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.oa4mp.delegation.common.token.ProtectedAsset;

public class MyX509Certificates
implements ProtectedAsset {
    public X509Certificate[] x509Certificates;

    public MyX509Certificates(Collection<X509Certificate> certs) {
        this.x509Certificates = certs.toArray(new X509Certificate[certs.size()]);
    }

    public MyX509Certificates(X509Certificate[] x509Certificates) {
        this.x509Certificates = x509Certificates;
    }

    public X509Certificate[] getX509Certificates() {
        return this.x509Certificates;
    }

    public String getX509CertificatesPEM() throws CertificateEncodingException {
        Object pem = "";
        for (int i = 0; i < this.x509Certificates.length; ++i) {
            pem = (String)pem + MyCertUtil.toPEM((X509Certificate)this.x509Certificates[i]) + "\n";
        }
        return pem;
    }

    public void setX509Certificates(X509Certificate[] x509Certificates) {
        this.x509Certificates = x509Certificates;
    }

    public String toString() {
        Object str = "MyX509Certificates[";
        for (int i = 0; i < this.x509Certificates.length; ++i) {
            str = (String)str + "cert = " + String.valueOf(this.x509Certificates[i] == null ? "(null)" : this.x509Certificates[i]);
        }
        str = (String)str + "]";
        return str;
    }
}

