/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.common.token.impl;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.AuthorizationGrantImpl;
import org.oa4mp.delegation.common.token.impl.IDTokenImpl;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenUtils;

public class TokenFactory {
    protected static void parseRawToken(String rawToken, TokenImpl token) {
        if (TokenUtils.isBase32((String)rawToken)) {
            String decodedToken = TokenUtils.b32DecodeToken((String)rawToken);
            token.setToken(rawToken);
            token.setJti(URI.create(decodedToken));
            token.setJWT(false);
            return;
        }
        JSONObject jsonObject = TokenFactory.getPayload(rawToken);
        if (jsonObject != null) {
            token.setPayload(jsonObject);
            if (jsonObject.containsKey((Object)"jti")) {
                token.setJti(URI.create(jsonObject.getString("jti")));
            }
            if (jsonObject.containsKey((Object)"iat")) {
                token.setIssuedAt(1000L * jsonObject.getLong("iat"));
            }
            if (jsonObject.containsKey((Object)"exp")) {
                long expiresAt = jsonObject.getLong("exp");
                token.setExpiresAt(1000L * expiresAt);
                token.setLifetime(1000L * expiresAt - token.getIssuedAt());
            }
            token.setJWT(true);
            token.setToken(rawToken);
            return;
        }
        token.setJWT(false);
        token.setJti(URI.create(rawToken));
        token.setToken(rawToken);
    }

    protected static JSONObject getPayload(String rawToken) {
        StringTokenizer st = new StringTokenizer(rawToken, ".");
        if (1 < st.countTokens()) {
            st.nextToken();
            String payload = st.nextToken();
            if (!payload.startsWith("ey")) {
                return null;
            }
            try {
                byte[] x = Base64.decodeBase64((String)payload);
                String pp = new String(x, StandardCharsets.UTF_8);
                return JSONObject.fromObject((Object)pp);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static AuthorizationGrantImpl createAG(String rawToken) {
        AuthorizationGrantImpl ag = new AuthorizationGrantImpl();
        TokenFactory.parseRawToken(rawToken, ag);
        return ag;
    }

    public static RefreshTokenImpl createRT(String rawToken) {
        RefreshTokenImpl refreshToken = new RefreshTokenImpl();
        TokenFactory.parseRawToken(rawToken, refreshToken);
        return refreshToken;
    }

    public static RefreshTokenImpl createRT(JSONObject json) {
        RefreshTokenImpl refreshToken = new RefreshTokenImpl(URI.create("a"));
        refreshToken.fromJSON(json);
        return refreshToken;
    }

    public static AccessTokenImpl createAT(String rawToken) {
        AccessTokenImpl accessToken = new AccessTokenImpl();
        TokenFactory.parseRawToken(rawToken, accessToken);
        return accessToken;
    }

    public static AccessTokenImpl createAT(JSONObject json) {
        AccessTokenImpl accessToken = new AccessTokenImpl(URI.create("a"));
        accessToken.fromJSON(json);
        return accessToken;
    }

    public static IDTokenImpl createIDT(String rawToken) {
        IDTokenImpl idToken = new IDTokenImpl();
        TokenFactory.parseRawToken(rawToken, idToken);
        return idToken;
    }

    public static IDTokenImpl createIDT(JSONObject json) {
        if (json.containsKey((Object)"token_type")) {
            IDTokenImpl idToken = new IDTokenImpl(URI.create("a"));
            if (!json.getString("token_type").equals(idToken.getTokenType())) {
                throw new IllegalArgumentException("Attempt to deserialize a non ID token, type is \"" + json.getString("token_type") + "\".");
            }
            idToken.fromJSON(json);
            return idToken;
        }
        if (!json.containsKey((Object)"jti")) {
            throw new IllegalArgumentException("unknown token type");
        }
        IDTokenImpl idToken = new IDTokenImpl(URI.create(json.getString("jti")));
        if (json.containsKey((Object)"exp")) {
            idToken.setExpiresAt(1000L * json.getLong("exp"));
        }
        idToken.setPayload(json);
        if (json.containsKey((Object)"iat")) {
            idToken.setIssuedAt(1000L * json.getLong("iat"));
        }
        idToken.setLifetime(idToken.getExpiresAt() - idToken.getIssuedAt());
        idToken.setToken("A." + Base64.encodeBase64URLSafeString((byte[])json.toString().getBytes(StandardCharsets.UTF_8)) + ".Z");
        idToken.setJWT(true);
        return idToken;
    }

    public static class TokenParse {
        String rawToken;
        TokenImpl token;
        URI jti;
        boolean isJWT = false;

        public TokenParse(String rawToken, TokenImpl token) {
            this.rawToken = rawToken;
            this.token = token;
        }
    }
}

