/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.common.token.impl;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.configuration.XProperties;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.BeanUtils;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.Identifiers;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.token.NewToken;
import org.oa4mp.delegation.common.token.impl.TokenUtils;

public class TokenImpl
implements NewToken {
    public static final String TOKEN_TYPE = "token_type";
    public static final String EXPIRES_AT = "expires_at";
    public static final String IS_JWT = "is_jwt";
    public static final String PAYLOAD = "payload";
    public static final String TOKEN = "token";
    public static final String JTI = "jti";
    XProperties params = new XProperties();
    String version = null;
    URI jti;
    boolean isJWT = false;
    String token = null;
    long lifetime = -1L;
    long issuedAt = -1L;
    JSONObject payload = null;
    long expiresAt = -1L;

    public TokenImpl() {
    }

    @Override
    public String getVersion() {
        if (this.version == null) {
            this.version = this.params.containsKey((Object)"v2.0") ? this.params.getString("v2.0") : this.params.getString("v2.0");
        }
        return this.version;
    }

    public boolean hasJTI() {
        return this.jti != null;
    }

    @Override
    public URI getJti() {
        return this.jti;
    }

    public void setJti(URI jti) {
        this.jti = jti;
        this.init(jti);
    }

    @Override
    public Identifier getJTIAsIdentifier() {
        return BasicIdentifier.newID((URI)this.getJti());
    }

    public boolean isOldVersion() {
        return this.getVersion() == null || this.getVersion().equals("v1.0");
    }

    public boolean isJWT() {
        return this.isJWT;
    }

    public void setJWT(boolean JWT) {
        this.isJWT = JWT;
    }

    public TokenImpl(String sciToken, URI jti) {
        this.token = sciToken;
        this.jti = jti;
        this.isJWT = true;
        this.init(jti);
    }

    public TokenImpl(URI token) {
        if (token == null) {
            return;
        }
        this.token = token.toString();
        this.jti = token;
        this.init(token);
    }

    protected void init(URI uri) {
        if (uri == null) {
            return;
        }
        String s = uri.getQuery();
        if (StringUtils.isTrivial((String)uri.getQuery())) {
            this.version = "v1.0";
        } else {
            Map parameters = Identifiers.getParameters((URI)uri);
            this.params.putAll(parameters);
            this.version = "v2.0";
        }
    }

    @Override
    public String getToken() {
        return this.token;
    }

    public URI getURIToken() {
        return URI.create(this.token);
    }

    public void setToken(URI token) {
        this.token = token.toString();
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TokenImpl)) {
            return false;
        }
        TokenImpl at = (TokenImpl)obj;
        if (!BeanUtils.checkNoNulls((Object)this.getURIToken(), (Object)at.getURIToken())) {
            return false;
        }
        if (!BeanUtils.checkNoNulls((Object)this.getVersion(), (Object)at.getVersion())) {
            return false;
        }
        if (!at.getToken().equals(this.getToken())) {
            return false;
        }
        if (at.getLifetime() != this.getLifetime()) {
            return false;
        }
        return at.getIssuedAt() == this.getIssuedAt();
    }

    protected StringBuilder createString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName() + "[");
        stringBuilder.append("jti=" + String.valueOf(this.getJti()));
        if (this.isJWT) {
            if (this.getToken() == null) {
                stringBuilder.append(", token=(null)");
            } else {
                stringBuilder.append(", token=" + this.getToken());
            }
        }
        if (this.params == null || this.params.isEmpty()) {
            stringBuilder.append(", ts=" + this.getIssuedAt());
            stringBuilder.append(", lifetime=" + this.getLifetime());
            stringBuilder.append(", version=" + this.getVersion());
        } else {
            for (Object x : this.params.keySet()) {
                String key = (String)x;
                stringBuilder.append(", " + key + "=" + this.params.getString(key));
            }
        }
        return stringBuilder;
    }

    public String toString() {
        return this.createString().toString() + "]";
    }

    @Override
    public boolean isExpired() {
        if (DebugUtil.isEnabled()) {
            Date expireTS = new Date();
            expireTS.setTime(this.getLifetime() + this.getIssuedAt());
        }
        return this.getLifetime() + this.getIssuedAt() < System.currentTimeMillis();
    }

    public void setLifetime(long lifetime) {
        this.lifetime = lifetime;
    }

    @Override
    public long getLifetime() {
        if (this.lifetime < 0L && this.params.containsKey((Object)"lifetime")) {
            this.lifetime = this.params.getLong("lifetime");
        }
        return this.lifetime;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setIssuedAt(long issuedAt) {
        this.issuedAt = issuedAt;
    }

    @Override
    public long getIssuedAt() {
        if (this.issuedAt < 0L && this.params.containsKey((Object)"ts")) {
            this.issuedAt = this.params.getLong("ts");
        }
        return this.issuedAt;
    }

    @Override
    public JSONObject toJSON() {
        return this.newToJSON();
    }

    protected JSONObject newToJSON() {
        JSONObject json = new JSONObject();
        json.put((Object)"ts", (Object)this.getIssuedAt());
        json.put((Object)"lifetime", (Object)this.getLifetime());
        json.put((Object)"version", (Object)this.getVersion());
        json.put((Object)TOKEN_TYPE, (Object)this.getTokenType());
        json.put((Object)EXPIRES_AT, (Object)this.getExpiresAt());
        json.put((Object)IS_JWT, (Object)this.isJWT());
        if (this.hasPayload()) {
            json.put((Object)PAYLOAD, (Object)this.getPayload());
        }
        json.put((Object)TOKEN, (Object)this.getToken());
        json.put((Object)JTI, (Object)this.getJti().toString());
        return json;
    }

    protected JSONObject oldToJSON() {
        JSONObject json = new JSONObject();
        json.put((Object)"ts", (Object)this.getIssuedAt());
        json.put((Object)"lifetime", (Object)this.getLifetime());
        if (this.isJWT) {
            json.put((Object)"jwt", (Object)this.token.toString());
        }
        json.put((Object)TOKEN, (Object)this.getJti().toString());
        return json;
    }

    public boolean hasPayload() {
        return this.payload != null;
    }

    public JSONObject getPayload() {
        return this.payload;
    }

    public void setPayload(JSONObject payload) {
        this.payload = payload;
    }

    @Override
    public void fromJSON(JSONObject json) {
        if (json.containsKey((Object)TOKEN_TYPE)) {
            if (!json.getString(TOKEN_TYPE).equals(this.getTokenType())) {
                throw new IllegalArgumentException("wrong token type. Expected \"" + this.getTokenType() + "\", but got \"" + json.getString(TOKEN_TYPE) + "\".");
            }
            this.newFromJSON(json);
        } else {
            this.oldFromJSON(json);
        }
    }

    protected String getTokenType() {
        return "token_impl";
    }

    public void oldFromJSON(JSONObject json) {
        if (!json.containsKey((Object)TOKEN)) {
            throw new IllegalArgumentException("the json object is not a token");
        }
        this.jti = URI.create(json.getString(TOKEN));
        if (json.containsKey((Object)"jwt")) {
            this.token = json.getString("jwt");
            this.isJWT = true;
        } else {
            this.token = this.jti.toString();
            this.isJWT = false;
        }
        if (json.containsKey((Object)"ts")) {
            this.issuedAt = json.getLong("ts");
        }
        if (json.containsKey((Object)"lifetime")) {
            this.lifetime = json.getLong("lifetime");
        }
    }

    protected void newFromJSON(JSONObject json) {
        this.jti = URI.create(json.getString(JTI));
        if (json.containsKey((Object)PAYLOAD)) {
            this.setPayload(json.getJSONObject(PAYLOAD));
        }
        this.setExpiresAt(json.getLong(EXPIRES_AT));
        this.setLifetime(json.getLong("lifetime"));
        this.setVersion(json.getString("version"));
        this.setIssuedAt(json.getLong("ts"));
        this.setJWT(json.getBoolean(IS_JWT));
        this.setToken(json.getString(TOKEN));
        this.setJti(URI.create(json.getString(JTI)));
    }

    @Override
    public String encodeToken() {
        return TokenUtils.b32EncodeToken(this);
    }

    @Override
    public void decodeToken(String b32Encoded) {
        String rawToken = TokenUtils.b32DecodeToken((String)b32Encoded);
        URI newToken = URI.create(rawToken);
        this.setToken(rawToken);
        this.init(newToken);
    }

    public static void main(String[] args) {
        Object token = "https://dev.cilogon.org/oauth2/5b8c19145ec68a66c32eeedd228faf12?type=accessToken&ts=1652301290756&version=v2.0&lifetime=900000";
        token = (String)token + "&eid=898611f963df7c8bf48351a7350813adee417e57";
        TokenImpl token1 = new TokenImpl(URI.create((String)token));
        System.out.println(token1);
    }

    public long getExpiresAt() {
        if (this.expiresAt < 0L) {
            this.expiresAt = this.getIssuedAt() + this.getLifetime();
        }
        return this.expiresAt;
    }

    public void setExpiresAt(long expiresAt) {
        this.expiresAt = expiresAt;
    }
}

