/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.di;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.InvalidTimestampException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.DateUtils;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.servlet.ExceptionHandler;
import edu.uiuc.ncsa.security.servlet.ExceptionHandlerThingie;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.storage.clients.ClientApprovalKeys;
import org.oa4mp.delegation.common.storage.clients.ClientKeys;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.common.token.impl.AuthorizationGrantImpl;
import org.oa4mp.delegation.common.token.impl.TokenUtils;
import org.oa4mp.delegation.server.OA2GeneralError;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.jwt.HandlerRunner;
import org.oa4mp.delegation.server.jwt.ScriptRuntimeException;
import org.oa4mp.delegation.server.request.IssuerResponse;
import org.oa4mp.delegation.server.server.OIDCServiceTransactionInterface;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.di.DIServiceException;
import org.oa4mp.di.DIServiceExceptionHandler;
import org.oa4mp.di.DIServiceSerializer;
import org.oa4mp.di.Err;
import org.oa4mp.di.StatusCodes;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;
import org.oa4mp.server.api.util.ClientDebugUtil;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.servlet.DIServiceConfig;
import org.oa4mp.server.loader.oauth2.servlet.OA2AuthorizedServletUtil;
import org.oa4mp.server.loader.oauth2.servlet.OA2ClientUtils;
import org.oa4mp.server.loader.oauth2.servlet.RFC8628ServletConfig;
import org.oa4mp.server.loader.oauth2.servlet.RFC8628State;
import org.oa4mp.server.loader.oauth2.state.ScriptRuntimeEngineFactory;
import org.oa4mp.server.loader.oauth2.storage.RFC8628Store;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientKeys;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.proxy.RFC8628Servlet;
import org.qdl_lang.exceptions.QDLException;

public class DIService
extends OA4MPServlet {
    public static final String FINISH_AUTH_CODE_FLOW = "finishAuthCodeFlow";
    public static final String START_AUTH_CODE_FLOW = "startAuthCodeFlow";
    public static final int STATUS_TRANSACTION_NOT_FOUND = 65537;
    public static final int STATUS_EXPIRED_TOKEN = 65539;
    public static final int STATUS_CREATE_TRANSACTION_FAILED = 65541;
    public static final int STATUS_MISSING_CLIENT_ID = 65545;
    public static final int STATUS_UNKNOWN_CLIENT = 65549;
    public static final int STATUS_UNAPPROVED_CLIENT = 65551;
    public static final int STATUS_NO_SCOPES = 65553;
    public static final int STATUS_MALFORMED_SCOPE = 65555;
    public static final int STATUS_SERVICE_UNAVAILABLE = 65557;
    public static final int STATUS_QDL_ERROR = 0x100007;
    public static final int STATUS_QDL_RUNTIME_ERROR = 0x100009;
    public static final String STATUS_KEY = "status";
    public static final String ACTION_PARAMETER = "action";
    protected DIServiceSerializer serializer;
    public static final String CHECK_USER_CODE = "checkUserCode";
    public static final String APPROVE_USER_CODE = "approveUserCode";
    public static final String GRANT_PARAMETER = "code";
    public static final String USER_CODE_PARAMETER = "user_code";
    public static final String USER_NAME_PARAMETER = "username";
    public static final String MYPROXY_USERNAME_PARAMETER = "myproxy_username";
    public static final String APPROVED_PARAMETER = "approved";
    public static final String DI_USER_PARAMETER = "oa4mp:di:user";
    public static final String DI_PASSWORD_PARAMETER = "oa4mp:di:password";

    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        String password;
        String username;
        if (this.getOA2SE().getDIServiceConfig().isEnabled()) {
            username = request.getParameter(DI_USER_PARAMETER);
            password = request.getParameter(DI_PASSWORD_PARAMETER);
            if (StringUtils.isTrivial((String)username)) {
                throw new DIServiceConfig.UnknownDISericeUserException("Missing username");
            }
            if (StringUtils.isTrivial((String)password)) {
                throw new DIServiceConfig.UnknownDISericeUserException("Missing password");
            }
        } else {
            throw new ServletException("DB service is not enabled");
        }
        this.getOA2SE().getDIServiceConfig().checkPassword(username, password);
        if (this.doPing(request, response)) {
            return;
        }
        String action = this.getParam(request, ACTION_PARAMETER);
        this.doAction(request, response, action);
    }

    protected void doAction(HttpServletRequest request, HttpServletResponse response, String action) throws IOException, ServletException {
        if (StringUtils.isTrivial((String)action)) {
            throw new DIServiceException(1);
        }
        ServletDebugUtil.trace((Object)((Object)this), (String)("action = " + action));
        switch (action) {
            case "finishAuthCodeFlow": {
                this.finishAuthCodeFlow(request, response);
                return;
            }
            case "startAuthCodeFlow": {
                ServletDebugUtil.trace((Object)((Object)this), (String)"creating transaction");
                this.startAuthCodeFlow(request, response);
                return;
            }
            case "checkUserCode": {
                this.checkUserCode(request, response);
                return;
            }
            case "approveUserCode": {
                this.approveUserCode(request, response);
                return;
            }
        }
        this.info("Action \"" + action + "\" not found");
        throw new DIServiceException(1);
    }

    protected String getParam(HttpServletRequest request, String key) throws UnsupportedEncodingException {
        return this.getParam(request, key, false);
    }

    protected String getParam(HttpServletRequest request, String key, boolean nullOK) throws UnsupportedEncodingException {
        request.setCharacterEncoding("UTF-8");
        String[] params = request.getParameterValues(key);
        if (null == params || params.length == 0) {
            if (nullOK) {
                return null;
            }
            this.info("Error: missing parameter for key \"" + key + "\"");
            throw new DIServiceException(1048569);
        }
        if (1 < params.length) {
            this.info("Error: duplicate parameter for key \"" + key + "\"");
            throw new DIServiceException(1048561);
        }
        return params[0];
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.serializer = new DIServiceSerializer((ClientKeys)new OA2ClientKeys(), new ClientApprovalKeys());
        this.setExceptionHandler((ExceptionHandler)new DIServiceExceptionHandler(this, this.getMyLogger()));
    }

    protected void checkUserCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!request.getParameterMap().containsKey(USER_CODE_PARAMETER)) {
            this.doError("No user code parameter was found.", 1048569, response);
            return;
        }
        String userCode = request.getParameter(USER_CODE_PARAMETER);
        if (StringUtils.isTrivial((String)userCode)) {
            this.doError("No user code parameter was found.", 1048569, response);
        }
        RFC8628ServletConfig rfc8628ServletConfig = ((OA2SE)OA4MPServlet.getServiceEnvironment()).getRfc8628ServletConfig();
        userCode = RFC8628Servlet.convertToCanonicalForm((String)userCode, (RFC8628ServletConfig)rfc8628ServletConfig);
        OA2SE se = (OA2SE)OA4MPServlet.getServiceEnvironment();
        if (!se.isRfc8628Enabled()) {
            this.doError("Device flow is not available on this server.", 65557, response);
            return;
        }
        RFC8628Store rfc8628Store = (RFC8628Store)this.getTransactionStore();
        OA2ServiceTransaction transaction = (OA2ServiceTransaction)rfc8628Store.getByUserCode(userCode);
        if (transaction == null) {
            this.doError("transaction not found.", 65537, response);
            return;
        }
        AuthorizationGrantImpl ag = (AuthorizationGrantImpl)transaction.getAuthorizationGrant();
        if (ag.isExpired()) {
            this.doError("token not found.", 65539, response);
            return;
        }
        if (transaction == null) {
            this.doError("transaction not found.", 65537, response);
            return;
        }
        MetaDebugUtil debugger = OA4MPServlet.createDebugger((BaseClient)transaction.getClient());
        debugger.trace((Object)this, "checking transaction.");
        if (!transaction.isRFC8628Request()) {
            this.doError("invalid token.", 65537, response);
            return;
        }
        this.startWrite(response);
        PrintWriter printWriter = response.getWriter();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)STATUS_KEY, (Object)0);
        jsonObject.put((Object)"client_id", (Object)transaction.getClient().getIdentifierString());
        debugger.trace((Object)this, "writing response for grant = " + ag.getToken());
        jsonObject.put((Object)GRANT_PARAMETER, (Object)TokenUtils.b32EncodeToken((String)ag.getToken()));
        jsonObject.put((Object)"scope", (Object)transaction.getRFC8628State().originalScopes);
        jsonObject.put((Object)USER_CODE_PARAMETER, (Object)userCode);
        printWriter.println(jsonObject);
        printWriter.flush();
        printWriter.close();
        this.stopWrite(response);
    }

    protected void approveUserCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!request.getParameterMap().containsKey(USER_CODE_PARAMETER)) {
            this.doError("No user code parameter was found.", 1048569, response);
            return;
        }
        if (StringUtils.isTrivial((String)request.getParameter(USER_CODE_PARAMETER))) {
            this.doError("No user code parameter was found.", 1048569, response);
            return;
        }
        int approved = 1;
        if (request.getParameterMap().containsKey(APPROVED_PARAMETER)) {
            try {
                approved = Integer.parseInt(request.getParameter(APPROVED_PARAMETER));
            }
            catch (NumberFormatException nfx) {
                this.doError("unknown value for approved parameter \"" + request.getParameter(APPROVED_PARAMETER) + "\"", 1048569, response);
            }
        }
        if (approved != 0 && approved != 1) {
            this.doError("illegal argument approved = \"" + approved + "\"", 1048567, response);
            return;
        }
        String userCode = request.getParameter(USER_CODE_PARAMETER);
        if (StringUtils.isTrivial((String)userCode)) {
            this.doError("No user code parameter was found.", 1048569, response);
            return;
        }
        RFC8628ServletConfig rfc8628ServletConfig = ((OA2SE)OA4MPServlet.getServiceEnvironment()).getRfc8628ServletConfig();
        userCode = RFC8628Servlet.convertToCanonicalForm((String)userCode, (RFC8628ServletConfig)rfc8628ServletConfig);
        OA2SE se = this.getOA2SE();
        if (!se.isRfc8628Enabled()) {
            this.doError("Device flow is not available on this server.", 65557, response);
            return;
        }
        RFC8628Store rfc8628Store = (RFC8628Store)this.getTransactionStore();
        OA2ServiceTransaction transaction = (OA2ServiceTransaction)rfc8628Store.getByUserCode(userCode);
        if (transaction == null) {
            this.doError("transaction not found.", 65537, response);
            return;
        }
        AuthorizationGrantImpl ag = (AuthorizationGrantImpl)transaction.getAuthorizationGrant();
        MetaDebugUtil debugger = OA4MPServlet.createDebugger((BaseClient)transaction.getOA2Client());
        debugger.trace((Object)this, "checking if server is RFC 8628 enabled");
        if (!transaction.isRFC8628Request()) {
            this.doError("invalid token.", 65537, response);
            return;
        }
        RFC8628State rfc8628State = transaction.getRFC8628State();
        transaction.setUserCode("");
        if (approved != 1) {
            debugger.trace((Object)this, "device flow for user code " + userCode + " cancelled");
            this.cancelFlow(response, transaction);
            return;
        }
        rfc8628State.valid = true;
        debugger.trace((Object)this, "device flow for user code " + userCode + " approved");
        transaction.setRFC8628State(rfc8628State);
        this.setNameAndTime(request, debugger, transaction);
        this.getTransactionStore().save((Identifiable)transaction);
        this.startWrite(response);
        PrintWriter printWriter = response.getWriter();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)STATUS_KEY, (Object)0);
        jsonObject.put((Object)"client_id", (Object)transaction.getClient().getIdentifierString());
        debugger.trace((Object)this, "encoding grant for " + userCode + " = " + ag.getToken());
        jsonObject.put((Object)GRANT_PARAMETER, (Object)TokenUtils.b32EncodeToken((String)ag.getToken()));
        jsonObject.put((Object)USER_CODE_PARAMETER, (Object)userCode);
        printWriter.println(jsonObject);
        printWriter.flush();
        printWriter.close();
        this.stopWrite(response);
    }

    private void cancelFlow(HttpServletResponse response, OA2ServiceTransaction transaction) throws IOException {
        this.getTransactionStore().remove((Object)transaction.getIdentifier());
        this.startWrite(response);
        PrintWriter printWriter = response.getWriter();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)STATUS_KEY, (Object)0);
        printWriter.println(jsonObject);
        printWriter.flush();
        printWriter.close();
        this.stopWrite(response);
    }

    private void setNameAndTime(HttpServletRequest request, MetaDebugUtil debugger, OA2ServiceTransaction transaction) {
        String username = request.getParameter(USER_NAME_PARAMETER);
        if (StringUtils.isTrivial((String)username)) {
            debugger.warn("missing username parameter");
        } else {
            transaction.setUsername(username);
        }
        long authTime = 0L;
        try {
            authTime = request.getParameter("auth_time") == null ? new Date().getTime() : Long.parseLong(request.getParameter("auth_time"));
        }
        catch (Throwable t) {
            this.info("Got auth_time=" + request.getParameter("auth_time") + ", error=\"" + t.getMessage() + "\"");
        }
        transaction.setAuthTime(new Date(authTime * 1000L));
    }

    protected void startAuthCodeFlow(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServletDebugUtil.trace((Object)((Object)this), (String)"createTransaction: ******** NEW CALL ******** ");
        ServletDebugUtil.trace((Object)((Object)this), (String)"createTransaction: printing request ");
        OA2AuthorizedServletUtil initUtil = new OA2AuthorizedServletUtil((OA4MPServlet)this);
        if (!req.getParameterMap().containsKey("client_id")) {
            this.doError("No client id parameter was found.", 1048569, resp);
            return;
        }
        String clientID = req.getParameter("client_id");
        if (clientID == null || clientID.isEmpty()) {
            this.doError("No value for client id parameter was found.", 65545, resp);
            return;
        }
        if (!req.getParameterMap().containsKey("scope")) {
            this.doError("No scopes found.", 65553, resp);
        } else {
            String values = req.getParameter("scope");
            if (-1 != values.indexOf(",")) {
                this.doError("No scopes found.", 65555, resp);
            }
        }
        Identifier client_id = null;
        try {
            client_id = BasicIdentifier.newID((String)clientID);
        }
        catch (Throwable t) {
            this.doError("Invalid client id syntax.", 1048567, resp);
            return;
        }
        if (!OA4MPServlet.getServiceEnvironment().getClientStore().containsKey((Object)client_id)) {
            this.doError("Unknown client", 65549, resp);
            return;
        }
        if (!OA4MPServlet.getServiceEnvironment().getClientApprovalStore().isApproved(client_id)) {
            this.doError("Unapproved client.", 65551, resp);
            return;
        }
        OA2Client client = (OA2Client)this.getClient(req);
        MetaDebugUtil debugger = OA4MPServlet.createDebugger((BaseClient)client);
        try {
            OA2ServiceTransaction transaction = initUtil.doDelegation(req, resp, true);
            if (debugger instanceof ClientDebugUtil) {
                ((ClientDebugUtil)debugger).setTransaction((ServiceTransaction)transaction);
            }
            this.getTransactionStore().save((Identifiable)transaction);
            debugger.trace((Object)this, "createTransaction: writing transaction. " + String.valueOf(transaction));
            this.writeTransaction(transaction, 0, resp);
            debugger.trace((Object)this, "createTransaction: ******** DONE ******** ");
        }
        catch (Throwable t) {
            if (t instanceof OA2GeneralError) {
                OA2GeneralError ge = (OA2GeneralError)t;
                debugger.trace((Object)this, "OA2GeneralError: " + String.valueOf(ge));
                DIServiceExceptionHandler.YAErr yaErr = DIServiceExceptionHandler.lookupErrorCode(ge.getError());
                if (yaErr.code == 1048563) {
                    yaErr.code = 65541;
                }
                debugger.trace((Object)this, "YAErr:" + yaErr.toString());
                if (yaErr.hasMessage()) {
                    this.doError(yaErr.message, yaErr.code, resp);
                } else {
                    this.doError(ge.getDescription(), yaErr.code, resp);
                }
                return;
            }
            try {
                this.getExceptionHandler().handleException(new ExceptionHandlerThingie(t, req, resp));
            }
            catch (Throwable xxx) {
                this.getMyLogger().warn("Unrecoverable error creating transaction:\"" + t.getMessage() + "\"");
                debugger.trace((Object)this, "Unrecoverable error: createTransaction failed. \"" + t.getMessage() + "\".", t);
                ServletDebugUtil.warn((Object)((Object)this), (String)("Unrecoverable error: Error creating transaction: \"" + t.getMessage() + "\"."));
                this.writeTransaction(null, 1048563, resp);
            }
        }
    }

    protected void finishAuthCodeFlow(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String ag = req.getParameter(GRANT_PARAMETER);
        if (ag == null || ag.trim().length() == 0) {
            String description = "Warning. No auth code. Cannot complete call.";
            this.getMyLogger().error(description);
            this.writeMessage(resp, new Err(1048569, "missing_argument", description));
            return;
        }
        if (TokenUtils.isBase32((String)ag)) {
            ag = TokenUtils.b32DecodeToken((String)ag);
        }
        Identifier identifier = BasicIdentifier.newID((String)ag);
        AuthorizationGrantImpl authGrant = new AuthorizationGrantImpl(URI.create(ag));
        try {
            DateUtils.checkTimestamp((String)ag);
        }
        catch (InvalidTimestampException xx) {
            String description = "The auth grant \"" + ag + "\" is expired. No transaction found.";
            this.getMyLogger().error(description);
            this.writeTransaction(null, new Err(65539, "token_expired", StatusCodes.getMessage(65539)), resp);
            return;
        }
        if (!this.getTransactionStore().containsKey((Object)identifier)) {
            this.getMyLogger().error("The auth grant \"" + String.valueOf(authGrant) + "\" is not a key for this transaction. No transaction found.");
            this.writeTransaction(null, new Err(65537, "transaction_not_found", StatusCodes.getMessage(65537)), resp);
            return;
        }
        String myproxyUsername = req.getParameter(MYPROXY_USERNAME_PARAMETER);
        OA2ServiceTransaction t = null;
        try {
            t = (OA2ServiceTransaction)this.getTransaction((AuthorizationGrant)authGrant);
        }
        catch (Throwable throwable) {
            String description = "Getting the transaction for auth grant \"" + String.valueOf(authGrant) + "\" failed.";
            this.getMyLogger().error(description, throwable);
            this.writeTransaction(t, new Err(65537, "transaction_not_found", StatusCodes.getMessage(65537)), resp);
            return;
        }
        if (t == null) {
            this.getMyLogger().error("Getting the transaction for auth grant \"" + String.valueOf(authGrant) + "\" failed. No transaction found.");
            this.writeTransaction(t, new Err(65537, "transaction_not_found", StatusCodes.getMessage(65537)), resp);
            return;
        }
        MetaDebugUtil debugger = OA4MPServlet.createDebugger((BaseClient)t.getClient());
        int approved = 1;
        if (req.getParameterMap().containsKey(APPROVED_PARAMETER)) {
            try {
                approved = Integer.parseInt(req.getParameter(APPROVED_PARAMETER));
            }
            catch (NumberFormatException nfx) {
                this.doError("unknown value for approved parameter \"" + req.getParameter(APPROVED_PARAMETER) + "\"", 1048569, resp);
                return;
            }
        }
        switch (approved) {
            case 0: {
                this.cancelFlow(resp, t);
                return;
            }
            case 1: {
                break;
            }
            default: {
                this.doError("illegal argument approved = \"" + approved + "\"", 1048567, resp);
                return;
            }
        }
        if (debugger instanceof ClientDebugUtil) {
            ((ClientDebugUtil)debugger).setTransaction((ServiceTransaction)t);
        }
        if (myproxyUsername != null) {
            t.setMyproxyUsername(URLDecoder.decode(myproxyUsername, "UTF-8"));
        }
        t.setAuthGrantValid(true);
        try {
            debugger.trace((Object)this, "Starting to process claims");
            this.doUserClaims(t, req, debugger);
        }
        catch (ScriptRuntimeException srx) {
            debugger.trace((Object)this, "Explicit script runtime exception:" + srx.getMessage(), (Throwable)srx);
            Err err = new Err(srx.getCode() == ScriptRuntimeException.DEFAULT_NO_OP_CODE ? 0x100007 : srx.getCode(), srx.getRequestedType(), srx.getMessage(), srx.getErrorURI(), srx.getCustomErrorURI());
            this.writeMessage(resp, err);
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof QDLException) {
                QDLException qdlException = (QDLException)throwable;
                String description = qdlException.getMessage();
                debugger.trace((Object)this, "QDL error", throwable);
                this.writeTransaction(t, new Err(0x100007, "server_error", description), resp);
                return;
            }
            if (throwable instanceof RuntimeException) {
                this.getMyLogger().error(throwable.getMessage(), throwable);
                debugger.trace((Object)this, "Java runtime exception running QDL", throwable);
                this.writeTransaction(t, new Err(0x100009, "server_error", throwable.getMessage()), resp);
                return;
            }
            this.getMyLogger().error("Could not get claims", throwable);
            debugger.trace((Object)this, "Exception running QDL, throwing GeneralException", throwable);
            throw new GeneralException(throwable);
        }
        this.setNameAndTime(req, debugger, t);
        HashMap<String, String> cbParams = new HashMap<String, String>();
        cbParams.put("state", t.getRequestState());
        String cb = OA2AuthorizedServletUtil.createCallback((ServiceTransaction)t, cbParams);
        this.getTransactionStore().save((Identifiable)t);
        this.startWrite(resp);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)STATUS_KEY, (Object)0);
        jsonObject.put((Object)"redirect_uri", (Object)cb);
        PrintWriter printWriter = resp.getWriter();
        printWriter.println(jsonObject);
        printWriter.flush();
        printWriter.close();
        this.stopWrite(resp);
    }

    protected void doUserClaims(OA2ServiceTransaction t, HttpServletRequest request, MetaDebugUtil debugger) throws Throwable {
        OA2SE env = this.getOA2SE();
        debugger.trace((Object)this, "Starting  post_auth claims");
        env.getTransactionStore().save((Identifiable)t);
        HandlerRunner jwtRunner = new HandlerRunner((OIDCServiceTransactionInterface)t, ScriptRuntimeEngineFactory.createRTE((OA2SE)env, (OA2ServiceTransaction)t, (JSONObject)t.getOA2Client().getConfig()));
        OA2Client resolvedClient = OA2ClientUtils.resolvePrototypes((ClientStore)env.getClientStore(), (OA2Client)t.getOA2Client());
        OA2ClientUtils.setupHandlers((HandlerRunner)jwtRunner, (OA2SE)env, (OA2ServiceTransaction)t, (OA2Client)resolvedClient, (HttpServletRequest)request);
        jwtRunner.doAuthClaims();
        debugger.trace((Object)this, "Done with all post_auth claims");
    }

    protected void writeTransaction(OA2ServiceTransaction oa2ServiceTransaction, int status, HttpServletResponse response) throws IOException {
        this.startWrite(response);
        this.serializer.serialize(response.getWriter(), oa2ServiceTransaction, status);
        this.stopWrite(response);
    }

    protected void writeTransaction(OA2ServiceTransaction oa2ServiceTransaction, Err errResponse, HttpServletResponse response) throws IOException {
        this.startWrite(response);
        this.serializer.serialize(response.getWriter(), oa2ServiceTransaction, errResponse);
        this.stopWrite(response);
    }

    protected void doError(String message, int errorCode, HttpServletResponse resp) throws IOException {
        ServletDebugUtil.trace((Object)((Object)this), (String)("createTransaction failed: \"" + message + "\", code=" + errorCode));
        this.writeTransaction(null, new Err(errorCode, "create_transaction_failed", message), resp);
    }

    protected void startWrite(HttpServletResponse response) {
        response.setContentType("oa4mp:form_encoding");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
    }

    protected void stopWrite(HttpServletResponse response) throws IOException {
        response.getWriter().flush();
        response.getWriter().close();
    }

    protected void writeMessage(HttpServletResponse response, Err errResponse) throws IOException {
        this.startWrite(response);
        this.serializer.writeMessage(response.getWriter(), errResponse);
        this.stopWrite(response);
    }

    protected OA2SE getOA2SE() {
        return (OA2SE)OA4MPServlet.getServiceEnvironment();
    }

    public ServiceTransaction verifyAndGet(IssuerResponse iResponse) throws IOException {
        return null;
    }
}

