/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.di;

import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.servlet.ExceptionHandlerThingie;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.oa4mp.delegation.server.OA2Errors;
import org.oa4mp.delegation.server.OA2GeneralError;
import org.oa4mp.di.DIService;
import org.oa4mp.di.Err;
import org.oa4mp.server.loader.oauth2.servlet.OA2ExceptionHandler;

public class DIServiceExceptionHandler
extends OA2ExceptionHandler
implements OA2Errors {
    DIService diService;

    public DIServiceExceptionHandler(DIService diService, MyLoggingFacade logger) {
        super(logger);
        this.diService = diService;
    }

    public void handleException(ExceptionHandlerThingie xh) throws IOException, ServletException {
        Throwable t = xh.throwable;
        HttpServletRequest request = xh.request;
        HttpServletResponse response = xh.response;
        if (t instanceof OA2GeneralError) {
            OA2GeneralError ge = (OA2GeneralError)t;
            Err err = new Err(1048563, ge.getError(), ge.getDescription());
            this.diService.writeMessage(response, err);
            return;
        }
        super.handleException(xh);
    }

    public static YAErr lookupErrorCode(String oa2Error) {
        switch (oa2Error) {
            case "interaction_required": {
                return new YAErr(1048563, null);
            }
            case "login_required": {
                return new YAErr(1048563, null);
            }
            case "account_selection_required": {
                return new YAErr(1048563, null);
            }
            case "consent_required": {
                return new YAErr(1048563, null);
            }
            case "invalid_request_object": {
                return new YAErr(1048563, null);
            }
            case "invalid_request": {
                return new YAErr(1048563, null);
            }
            case "invalid_request_uri": {
                return new YAErr(1048563, null);
            }
            case "unauthorized_client": {
                return new YAErr(1048575, null);
            }
            case "access_denied": {
                return new YAErr(1048563, null);
            }
            case "unsupported_response_type": {
                return new YAErr(1048563, null);
            }
            case "invalid_scope": {
                return new YAErr(65555, null);
            }
            case "temporarily_unavailable": {
                return new YAErr(1048563, null);
            }
            case "server_error": {
                return new YAErr(1048563, null);
            }
            case "invalid_token": {
                return new YAErr(65539, null);
            }
            case "invalid_grant": {
                return new YAErr(65539, null);
            }
            case "invalid_target": {
                return new YAErr(1048563, null);
            }
        }
        return new YAErr(1048563, "general error");
    }

    public static class YAErr {
        int code;
        String message;

        public YAErr(int code, String message) {
            this.code = code;
            this.message = message;
        }

        public boolean hasMessage() {
            return this.message != null;
        }

        public String toString() {
            return "YAErr{code=" + this.code + ", message='" + this.message + "'}";
        }
    }
}

