/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.di;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.Iso8601;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Map;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.ClientApprovalKeys;
import org.oa4mp.delegation.common.storage.clients.ClientKeys;
import org.oa4mp.di.DIServiceException;
import org.oa4mp.di.Err;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;

public class DIServiceSerializer {
    public static final String UTF8_ENCODING = "UTF-8";
    protected ClientKeys clientKeys;
    protected ClientApprovalKeys clientApprovalKeys;

    public DIServiceSerializer(ClientKeys cKeys, ClientApprovalKeys caKeys) {
        this.clientKeys = cKeys;
        this.clientApprovalKeys = caKeys;
    }

    public void writeMessage(PrintWriter w, String message) throws IOException {
        this.print(w, "status", message);
    }

    public void writeMessage(PrintWriter w, int statusCode) throws IOException {
        this.print(w, "status", Integer.toString(statusCode));
    }

    public void serialize(PrintWriter w, Map<String, Object> map) throws IOException {
        this.writeMessage(w, map.get("status").toString());
        for (String k : map.keySet()) {
            if (k.equals("status")) continue;
            this.print(w, k, map.get(k).toString());
        }
    }

    protected void onlyPrintIfNotTrivial(PrintWriter w, String key, String value) throws IOException {
        if (value != null && !value.isEmpty()) {
            this.print(w, key, value);
        }
    }

    public boolean reponseOk(InputStream is) throws IOException {
        return this.readResponseOnly(is) % 2 == 0;
    }

    public int readResponseOnly(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String linein = br.readLine();
        String[] x = this.splitLine(linein);
        br.close();
        try {
            return Integer.parseInt(x[1]);
        }
        catch (NumberFormatException nfx) {
            throw new GeneralException("Error: unparseable response: " + linein, (Throwable)nfx);
        }
    }

    protected String[] splitLine(String linein) throws UnsupportedEncodingException {
        int pos = linein.indexOf("=");
        String head = linein.substring(0, pos);
        String tail = this.decode(linein.substring(pos + 1));
        return new String[]{head, tail};
    }

    protected String[] parseLine(String linein) throws UnsupportedEncodingException {
        String[] x = this.splitLine(linein);
        this.checkForStatus(x[0], x[1]);
        return x;
    }

    protected void checkForStatus(String head, String tail) {
        if (head.equals("status")) {
            if (Integer.parseInt(tail) % 2 == 0) {
                return;
            }
            ServletDebugUtil.trace((Object)this, (String)("Got unrecognized response of head=\"" + head + "\" tail=\"" + tail + "\""));
            throw new DIServiceException(tail);
        }
    }

    protected String encode(String x) throws UnsupportedEncodingException {
        return URLEncoder.encode(x, UTF8_ENCODING);
    }

    protected String encode(URI x) throws UnsupportedEncodingException {
        return this.encode(x.toString());
    }

    public String decode(String x) throws UnsupportedEncodingException {
        return URLDecoder.decode(x, UTF8_ENCODING);
    }

    protected void print(PrintWriter w, String key, Identifier identifier) throws IOException {
        this.print(w, key, identifier == null ? "" : identifier.toString());
    }

    protected void print(PrintWriter w, String key, URI uri) throws IOException {
        this.print(w, key, uri == null ? "" : uri.toString());
    }

    protected void print(PrintWriter w, String key, Date date) throws IOException {
        this.print(w, key, Iso8601.date2String((Date)date));
    }

    public void print(PrintWriter w, String key, String value) throws IOException {
        w.println(key + "=" + (value == null ? "" : this.encode(value)));
    }

    public void print(PrintWriter w, String key, Object value) throws IOException {
        w.println(key + "=" + (value == null ? "" : this.encode(value.toString())));
    }

    public void serialize(PrintWriter w, OA2ServiceTransaction oa2ServiceTransaction, int status) throws IOException {
        this.writeMessage(w, status);
    }

    public void serialize(PrintWriter w, OA2ServiceTransaction oa2ServiceTransaction, Err errResponse) throws IOException {
        this.writeMessage(w, errResponse);
    }

    public void writeMessage(PrintWriter w, Err errResponse) throws IOException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"status", (Object)errResponse.code);
        jsonObject.put((Object)"error", (Object)errResponse.error);
        jsonObject.put((Object)"description", (Object)errResponse.description);
        if (errResponse.customErrorURI != null) {
            jsonObject.put((Object)"custom_error_uri", (Object)errResponse.customErrorURI.toString());
        }
        if (errResponse.errorURI != null) {
            jsonObject.put((Object)"error_uri", (Object)errResponse.errorURI.toString());
        }
        w.println(jsonObject);
    }
}

