/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.myproxy.servlet;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.storage.GenericStoreUtils;
import edu.uiuc.ncsa.security.storage.XMLMap;
import edu.uiuc.ncsa.security.util.crypto.CertUtil;
import edu.uiuc.ncsa.security.util.crypto.MyPKCS10CertRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.oa4mp.delegation.common.services.Request;
import org.oa4mp.delegation.common.servlet.TransactionState;
import org.oa4mp.delegation.common.storage.transactions.BasicTransaction;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.issuers.PAIssuer;
import org.oa4mp.delegation.server.request.IssuerResponse;
import org.oa4mp.delegation.server.request.PARequest;
import org.oa4mp.delegation.server.request.PAResponse;
import org.oa4mp.myproxy.servlet.MyProxyServlet;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ACS2
extends MyProxyServlet {
    protected PAIssuer getPAI() throws IOException {
        return ACS2.getServiceEnvironment().getPaIssuer();
    }

    protected void doIt(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        this.doDelegation(httpServletRequest, httpServletResponse);
    }

    protected void doDelegation(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        this.info("6.a. Starting to process cert request");
        AccessToken accessToken = this.getAccessToken(httpServletRequest);
        ServiceTransaction serviceTransaction = (ServiceTransaction)this.getTransactionStore().get(accessToken);
        XMLMap backup = GenericStoreUtils.toXML((Store)this.getTransactionStore(), (Identifiable)serviceTransaction);
        PARequest paRequest = new PARequest(httpServletRequest, serviceTransaction);
        String statusString = "client = " + String.valueOf(paRequest.getClient().getIdentifier());
        paRequest.setAccessToken(accessToken);
        PAResponse paResponse = (PAResponse)this.getPAI().process((Request)paRequest);
        this.debug("6.a. " + statusString);
        ServiceTransaction t = this.verifyAndGet((IssuerResponse)paResponse);
        Map params = httpServletRequest.getParameterMap();
        if (t.getCertReq() == null) {
            MyPKCS10CertRequest certReq;
            if (!params.containsKey(ACS2.CONST((String)"oa4mp:certreq"))) {
                throw new GeneralException("Error: Missing cert request parameter.");
            }
            String rawCR = ((String[])params.get(ACS2.CONST((String)"oa4mp:certreq")))[0];
            if (this.isEmpty(rawCR)) {
                throw new GeneralException("Error: Empty cert request.");
            }
            try {
                certReq = CertUtil.fromStringToCertReq((String)rawCR);
            }
            catch (Throwable throwable) {
                if (DebugUtil.isEnabled()) {
                    throwable.printStackTrace();
                }
                GenericStoreUtils.fromXMLAndSave((Store)this.getTransactionStore(), (XMLMap)backup);
                throw new GeneralException("Error: cert request is bad/not understandable:" + (rawCR == null ? "(null)" : rawCR), throwable);
            }
            t.setCertReq(certReq);
            if (params.containsKey(ACS2.CONST((String)"oa4mp:certlifetime"))) {
                t.setLifetime(1000L * Long.parseLong(((String[])params.get(ACS2.CONST((String)"oa4mp:certlifetime")))[0]));
            } else {
                t.setLifetime(864000000L);
            }
            this.getTransactionStore().save((Identifiable)t);
        }
        this.info("6.a. Processing request for transaction " + String.valueOf(t.getIdentifier()));
        this.doRealCertRequest(t, statusString);
        t.setAccessTokenValid(false);
        this.preprocess(new TransactionState(httpServletRequest, httpServletResponse, paResponse.getParameters(), (BasicTransaction)t, backup));
        this.debug("6.a. protected asset:" + (t.getProtectedAsset() == null ? "(null)" : "ok") + ", " + statusString);
        HashMap<String, String> username = new HashMap<String, String>();
        username.put("username", t.getUsername());
        if (paResponse.getParameters() != null) {
            username.putAll(paResponse.getParameters());
        }
        paResponse.setAdditionalInformation(username);
        paResponse.setProtectedAsset(t.getProtectedAsset());
        this.debug("6.a. Added username \"" + t.getUsername() + "\" & cert for request from " + statusString);
        this.getTransactionStore().save((Identifiable)t);
        this.info("6.b. Done with cert request " + statusString);
        paResponse.write(httpServletResponse);
        this.info("6.b. Completed transaction " + t.getIdentifierString() + ", " + statusString);
        this.postprocess(new TransactionState(httpServletRequest, httpServletResponse, paResponse.getParameters(), (BasicTransaction)t, backup));
    }
}

