/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.myproxy.servlet;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.DateUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.myproxy.servlet.AuthorizedServlet;
import org.oa4mp.myproxy.servlet.MyProxyServlet;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;

public abstract class AuthorizedServlet
extends MyProxyServlet {
    public static final String STATUS_KEY = "status";
    public static final String STATUS_OK = "ok";
    public static final String REDIRECT_URL_KEY = "redirect_url";

    public abstract String createCallback(ServiceTransaction var1);

    protected abstract ProtocolParameters parseRequest(HttpServletRequest var1) throws ServletException;

    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        ProtocolParameters p = this.parseRequest(request);
        ServiceTransaction trans = this.getAndCheckTransaction(p);
        trans.setUsername(p.userId);
        this.getTransactionStore().save((Identifiable)trans);
        this.createMPConnection(trans.getIdentifier(), p.userId, p.password, p.lifetime);
        this.doRealCertRequest(trans, "");
        this.writeResponse(response, trans);
    }

    protected void writeResponse(HttpServletResponse response, ServiceTransaction transaction) throws IOException {
        String cb = this.createCallback(transaction);
        PrintWriter w = response.getWriter();
        Object returnedString = "status=ok\n";
        response.setStatus(200);
        returnedString = (String)returnedString + "redirect_url=" + cb;
        ((Writer)w).write((String)returnedString);
        ((Writer)w).close();
        response.sendRedirect(cb);
    }

    protected ServiceTransaction getAndCheckTransaction(ProtocolParameters p) throws Throwable {
        String token = p.token;
        DateUtils.checkTimestamp((String)token);
        AuthorizationGrant grant = OA4MPServlet.getServiceEnvironment().getTokenForge().getAuthorizationGrant(new String[]{token});
        DateUtils.checkTimestamp((String)grant.getToken());
        ServiceTransaction trans = (ServiceTransaction)OA4MPServlet.getServiceEnvironment().getTransactionStore().get(grant);
        if (trans == null) {
            this.warn("Error: no delegation request found for " + token);
            throw new GeneralException("Error: no delegation request found.");
        }
        this.checkClientApproval((BaseClient)trans.getClient());
        return trans;
    }
}

