/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.myproxy.servlet;

import edu.uiuc.ncsa.myproxy.MyProxyServiceFacade;
import edu.uiuc.ncsa.myproxy.ServiceFacadeConfiguration;
import edu.uiuc.ncsa.security.core.configuration.Configurations;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.core.configuration.provider.HierarchicalConfigProvider;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.util.ssl.SSLConfiguration;
import edu.uiuc.ncsa.security.util.ssl.SSLConfigurationUtil;
import edu.uiuc.ncsa.security.util.ssl.SSLKeystoreConfiguration;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.oa4mp.server.api.OA4MPConfigTags;

public class MyProxyFacadeProvider
extends HierarchicalConfigProvider<MyProxyServiceFacade>
implements OA4MPConfigTags {
    String defaultServerDN = null;

    protected boolean checkEvent(CfgEvent cfgEvent) {
        if (cfgEvent.getConfiguration().getName().equals("myproxy")) {
            this.setConfig(cfgEvent.getConfiguration());
            return true;
        }
        return false;
    }

    public Object componentFound(CfgEvent configurationEvent) {
        if (this.checkEvent(configurationEvent)) {
            return this.get();
        }
        return null;
    }

    public MyProxyServiceFacade get() {
        ServiceFacadeConfiguration sfc;
        HashMap<String, Integer> loas = new HashMap<String, Integer>();
        String localhostname = null;
        String serverDN = null;
        try {
            localhostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            localhostname = "localhost";
        }
        int port = 7512;
        long socketTimeout = 0L;
        SSLConfiguration sslKeystoreConfiguration = SSLConfigurationUtil.getSSLConfiguration(null, (ConfigurationNode)this.getConfig());
        if (this.getConfig() == null) {
            sfc = new ServiceFacadeConfiguration(localhostname, port, socketTimeout, loas, serverDN);
        } else {
            boolean useProxy22;
            String rawUseProxy = this.getAttribute("useProxy");
            if (!StringUtils.isTrivial((String)rawUseProxy) && (useProxy22 = this.getBooleanAttribute("useProxy"))) {
                return new MyProxyServiceFacade(new ServiceFacadeConfiguration(true), (SSLKeystoreConfiguration)sslKeystoreConfiguration);
            }
            serverDN = this.getAttribute("serverDN");
            if (serverDN == null && this.hasDefaultServerDN()) {
                serverDN = this.getDefaultServerDN();
            }
            try {
                port = this.getIntAttribute("port");
            }
            catch (Throwable useProxy22) {
                // empty catch block
            }
            try {
                socketTimeout = this.getIntAttribute("socketTimeout");
            }
            catch (Throwable useProxy22) {
                // empty catch block
            }
            if (this.getAttribute("host") != null) {
                localhostname = this.getAttribute("host");
            }
            sfc = new ServiceFacadeConfiguration(localhostname, port, socketTimeout, loas, serverDN);
            List list = this.getConfig().getChildren("loa");
            if (!list.isEmpty()) {
                for (Object obj : list) {
                    ConfigurationNode cn = (ConfigurationNode)obj;
                    loas.put(Configurations.getFirstAttribute((ConfigurationNode)cn, (String)"name"), Integer.parseInt(Configurations.getFirstAttribute((ConfigurationNode)cn, (String)"port")));
                }
            }
        }
        return new MyProxyServiceFacade(sfc, (SSLKeystoreConfiguration)sslKeystoreConfiguration);
    }

    public MyProxyFacadeProvider() {
    }

    public MyProxyFacadeProvider(ConfigurationNode config, String defaultServerDN) {
        super(config);
        this.defaultServerDN = defaultServerDN;
    }

    public MyProxyFacadeProvider(ConfigurationNode config) {
        super(config);
    }

    public boolean hasDefaultServerDN() {
        return this.defaultServerDN != null;
    }

    public String getDefaultServerDN() {
        return this.defaultServerDN;
    }

    public void setDefaultServerDN(String defaultServerDN) {
        this.defaultServerDN = defaultServerDN;
    }
}

