/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.myproxy.servlet;

import edu.uiuc.ncsa.myproxy.MPConnectionProvider;
import edu.uiuc.ncsa.myproxy.MyProxyConnectable;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.cache.Cache;
import edu.uiuc.ncsa.security.core.cache.Cacheable;
import edu.uiuc.ncsa.security.core.cache.CachedObject;
import edu.uiuc.ncsa.security.core.cache.Cleanup;
import edu.uiuc.ncsa.security.core.exceptions.ConnectionException;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.util.crypto.CertUtil;
import edu.uiuc.ncsa.security.util.crypto.MyPKCS10CertRequest;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.LinkedList;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.MyX509Certificates;
import org.oa4mp.delegation.common.token.ProtectedAsset;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.myproxy.servlet.MyProxyServiceEnvironment;
import org.oa4mp.myproxy.util.JGlobusUtil;
import org.oa4mp.server.api.storage.servlet.OA4MPServlet;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class MyProxyServlet
extends OA4MPServlet {
    public static Cache myproxyConnectionCache;
    public static Cleanup<Identifier, CachedObject> myproxyConnectionCleanup;

    protected abstract void doRealCertRequest(ServiceTransaction var1, String var2) throws Throwable;

    protected abstract AccessToken getAccessToken(HttpServletRequest var1);

    protected void doCertRequest(ServiceTransaction trans, String statusString) throws Throwable {
        if (!this.hasMPConnection(trans)) {
            throw new ConnectionException("Error: There is no currently active MyProxy connection.");
        }
        MyPKCS10CertRequest localCertRequest = trans.getCertReq();
        KeyPair keyPair = null;
        if (trans.getClient().isProxyLimited()) {
            this.info("3.b. starting proxy limited for " + String.valueOf(trans.getClient().getIdentifier()) + ". Generating keypair and cert request.");
            try {
                keyPair = MyProxyServlet.getServiceEnvironment().getKeyPair();
                localCertRequest = CertUtil.createCertRequest((KeyPair)keyPair);
            }
            catch (GeneralSecurityException e) {
                this.error("3.b. " + e.getMessage());
                throw new GeneralException("Error: Could not create cert request:" + e.getMessage());
            }
        }
        LinkedList certs = this.getX509Certificates(trans, localCertRequest, statusString);
        this.debug("3.b. Got cert from server, count=" + certs.size());
        LinkedList certList = new LinkedList();
        if (trans.getClient().isProxyLimited()) {
            this.info("3.b. Limited proxy for client " + String.valueOf(trans.getClient().getIdentifier()) + ", creating limited cert and signing it.");
            certList.addAll(certs);
            certList.addFirst(JGlobusUtil.createProxyCertificate((X509Certificate)((X509Certificate)certs.getLast()), (PrivateKey)keyPair.getPrivate(), (PublicKey)trans.getCertReq().getPublicKey(), (int)((int)(trans.getLifetime() / 1000L))));
            certs = certList;
        }
        this.debug("3.b. Preparing to return cert chain of " + certs.size() + " to client.");
        MyX509Certificates myCerts = new MyX509Certificates((Collection)certs);
        trans.setProtectedAsset((ProtectedAsset)myCerts);
        String userName = trans.getUsername();
        if (MyProxyServlet.getServiceEnvironment().getAuthorizationServletConfig().isReturnDnAsUsername()) {
            if (myCerts.getX509Certificates().length > 0) {
                X500Principal x500Principal = myCerts.getX509Certificates()[0].getSubjectX500Principal();
                userName = x500Principal.getName();
                if (MyProxyServlet.getServiceEnvironment().getAuthorizationServletConfig().isConvertDNToGlobusID()) {
                    userName = JGlobusUtil.toGlobusID((String)userName);
                }
                this.debug(statusString + ": USERNAME = " + userName);
            } else {
                userName = "no_certificates_found";
            }
            trans.setUsername(userName);
            this.info("3.c. Set username returned to client to first certificate's DN: " + userName);
        }
        trans.setUsername(userName);
        MyProxyServlet.getServiceEnvironment().getTransactionStore().save((Identifiable)trans);
        if (this.hasMPConnection(trans.getIdentifier())) {
            this.getMPConnection(trans.getIdentifier()).close();
        }
    }

    public static Cache getMyproxyConnectionCache() {
        if (myproxyConnectionCache == null) {
            myproxyConnectionCache = new Cache();
        }
        return myproxyConnectionCache;
    }

    protected boolean hasMPConnection(Identifier identifier) {
        return MyProxyServlet.getMyproxyConnectionCache().containsKey((Object)identifier);
    }

    protected boolean hasMPConnection(ServiceTransaction transaction) {
        return this.hasMPConnection(transaction.getIdentifier());
    }

    protected MyProxyConnectable getMPConnection(ServiceTransaction transaction) {
        return this.getMPConnection(transaction.getIdentifier());
    }

    protected MyProxyConnectable getMPConnection(Identifier identifier) {
        return (MyProxyConnectable)MyProxyServlet.getMyproxyConnectionCache().get((Object)identifier).getValue();
    }

    protected LinkedList<X509Certificate> getX509Certificates(ServiceTransaction transaction, MyPKCS10CertRequest localCertRequest, String statusString) {
        MyProxyConnectable mpc = this.getMPConnection(transaction);
        mpc.setLifetime(transaction.getLifetime());
        LinkedList certs = mpc.getCerts(localCertRequest);
        if (certs.isEmpty()) {
            this.info(statusString + "Error: MyProxy service returned no certs.");
            throw new GeneralException("Error: MyProxy service returned no certs.");
        }
        this.info(statusString + "Got cert from MyProxy, issuing a limited proxy & storing it.");
        return certs;
    }

    protected MyProxyConnectable createMPConnection(Identifier identifier, String userName, String password, long lifetime) throws GeneralSecurityException {
        return this.createMPConnection(identifier, userName, password, lifetime, null);
    }

    MyProxyServiceEnvironment getMPSE() {
        return (MyProxyServiceEnvironment)MyProxyServlet.getServiceEnvironment();
    }

    protected MyProxyConnectable createMPConnection(Identifier identifier, String userName, String password, long lifetime, String loa) throws GeneralSecurityException {
        MPConnectionProvider facades = new MPConnectionProvider(this.getMyLogger(), this.getMPSE().getMyProxyServices());
        MyProxyConnectable mpc = facades.findConnection(identifier, userName, password, loa, lifetime);
        DebugUtil.trace((Object)this, (String)mpc.toString());
        MyProxyServlet.getMyproxyConnectionCache().add((Cacheable)mpc);
        return mpc;
    }

    public void destroy() {
        super.destroy();
        this.shutdownCleanup(myproxyConnectionCleanup);
    }

    static {
        myproxyConnectionCleanup = null;
    }
}

