/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.myproxy.servlet;

import edu.uiuc.ncsa.myproxy.MPSingleConnectionProvider;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.exceptions.InvalidTimestampException;
import edu.uiuc.ncsa.security.core.util.DateUtils;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.servlet.TransactionState;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenUtils;
import org.oa4mp.delegation.server.OA2GeneralError;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.jwt.MyOtherJWTUtil2;
import org.oa4mp.delegation.server.request.IssuerResponse;
import org.oa4mp.delegation.server.server.PAIResponse2;
import org.oa4mp.myproxy.servlet.ACS2;
import org.oa4mp.myproxy.servlet.MyProxyServlet;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.servlet.OA2HeaderUtils;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;

/*
 * Exception performing whole class analysis ignored.
 */
public class OA2CertServlet
extends ACS2 {
    protected AccessToken getAccessToken(HttpServletRequest request) {
        String rawAT;
        block7: {
            rawAT = request.getParameter("access_token");
            if (rawAT == null) {
                List bearerTokens = OA2HeaderUtils.getAuthHeader((HttpServletRequest)request, (String)"Bearer");
                if (bearerTokens.isEmpty()) {
                    throw new OA2GeneralError("invalid_request", "missing access token", 400, null);
                }
                if (1 < bearerTokens.size()) {
                    throw new OA2GeneralError("invalid_request", "too many access tokens", 400, null);
                }
                rawAT = (String)bearerTokens.get(0);
            }
            if (StringUtils.isTrivial((String)rawAT)) {
                throw new OA2GeneralError("invalid_request", "missing access token", 400, null);
            }
            try {
                OA2SE oa2se = (OA2SE)OA2CertServlet.getServiceEnvironment();
                JSONObject jwt = MyOtherJWTUtil2.verifyAndReadJWT((String)rawAT, (JSONWebKeys)oa2se.getJsonWebKeys());
                if (!jwt.containsKey((Object)"jti")) {
                    throw new OA2GeneralError("invalid_request", "The access token is a JWT, but does not have a \" + JWT_ID + \" claim and cannot be processed.", 400, null);
                }
                rawAT = jwt.getString("jti");
            }
            catch (Throwable t) {
                if (!TokenUtils.isBase32((String)rawAT)) break block7;
                rawAT = TokenUtils.b32DecodeToken((String)rawAT);
            }
        }
        return new AccessTokenImpl(URI.create(rawAT));
    }

    public ServiceTransaction verifyAndGet(IssuerResponse iResponse) throws IOException {
        PAIResponse2 par = (PAIResponse2)iResponse;
        AccessToken accessToken = par.getAccessToken();
        OA2ServiceTransaction t = (OA2ServiceTransaction)this.getTransactionStore().get(accessToken);
        if (t == null) {
            throw new OA2GeneralError("invalid_token", "Invalid access token", 400, null);
        }
        if (!t.getScopes().contains("edu.uiuc.ncsa.myproxy.getcert")) {
            throw new OA2GeneralError("invalid_request", "Certificate request is not in scope.", 400, t.getRequestState(), (BaseClient)t.getClient());
        }
        if (!t.isAccessTokenValid()) {
            throw new OA2GeneralError("invalid_token", "invalid token", 400, t.getRequestState(), (BaseClient)t.getClient());
        }
        this.checkClientApproval((BaseClient)t.getClient());
        try {
            DateUtils.checkTimestamp((String)accessToken.getToken());
        }
        catch (InvalidTimestampException invalidTimestampException) {
            throw new OA2GeneralError("invalid_token", "expired token", 400, t.getRequestState(), (BaseClient)t.getClient());
        }
        return t;
    }

    protected void checkMPConnection(OA2ServiceTransaction st) throws GeneralSecurityException {
        if (!this.hasMPConnection((ServiceTransaction)st)) {
            this.createMPConnection(st.getIdentifier(), st.getMyproxyUsername(), "", st.getLifetime());
        }
    }

    protected void doRealCertRequest(ServiceTransaction trans, String statusString) throws Throwable {
        OA2ServiceTransaction st = (OA2ServiceTransaction)trans;
        if (!st.getFlowStates().acceptRequests || !st.getFlowStates().getCert) {
            throw new OA2GeneralError("access_denied", "access denied", 401, st.getRequestState(), (BaseClient)st.getClient());
        }
        OA2SE oa2SE = (OA2SE)OA2CertServlet.getServiceEnvironment();
        if (!oa2SE.isTwoFactorSupportEnabled()) {
            this.checkMPConnection(st);
        } else {
            if (!OA2CertServlet.getMyproxyConnectionCache().containsKey((Object)st.getIdentifier())) {
                throw new OA2GeneralError("server_error", "No cached my proxy object with identifier " + st.getIdentifierString(), 503, st.getRequestState(), (BaseClient)st.getClient());
            }
            MPSingleConnectionProvider.MyProxyLogonConnection mpc = (MPSingleConnectionProvider.MyProxyLogonConnection)OA2CertServlet.getMyproxyConnectionCache().get((Object)st.getIdentifier()).getValue();
            if (mpc.getMyProxyLogon() instanceof MyProxyServlet.MyMyProxyLogon) {
                MyProxyServlet.MyMyProxyLogon myProxyLogon = (MyProxyServlet.MyMyProxyLogon)mpc.getMyProxyLogon();
                OA2CertServlet.getMyproxyConnectionCache().remove((Object)mpc.getIdentifier());
                this.createMPConnection(trans.getIdentifier(), myProxyLogon.getUsername(), myProxyLogon.getPassphrase(), trans.getLifetime());
            }
        }
        this.doCertRequest((ServiceTransaction)st, statusString);
    }

    public void postprocess(TransactionState state) throws Throwable {
        super.postprocess(state);
        OA2ServiceTransaction t = (OA2ServiceTransaction)state.getTransaction();
        if (((OA2SE)OA2CertServlet.getServiceEnvironment()).isRefreshTokenEnabled() && t.hasRefreshToken()) {
            t.setAccessTokenValid(true);
            this.getTransactionStore().save((Identifiable)t);
        }
    }
}

