/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.myproxy.util;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.X509Extension;
import org.globus.gsi.X509ExtensionSet;
import org.globus.gsi.bc.BouncyCastleCertProcessingFactory;
import org.globus.gsi.bc.BouncyCastleUtil;
import org.globus.gsi.proxy.ext.ProxyCertInfo;
import org.globus.gsi.proxy.ext.ProxyCertInfoExtension;
import org.globus.gsi.proxy.ext.ProxyPolicy;
import org.globus.gsi.util.CertificateUtil;

public class JGlobusUtil {
    public static String getUsername(X509Certificate cert) {
        return BouncyCastleUtil.getIdentity((X509Certificate)cert);
    }

    public static X509Certificate createProxyCertificate(X509Certificate baseCert, PrivateKey generatedPrivateKey, PublicKey publicKey, int certLifetimeInSeconds) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        ProxyPolicy policy = new ProxyPolicy(ProxyPolicy.LIMITED);
        ProxyCertInfo proxyCertInfo = new ProxyCertInfo(policy);
        X509ExtensionSet extSet = new X509ExtensionSet();
        extSet.add((X509Extension)new ProxyCertInfoExtension(proxyCertInfo));
        BouncyCastleCertProcessingFactory factory = BouncyCastleCertProcessingFactory.getDefault();
        try {
            X509Certificate x = factory.createProxyCertificate(baseCert, generatedPrivateKey, publicKey, certLifetimeInSeconds, GSIConstants.CertificateType.GSI_4_LIMITED_PROXY, extSet, null);
            return x;
        }
        catch (GeneralSecurityException e) {
            String errMsg = "3.c. Error: signing a limited proxy credential: " + e.getMessage();
            throw new GeneralException(errMsg, (Throwable)e);
        }
    }

    public static String toGlobusID(String dn) {
        return CertificateUtil.toGlobusID((String)dn);
    }
}

