/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.test;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import java.util.Date;
import org.junit.Test;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.delegation.server.storage.ClientApprovalStore;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.server.test.StoreTest;

public abstract class CAStoreTest
extends StoreTest {
    public ClientApprovalStore<ClientApproval> getApprovalStore() throws Exception {
        return this.getTSProvider().getClientApprovalStore();
    }

    protected ClientStore<Client> getClientStore() throws Exception {
        return this.getTSProvider().getClientStore();
    }

    @Override
    public void checkStoreClass() throws Exception {
        this.testClassAsignability((Store)this.getApprovalStore());
    }

    @Test
    public void testApprovalStore() throws Exception {
        Client client = (Client)this.getClientStore().create();
        client.setHomeUri("urn:test:/home/uri/" + CAStoreTest.getRandomString((int)32));
        client.setSecret(CAStoreTest.getRandomString((int)256));
        client.setName("Test client" + CAStoreTest.getRandomString((int)32));
        client.setEmail(CAStoreTest.getRandomString((int)32) + "@email.foo.edu");
        client.setErrorUri("uri:test:/uh/oh/uri/" + CAStoreTest.getRandomString((int)32));
        this.getClientStore().save((Identifiable)client);
        ClientApproval ca = (ClientApproval)this.getApprovalStore().create();
        ca.setApprover("test-approver");
        ca.setApproved(true);
        ca.setApprovalTimestamp(new Date());
        ca.setIdentifier(client.getIdentifier());
        this.getApprovalStore().save((Identifiable)ca);
        ClientApproval ca1 = (ClientApproval)this.getApprovalStore().get((Object)ca.getIdentifier());
        assert (ca.equals((Object)ca1));
        this.getApprovalStore().remove((Object)ca.getIdentifier());
    }

    @Test
    public void testApprovalCycle() throws Exception {
        assert (!this.getApprovalStore().isApproved(BasicIdentifier.newID((String)("foo:bar:baz://" + CAStoreTest.getRandomString((int)32)))));
        Client client = (Client)this.getClientStore().create();
        Identifier identifier = client.getIdentifier();
        client.setHomeUri("urn:test:/home/uri/" + CAStoreTest.getRandomString((int)32));
        client.setSecret(CAStoreTest.getRandomString((int)256));
        client.setName("Test client" + CAStoreTest.getRandomString((int)32));
        client.setEmail(CAStoreTest.getRandomString((int)32) + "@email.foo.edu");
        client.setErrorUri("uri:test:/uh/oh/uri/" + CAStoreTest.getRandomString((int)32));
        this.getClientStore().save((Identifiable)client);
        ClientApproval ca = (ClientApproval)this.getApprovalStore().create();
        ca.setApprover("test-approver");
        ca.setApproved(false);
        ca.setApprovalTimestamp(new Date());
        ca.setIdentifier(identifier);
        this.getApprovalStore().save((Identifiable)ca);
        assert (!((ClientApproval)this.getApprovalStore().get((Object)client.getIdentifier())).isApproved());
        assert (!this.getApprovalStore().isApproved(identifier));
        ca.setApproved(true);
        this.getApprovalStore().save((Identifiable)ca);
        assert (identifier.equals(ca.getIdentifier()));
        assert (identifier.equals(client.getIdentifier()));
        assert (((ClientApproval)this.getApprovalStore().get((Object)client.getIdentifier())).isApproved());
        assert (this.getApprovalStore().isApproved(identifier));
        this.getApprovalStore().remove((Object)client.getIdentifier());
        this.getClientStore().remove((Object)client.getIdentifier());
    }
}

