/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.test;

import edu.uiuc.ncsa.security.util.crypto.CertUtil;
import edu.uiuc.ncsa.security.util.crypto.KeyUtil;
import edu.uiuc.ncsa.security.util.crypto.MyPKCS10CertRequest;
import edu.uiuc.ncsa.security.util.crypto.PEMFormatUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import junit.framework.TestCase;
import org.junit.Test;

public class CertAndKeyUtilTest
extends TestCase {
    @Test
    public void testDecode() throws Exception {
        String req = "MIICwTCCAakCAQAwfDELMAkGA1UEBhMCVVMxETAPBgNVBAgMCElsbGlub2lzMRAwDgYDVQQHDAdBcmdvbm5lMRAwDgYDVQQKDAdBcmdvbm5lMRQwEgYDVQQDDAtUaG9tYXMgVXJhbTEgMB4GCSqGSIb3DQEJARYRdHVyYW1AbWNzLmFubC5nb3YwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDDofjHElcWlaffUDg2nM/vFojXnLIMAjqlKOXdF0XToFWwnR/3ZtlpmAUW1A1L1l7UJLWYEZvtp0OIt/tcyhIWrU+uiu8LVFtZxhZwz90pCyWycsZ+54aVU3VhfgIEPzX49Xdkt/IvdDHCejL5YS0sGGYBP8gw6/hLCQLMz0PFi/xShJupqM7hmUP6uVBSEXgoMTBlquLZKl7vn0GTB0xM9Zmi2T1Td7fKU49UVmJqNS61dTVohaGsATBAL08rOouY5nQj1xMQgdmMlWOcZ2nCG00ztDWrmz2879odb3YKgdw5fAOMkDClUPvbF4Le+cplDpStdpk5JL1AX38BqFjnAgMBAAGgADANBgkqhkiG9w0BAQUFAAOCAQEASX3RbyPOnlksWlbMpaJGi1hJFFdKWisW7aIeZiSQES4tEZV1fTt3kbXSTKxOptUbqiMmi8VvVJktY6RsSPXdGGqFQqXnYZyX0OWfDX3qwQHmYWx6UzD3hDwJhDYQMl+L/iI1dq4fO46OqAf9t8sFX8LYuBiA4hjSVZZ/vewTu2lLhTqK0iEcJ6m1B+FQ2NSFEmNKWkFqtO0UnIhhBsCS3Ym0zyjIWwr/8lDpYTow8LChOTwkHJdhN/EOvCg1Tp2R5u35dJGADZ+/OPyQzvox/OZ5x5IX9Nby8iCGt9dp3gBliB3mbZ5be80QQhbnkO/fuj0rTuzeodkwkMjGlaVGdA==";
        String req3 = "MIICwDCCAagCAQAwezELMAkGA1UEBhMCVVMxETAPBgNVBAgMCElsbGlub2lzMRAwDgYDVQQHDAdBcmdvbm5lMRAwDgYDVQQKDAdBcmdvbm5lMRMwEQYDVQQDDApUaG9tYXNVcmFtMSAwHgYJKoZIhvcNAQkBFhF0dXJhbUBtY3MuYW5sLmdvdjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANkQfpWUt/3l4SNoRRN8JicdCjX5RHmIzYujTea82B05M/9VGU6vsPD9afEI2GjX8Q/vmjGVs+w+QzGOu59+vmCiAAKWwUiw7Qr4Uk0kOe+z4RSLh1E7wXk4Mqh+PeF+rysmL6r5dhNlvyr/tF0LCZ3qkWgW42U9/od5uftEtSyRIvkbVnIDJPzSeD/Rj173d9WRXaTSML0VK9euJAr/12V4kV9k3pmCKk/7qMPQfjpyfTnrdc4orvIW5HWDnAGUWgzFXDvFyhrYo0QzgmfbeuLR0PQTQwpTyhBdbUrc5cqjG1gveybSXMB7sbHJVbWSUH80VlP+GXTeL8rObZzCgI8CAwEAAaAAMA0GCSqGSIb3DQEBBQUAA4IBAQCs/uc1PdHaEe/gfkwKgPpvuOj2rn6hIiWC4tpF4N/ROP5jRA3YXXnR5SEQZwfAgmSuX9qfAeg5eA0MEqav4nLl97gsvCpojh1aX0TYRcmQIL5A1Y988mANiFDDwZJzj241XJSQTB8owy7d5WxnaGL2WYnElKqWfag6CdA9e6/6mO3BjG7aGXpeYHQmD1VPLLrm2TIchg5UDG+/l/mnpwaiaqlXEHtL/tu6BrpomPVhnL3vwWhgpdeZuIzcw4KPXO8Y7E+mXmn/jAKAJh3vW6Li1XYgw80EFzPek56FaracatI6k50lA7pBf6bto9XXDK2SiMP7DEp57rSVMXciwTZ9";
        CertUtil.fromStringToCertReq((String)req);
        CertUtil.fromStringToCertReq((String)req3);
    }

    @Test
    public void testKeyGeneration() throws Exception {
        KeyPair keypair = KeyUtil.generateKeyPair();
        String pkcs8Key = KeyUtil.toPKCS8PEM((PrivateKey)keypair.getPrivate());
        PrivateKey privKey = KeyUtil.fromPKCS8PEM((String)pkcs8Key);
        assert (privKey.equals(keypair.getPrivate()));
        String rawPublic = KeyUtil.toPKCS8PEM((PublicKey)keypair.getPublic());
        PublicKey pubKey = KeyUtil.fromPublicPKCS8PEM((String)rawPublic);
        assert (pubKey.equals(keypair.getPublic()));
    }

    @Test
    public void testCertReq() throws Exception {
        KeyPair keyPair = KeyUtil.generateKeyPair();
        System.out.println("Public key:\n" + KeyUtil.toX509PEM((PublicKey)keyPair.getPublic()));
        System.out.println("Private key:\n" + KeyUtil.toPKCS8PEM((PrivateKey)keyPair.getPrivate()));
        MyPKCS10CertRequest cr = CertUtil.createCertRequest((KeyPair)keyPair);
        System.out.println("Cert request:\n" + String.valueOf(cr));
    }

    protected String readFile(String fileName) throws IOException {
        URL url = ((Object)((Object)this)).getClass().getResource("/" + fileName);
        File f = new File(url.getFile());
        System.out.println("CertAndKeyUtilTest:" + f.getAbsolutePath());
        if (!f.exists()) {
            String oldPath = f.getAbsolutePath();
            String p = System.getenv("NCSA_DEV_INPUT") + "/oa4mp/oa4mp-server-test/src/test/resources/" + fileName;
            f = new File(p);
            if (!f.exists()) {
                throw new FileNotFoundException("Could not find resource. Tried " + oldPath + " and " + f.getAbsolutePath());
            }
        }
        return PEMFormatUtil.readerToString((Reader)new FileReader(f));
    }

    @Test
    public void testCertPEM() throws Exception {
        String cert = this.readFile("certs/github-com.pem");
        X509Certificate[] certificate = CertUtil.fromX509PEM((String)cert);
        assert (certificate.length == 1) : "Error, incorrect number of certs returned (should be 1, got" + certificate.length + ")";
        assert (certificate[0].getSubjectDN() != null);
    }

    @Test
    public void testX509PublicKey() throws Exception {
        String puk = this.readFile("certs/pkcs8_public.pem");
        PublicKey puk2 = KeyUtil.fromX509PEM((String)puk);
        String puk3 = KeyUtil.toX509PEM((PublicKey)puk2);
        assert (puk2.equals(KeyUtil.fromX509PEM((String)puk3)));
    }

    @Test
    public void testPKCS8Key() throws Exception {
        String keyFile = this.readFile("certs/pkcs8.pem");
        PrivateKey prk = KeyUtil.fromPKCS8PEM((String)keyFile);
        StringWriter sw = new StringWriter();
        KeyUtil.toPKCS8PEM((PrivateKey)prk, (Writer)sw);
        assert (KeyUtil.fromPKCS8PEM((String)sw.getBuffer().toString()).equals(prk));
    }

    public void testPKCS1Key() throws Exception {
        String keyFile = this.readFile("certs/pkcs1.pem");
        System.out.println(keyFile);
        PrivateKey prk = KeyUtil.fromPKCS1PEM((String)keyFile);
        System.out.println("alg=" + prk.getAlgorithm());
        System.out.println("key=\n" + String.valueOf(prk));
    }
}

