/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.test;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Store;
import org.junit.Test;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.server.test.StoreTest;

public abstract class ClientStoreTest
extends StoreTest {
    public ClientStore<Client> getClientStore() throws Exception {
        return this.getTSProvider().getClientStore();
    }

    @Override
    public void checkStoreClass() throws Exception {
        this.testClassAsignability((Store)this.getClientStore());
    }

    @Test
    public void testBasic() throws Exception {
        Client client = (Client)this.getClientStore().create();
        System.out.println("New client ID = " + String.valueOf(client.getIdentifier()));
        client.setHomeUri("urn:test:/home/uri");
        client.setSecret(ClientStoreTest.getRandomString((int)256));
        client.setName("Test delegation client");
        client.setEmail("test@email.foo.edu");
        client.setErrorUri("uri:test:/uh/oh/uri");
        client.setProxyLimited(true);
        this.getClientStore().save((Identifiable)client);
        Client client2 = (Client)this.getClientStore().get((Object)client.getIdentifier());
        assert (client.equals((Object)client2));
        this.getClientStore().remove((Object)client.getIdentifier());
    }
}

