/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.test;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.exceptions.FilePermissionsException;
import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.IdentifiableProviderImpl;
import edu.uiuc.ncsa.security.storage.GenericStoreUtils;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.util.TestBase;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.delegation.server.storage.ClientApprovalStore;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.delegation.server.storage.impl.FSClientApprovalStore;
import org.oa4mp.server.api.ClientApprovalProvider;
import org.oa4mp.server.api.storage.filestore.DSFSClientApprovalStore;
import org.oa4mp.server.api.util.ClientApproverConverter;
import org.oa4mp.server.test.TestUtils;

public class NewCAStoreTest
extends TestBase {
    public void testFS() throws Exception {
        this.testApprovalStore(TestUtils.getFsStoreProvider().getClientStore(), TestUtils.getFsStoreProvider().getClientApprovalStore());
        this.testApprovalCycle(TestUtils.getFsStoreProvider().getClientStore(), TestUtils.getFsStoreProvider().getClientApprovalStore());
    }

    public void testMYSQL() throws Exception {
        this.testApprovalStore(TestUtils.getMySQLStoreProvider().getClientStore(), TestUtils.getMySQLStoreProvider().getClientApprovalStore());
        this.testApprovalCycle(TestUtils.getMySQLStoreProvider().getClientStore(), TestUtils.getMySQLStoreProvider().getClientApprovalStore());
    }

    public void testMemStore() throws Exception {
        this.testApprovalStore(TestUtils.getMemoryStoreProvider().getClientStore(), TestUtils.getMemoryStoreProvider().getClientApprovalStore());
        this.testApprovalCycle(TestUtils.getMemoryStoreProvider().getClientStore(), TestUtils.getMemoryStoreProvider().getClientApprovalStore());
    }

    public void testPG() throws Exception {
        this.testApprovalStore(TestUtils.getPgStoreProvider().getClientStore(), TestUtils.getPgStoreProvider().getClientApprovalStore());
        this.testApprovalCycle(TestUtils.getPgStoreProvider().getClientStore(), TestUtils.getPgStoreProvider().getClientApprovalStore());
    }

    public void testDerby() throws Exception {
        this.testApprovalStore(TestUtils.getDerbyStoreProvider().getClientStore(), TestUtils.getPgStoreProvider().getClientApprovalStore());
        this.testApprovalCycle(TestUtils.getDerbyStoreProvider().getClientStore(), TestUtils.getPgStoreProvider().getClientApprovalStore());
    }

    public void testApprovalStore(ClientStore clientStore, ClientApprovalStore caStore) throws Exception {
        Client client = (Client)clientStore.create();
        client.setHomeUri("urn:test:/home/uri/" + NewCAStoreTest.getRandomString((int)32));
        client.setSecret(NewCAStoreTest.getRandomString((int)256));
        client.setName("Test client" + NewCAStoreTest.getRandomString((int)32));
        client.setEmail(NewCAStoreTest.getRandomString((int)32) + "@email.foo.edu");
        client.setErrorUri("uri:test:/uh/oh/uri/" + NewCAStoreTest.getRandomString((int)32));
        clientStore.save((Identifiable)client);
        ClientApproval ca = (ClientApproval)caStore.create();
        ca.setApprover("test-approver");
        ca.setApproved(true);
        ca.setApprovalTimestamp(new Date());
        ca.setIdentifier(client.getIdentifier());
        caStore.save((Identifiable)ca);
        ClientApproval ca1 = (ClientApproval)caStore.get((Object)ca.getIdentifier());
        assert (ca.equals((Object)ca1));
        caStore.remove((Object)ca.getIdentifier());
        clientStore.remove((Object)client);
    }

    public void testApprovalCycle(ClientStore clientStore, ClientApprovalStore caStore) throws Exception {
        assert (!caStore.isApproved(BasicIdentifier.newID((String)("foo:bar:baz://" + NewCAStoreTest.getRandomString((int)32)))));
        Client client = (Client)clientStore.create();
        Identifier identifier = client.getIdentifier();
        client.setHomeUri("urn:test:/home/uri/" + NewCAStoreTest.getRandomString((int)32));
        client.setSecret(NewCAStoreTest.getRandomString((int)256));
        client.setName("Test client" + NewCAStoreTest.getRandomString((int)32));
        client.setEmail(NewCAStoreTest.getRandomString((int)32) + "@email.foo.edu");
        client.setErrorUri("uri:test:/uh/oh/uri/" + NewCAStoreTest.getRandomString((int)32));
        clientStore.save((Identifiable)client);
        ClientApproval ca = (ClientApproval)caStore.create();
        ca.setApprover("test-approver");
        ca.setApproved(false);
        ca.setApprovalTimestamp(new Date());
        ca.setIdentifier(identifier);
        caStore.save((Identifiable)ca);
        assert (!((ClientApproval)caStore.get((Object)client.getIdentifier())).isApproved());
        assert (!caStore.isApproved(identifier));
        ca.setApproved(true);
        caStore.save((Identifiable)ca);
        assert (identifier.equals(ca.getIdentifier()));
        assert (identifier.equals(client.getIdentifier()));
        assert (((ClientApproval)caStore.get((Object)client.getIdentifier())).isApproved());
        assert (caStore.isApproved(identifier));
        caStore.remove((Object)client.getIdentifier());
        clientStore.remove((Object)client.getIdentifier());
    }

    public void testPermissions() throws Exception {
        File storeDirectory = File.createTempFile("fs-store", "-tmp");
        File indexDirectory = File.createTempFile("fs-index", "-tmp");
        storeDirectory.setWritable(false);
        indexDirectory.setWritable(false);
        assert (!storeDirectory.canWrite());
        FSClientApprovalStore x = null;
        ClientApprovalProvider caProvider = new ClientApprovalProvider();
        try {
            x = new FSClientApprovalStore(null, null, null, null, true, true){

                public List<Identifier> statusSearch(String status) {
                    return null;
                }

                public List getMostRecent(int n, List attributes) {
                    return GenericStoreUtils.getMostRecent((Store)this, (int)n, (List)attributes);
                }

                public Object put(Object key, Object value) {
                    return null;
                }
            };
            assert (false) : "Could make a new object without being properly configured";
        }
        catch (MyConfigurationException myConfigurationException) {
            // empty catch block
        }
        x = new DSFSClientApprovalStore(storeDirectory, indexDirectory, (IdentifiableProviderImpl)caProvider, (MapConverter)new ClientApproverConverter((IdentifiableProviderImpl)caProvider), true, true);
        try {
            x.create();
            assert (false);
        }
        catch (FilePermissionsException filePermissionsException) {
            // empty catch block
        }
        storeDirectory.setWritable(true);
        indexDirectory.setWritable(true);
        ClientApproval ca = (ClientApproval)x.create();
        storeDirectory.setReadable(false);
        try {
            x.get((Object)ca.getIdentifier());
            assert (false);
        }
        catch (FilePermissionsException filePermissionsException) {
            // empty catch block
        }
    }
}

