/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.test;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.util.TestBase;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.server.test.TestUtils;

public class NewClientStoreTest
extends TestBase {
    public void testFS() throws Exception {
        this.testBasic(TestUtils.getFsStoreProvider().getClientStore());
    }

    public void testMYSQL() throws Exception {
        this.testBasic(TestUtils.getMySQLStoreProvider().getClientStore());
    }

    public void testMemStore() throws Exception {
        this.testBasic(TestUtils.getMemoryStoreProvider().getClientStore());
    }

    public void testPG() throws Exception {
        this.testBasic(TestUtils.getPgStoreProvider().getClientStore());
    }

    public void testDerby() throws Exception {
        this.testBasic(TestUtils.getDerbyStoreProvider().getClientStore());
    }

    public void testBasic(ClientStore clientStore) throws Exception {
        Client client = (Client)clientStore.create();
        System.out.println("New client ID = " + String.valueOf(client.getIdentifier()));
        client.setHomeUri("urn:test:/home/uri");
        client.setSecret(NewClientStoreTest.getRandomString((int)256));
        client.setName("Test delegation client");
        client.setEmail("test@email.foo.edu");
        client.setErrorUri("uri:test:/uh/oh/uri");
        client.setProxyLimited(true);
        clientStore.save((Identifiable)client);
        Client client2 = (Client)clientStore.get((Object)client.getIdentifier());
        assert (client.getIdentifier().equals(client2.getIdentifier()));
        assert (client.getHomeUri().equals(client2.getHomeUri()));
        assert (client.getSecret().equals(client2.getSecret()));
        assert (client.getName().equals(client2.getName()));
        assert (client.getEmail().equals(client2.getEmail()));
        assert (client.getErrorUri().equals(client2.getErrorUri()));
        assert (client2.isProxyLimited());
        clientStore.remove((Object)client.getIdentifier());
    }
}

