/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.test;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.util.TestBase;
import java.net.URI;
import org.oa4mp.delegation.common.storage.TransactionStore;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.common.token.TokenForge;
import org.oa4mp.delegation.server.OA2TokenForge;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.server.api.OA4MPServiceTransaction;
import org.oa4mp.server.test.TestUtils;

public class NewTransactionTest
extends TestBase {
    public void testFS() throws Exception {
        this.serviceTransactionTest(TestUtils.getFsStoreProvider().getTransactionStore(), TestUtils.getFsStoreProvider().getTokenForge(), TestUtils.getFsStoreProvider().getClientStore());
    }

    public void testMYSQL() throws Exception {
        this.serviceTransactionTest(TestUtils.getMySQLStoreProvider().getTransactionStore(), TestUtils.getMySQLStoreProvider().getTokenForge(), TestUtils.getMySQLStoreProvider().getClientStore());
    }

    public void testMemStore() throws Exception {
        this.serviceTransactionTest(TestUtils.getMemoryStoreProvider().getTransactionStore(), TestUtils.getMemoryStoreProvider().getTokenForge(), TestUtils.getMemoryStoreProvider().getClientStore());
    }

    public void testPG() throws Exception {
        this.serviceTransactionTest(TestUtils.getPgStoreProvider().getTransactionStore(), TestUtils.getPgStoreProvider().getTokenForge(), TestUtils.getPgStoreProvider().getClientStore());
    }

    public void testDerby() throws Exception {
        this.serviceTransactionTest(TestUtils.getDerbyStoreProvider().getTransactionStore(), TestUtils.getDerbyStoreProvider().getTokenForge(), TestUtils.getDerbyStoreProvider().getClientStore());
    }

    protected AuthorizationGrant newAG(TokenForge tokenForge, String ... x) {
        AuthorizationGrant ag = tokenForge.getAuthorizationGrant(x);
        return ag;
    }

    protected AccessToken newAT(TokenForge tokenForge, String ... x) {
        AccessToken at = tokenForge.getAccessToken(x);
        return at;
    }

    public void serviceTransactionTest(TransactionStore transactionStore, TokenForge tokenForge, ClientStore clientStore) throws Exception {
        String randomString = NewTransactionTest.getRandomString();
        OA4MPServiceTransaction serviceTransaction = (OA4MPServiceTransaction)transactionStore.create();
        serviceTransaction.setCallback(URI.create("http://callback"));
        AuthorizationGrant ag = tokenForge.getAuthorizationGrant(new String[]{serviceTransaction.getIdentifierString()});
        serviceTransaction.setAuthorizationGrant(ag);
        serviceTransaction.setLifetime(36000000L);
        serviceTransaction.setUsername("FakeUserName");
        String mpUN = "myproxy username /with weird $$#@ in=it/#" + System.nanoTime();
        serviceTransaction.setMyproxyUsername(mpUN);
        Client client = (Client)clientStore.create();
        client.setIdentifier((Identifier)new BasicIdentifier(URI.create("test:client:1d/" + randomString)));
        serviceTransaction.setAuthGrantValid(false);
        serviceTransaction.setClient(client);
        client.setName("service test name #" + System.nanoTime());
        OA2TokenForge tf = new OA2TokenForge("https://localhost/" + randomString);
        serviceTransaction.setAccessToken((AccessToken)tf.getAccessToken(new String[0]));
        transactionStore.save((Identifiable)serviceTransaction);
        clientStore.save((Identifiable)client);
        assert (transactionStore.containsKey((Object)serviceTransaction.getIdentifier()));
        assert (serviceTransaction.equals(transactionStore.get((Object)serviceTransaction.getIdentifier())));
        assert (serviceTransaction.equals((Object)transactionStore.get(serviceTransaction.getAuthorizationGrant())));
        transactionStore.save((Identifiable)serviceTransaction);
        serviceTransaction.setAccessToken(this.newAT(tokenForge, new String[0]));
        serviceTransaction.setAuthGrantValid(false);
        serviceTransaction.setAccessTokenValid(true);
        transactionStore.save((Identifiable)serviceTransaction);
        assert (serviceTransaction.equals(transactionStore.get((Object)serviceTransaction.getIdentifier())));
        assert (serviceTransaction.equals((Object)transactionStore.get(serviceTransaction.getAccessToken())));
        serviceTransaction.setAccessTokenValid(false);
        transactionStore.save((Identifiable)serviceTransaction);
        assert (serviceTransaction.equals(transactionStore.get((Object)serviceTransaction.getIdentifier())));
        serviceTransaction.setClient(client);
        transactionStore.remove((Object)serviceTransaction.getIdentifier());
        assert (!transactionStore.containsKey((Object)serviceTransaction.getIdentifier()));
        clientStore.remove((Object)client.getIdentifier());
    }
}

