/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.test;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.configuration.ConfigTest;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEventListener;
import edu.uiuc.ncsa.security.core.configuration.provider.HierarchicalConfigProvider;
import edu.uiuc.ncsa.security.core.exceptions.NotImplementedException;
import edu.uiuc.ncsa.security.core.util.IdentifiableProviderImpl;
import edu.uiuc.ncsa.security.core.util.IdentifierProvider;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPoolProvider;
import edu.uiuc.ncsa.security.storage.sql.derby.DerbyConnectionPoolProvider;
import edu.uiuc.ncsa.security.storage.sql.mysql.MySQLConnectionPoolProvider;
import edu.uiuc.ncsa.security.storage.sql.postgres.PGConnectionPoolProvider;
import java.util.Iterator;
import javax.inject.Provider;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.junit.Test;
import org.oa4mp.delegation.common.storage.clients.ClientConverter;
import org.oa4mp.delegation.common.storage.clients.ClientProvider;
import org.oa4mp.delegation.server.storage.ClientApprovalStore;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.server.api.ClientApprovalProvider;
import org.oa4mp.server.api.admin.transactions.OA4MPIdentifierProvider;
import org.oa4mp.server.api.storage.MultiDSClientApprovalStoreProvider;
import org.oa4mp.server.api.storage.MultiDSClientStoreProvider;
import org.oa4mp.server.api.storage.filestore.DSFSClientApprovalStoreProvider;
import org.oa4mp.server.api.storage.filestore.DSFSClientStoreProvider;
import org.oa4mp.server.api.storage.sql.provider.DSClientSQLStoreProvider;
import org.oa4mp.server.api.storage.sql.provider.DSSQLClientApprovalStoreProvider;
import org.oa4mp.server.api.util.ClientApproverConverter;

public class ServiceConfigTest
extends ConfigTest {
    protected XMLConfiguration getConfiguration() throws ConfigurationException {
        return this.getConfiguration("/server-test.xml");
    }

    protected String getConfigurationType() {
        return "service";
    }

    @Test
    public void testClientStoreProvider() throws Exception {
        ConfigurationNode cn = this.getConfig("mixed config");
        ClientProvider clientProvider = new ClientProvider((IdentifierProvider)new OA4MPIdentifierProvider("client"));
        MultiDSClientStoreProvider csp = new MultiDSClientStoreProvider(cn, true, new MyLoggingFacade("test"), null, null, (IdentifiableProvider)clientProvider);
        ClientConverter converter = new ClientConverter((IdentifiableProvider)clientProvider);
        csp.addListener((CfgEventListener)new DSFSClientStoreProvider(cn, (MapConverter)converter, (Provider)clientProvider));
        csp.addListener((CfgEventListener)new DSClientSQLStoreProvider(cn, (ConnectionPoolProvider)new MySQLConnectionPoolProvider("oauth", "oauth"), "mysql", (MapConverter)converter, (Provider)clientProvider));
        csp.addListener((CfgEventListener)new DSClientSQLStoreProvider(cn, (ConnectionPoolProvider)new PGConnectionPoolProvider("oauth", "oauth"), "postgresql", (MapConverter)converter, (Provider)clientProvider));
        csp.addListener((CfgEventListener)new DSClientSQLStoreProvider(cn, (ConnectionPoolProvider)new DerbyConnectionPoolProvider("oauth", "oauth"), "derby", (MapConverter)converter, (Provider)clientProvider));
        ClientStore cs = (ClientStore)csp.get();
    }

    public void testClientApprovalStoreProvider() throws Exception {
        ConfigurationNode cn = this.getConfig("postgresql config");
        MultiDSClientApprovalStoreProvider dap = new MultiDSClientApprovalStoreProvider(cn, true, new MyLoggingFacade("test"), null, null);
        ClientApproverConverter cp = new ClientApproverConverter((IdentifiableProviderImpl)new ClientApprovalProvider());
        dap.addListener((CfgEventListener)new DSFSClientApprovalStoreProvider(cn, cp));
        dap.addListener((CfgEventListener)new DSSQLClientApprovalStoreProvider(cn, (ConnectionPoolProvider)new MySQLConnectionPoolProvider("oauth", "oauth"), "mysql", (MapConverter)cp));
        dap.addListener((CfgEventListener)new DSSQLClientApprovalStoreProvider(cn, (ConnectionPoolProvider)new PGConnectionPoolProvider("oauth", "oauth"), "postgresql", (MapConverter)cp));
        dap.addListener((CfgEventListener)new DSSQLClientApprovalStoreProvider(cn, (ConnectionPoolProvider)new DerbyConnectionPoolProvider("oa4mp", "oauth2"), "derby", (MapConverter)cp));
        ClientApprovalStore as = (ClientApprovalStore)dap.get();
    }

    @Test
    public void testServerConfig() throws Exception {
        ConfigurationNode zzz = this.getConfiguration().getRootNode();
        TestProvider service = new TestProvider(this.getConfig("mixed config"));
        TestProvider fsp = new TestProvider(service.getConfigurationAt("fileStore"));
        TestProvider mail = new TestProvider(service.getConfigurationAt("mail"));
        assert (mail.getBooleanAttribute("enabled"));
        assert (fsp.isA("fileStore")) : "NOT a filestore!";
        assert (!fsp.isA("mysql")) : "Is a mysql store and should not be";
        assert (!fsp.hasA("clientApprovals")) : "Should NOT provide client approvals and it does";
        assert (fsp.hasA("transactions")) : "Should provide transactions";
    }

    @Test
    public void testConfig() throws Exception {
        XMLConfiguration c = this.getConfiguration();
        Iterator iterator = c.getKeys();
        this.say("echoing configuration to console:");
        ConfigurationNode root = c.getRootNode();
        this.say("name of root = " + root.getName());
        this.say("child count = " + root.getChildren().size());
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            this.say("(k, v)=(" + key + ", " + c.getString(key) + ")");
        }
        SubnodeConfiguration mailC = c.configurationAt("service.mail");
        this.say("mail configured? " + mailC.getString("[@enabled]"));
    }

    protected static class TestProvider
    extends HierarchicalConfigProvider<Object> {
        public Object componentFound(CfgEvent configurationEvent) {
            throw new NotImplementedException();
        }

        public TestProvider(ConfigurationNode config) {
            super(config);
        }

        public Object get() {
            throw new NotImplementedException("woops...");
        }

        protected boolean checkEvent(CfgEvent cfgEvent) {
            return true;
        }
    }
}

