/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.test;

import edu.uiuc.ncsa.security.core.configuration.Configurations;
import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.oa4mp.server.api.storage.servlet.AbstractBootstrapper;
import org.oa4mp.server.test.TestStoreProviderInterface;

public class TestUtils {
    static AbstractBootstrapper bootstrapper;
    private static TestStoreProviderInterface memoryStoreProvider;
    private static TestStoreProviderInterface fsStoreProvider;
    private static TestStoreProviderInterface OLDfsStoreProvider;
    private static TestStoreProviderInterface pgStoreProvider;
    private static TestStoreProviderInterface mySQLStoreProvider;
    private static TestStoreProviderInterface h2StoreProvider;
    private static TestStoreProviderInterface derbyStoreProvider;
    private static TestStoreProviderInterface agStoreProvider;

    public static AbstractBootstrapper getBootstrapper() {
        return bootstrapper;
    }

    public static void setBootstrapper(AbstractBootstrapper bootstrapper) {
        TestUtils.bootstrapper = bootstrapper;
    }

    public static void setMemoryStoreProvider(TestStoreProviderInterface memoryStoreProvider) {
        TestUtils.memoryStoreProvider = memoryStoreProvider;
    }

    public static TestStoreProviderInterface getAgStoreProvider() {
        return agStoreProvider;
    }

    public static void setAgStoreProvider(TestStoreProviderInterface ags) {
        agStoreProvider = ags;
    }

    public static TestStoreProviderInterface getMemoryStoreProvider() {
        return memoryStoreProvider;
    }

    public static TestStoreProviderInterface getFsStoreProvider() {
        return fsStoreProvider;
    }

    public static void setFsStoreProvider(TestStoreProviderInterface fsStoreProvider) {
        TestUtils.fsStoreProvider = fsStoreProvider;
    }

    public static TestStoreProviderInterface getOLDfsStoreProvider() {
        return OLDfsStoreProvider;
    }

    public static void setOLDfsStoreProvider(TestStoreProviderInterface OLDfsStoreProvider) {
        TestUtils.OLDfsStoreProvider = OLDfsStoreProvider;
    }

    public static TestStoreProviderInterface getMySQLStoreProvider() {
        return mySQLStoreProvider;
    }

    public static void setMySQLStoreProvider(TestStoreProviderInterface mySQLStoreProvider) {
        TestUtils.mySQLStoreProvider = mySQLStoreProvider;
    }

    public static TestStoreProviderInterface getPgStoreProvider() {
        return pgStoreProvider;
    }

    public static void setPgStoreProvider(TestStoreProviderInterface pgStoreProvider) {
        TestUtils.pgStoreProvider = pgStoreProvider;
    }

    public static TestStoreProviderInterface getDerbyStoreProvider() {
        return derbyStoreProvider;
    }

    public static void setDerbyStoreProvider(TestStoreProviderInterface derbyStoreProvider) {
        TestUtils.derbyStoreProvider = derbyStoreProvider;
    }

    public static String getConfigFileKey() {
        if (TestUtils.getBootstrapper() == null) {
            throw new NullPointerException("Error: you have not set the bootstrapper for this TestUtil class");
        }
        return TestUtils.getBootstrapper().getOa4mpConfigFileKey();
    }

    public static ConfigurationNode findConfigNode(String configName) {
        return TestUtils.findConfigNode(null, configName);
    }

    public static ConfigurationNode findConfigNode(String fileName, String configName) {
        if (fileName == null) {
            fileName = System.getProperty(TestUtils.getConfigFileKey());
        }
        if (fileName == null) {
            throw new MyConfigurationException("Error: No configuration file specified. Did you set the system property correctly?");
        }
        try {
            XMLConfiguration cfg = null;
            if (fileName.length() != 0) {
                try {
                    cfg = Configurations.getConfiguration((File)new File(fileName));
                }
                catch (MyConfigurationException cx) {
                    cx.printStackTrace();
                    URL url = TestUtils.class.getResource(fileName);
                    if (url == null) {
                        throw new MyConfigurationException("Error:No configuration found. for \"" + fileName + "\"");
                    }
                    cfg = Configurations.getConfiguration((URL)url);
                }
            } else {
                throw new MyConfigurationException("Error:No configuration file found.");
            }
            ConfigurationNode cn = null;
            if (configName == null) {
                String cfgName = System.getProperty(TestUtils.getBootstrapper().getOa4mpConfigNameKey());
                if (cfgName == null) {
                    DebugUtil.trace(TestUtils.class, (String)"no name for a configuration given");
                    cn = cfg.configurationAt("service").getRootNode();
                } else {
                    DebugUtil.trace(TestUtils.class, (String)("getting named configuration \"" + cfgName + "\""));
                    cn = Configurations.getConfig((XMLConfiguration)cfg, (String)"service", (String)cfgName);
                }
            } else {
                cn = Configurations.getConfig((XMLConfiguration)cfg, (String)"service", (String)configName);
            }
            return cn;
        }
        catch (Exception x) {
            MyConfigurationException ex = new MyConfigurationException("Error loading configuration with name \"" + configName + "\" from file \"" + fileName + "\".", (Throwable)x);
            DebugUtil.trace(TestUtils.class, (String)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public static void setH2StoreProvider(TestStoreProviderInterface h2) {
        h2StoreProvider = h2;
    }

    public static void main(String[] args) {
        try {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("/bin/cat");
            commands.add("/home/ncsa/test.txt");
            System.out.println(commands);
            ProcessBuilder pb = new ProcessBuilder(commands);
            pb.directory(new File("/home/ncsa"));
            pb.redirectErrorStream(true);
            Process process = pb.start();
            StringBuilder out = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            String previous = null;
            while ((line = br.readLine()) != null) {
                if (line.equals(previous)) continue;
                previous = line;
                out.append(line).append('\n');
                System.out.println(line);
            }
            if (process.waitFor() == 0) {
                System.out.println("Success!");
                System.exit(0);
            }
            System.err.println(commands);
            System.err.println(out.toString());
            System.exit(1);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

