/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.test;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import java.net.URI;
import org.junit.Test;
import org.oa4mp.delegation.common.storage.TransactionStore;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.server.api.OA4MPServiceTransaction;
import org.oa4mp.server.test.StoreTest;

public abstract class TransactionStoreTest
extends StoreTest {
    @Override
    public void checkStoreClass() throws Exception {
        this.testClassAsignability((Store)this.getStore());
    }

    public TransactionStore getStore() throws Exception {
        return this.getTSProvider().getTransactionStore();
    }

    protected AuthorizationGrant newAG(String ... x) {
        AuthorizationGrant ag = this.getTSProvider().getTokenForge().getAuthorizationGrant(x);
        return ag;
    }

    protected AccessToken newAT(String ... x) {
        AccessToken at = this.getTSProvider().getTokenForge().getAccessToken(x);
        return at;
    }

    @Test
    public void testServiceTransaction() throws Exception {
        OA4MPServiceTransaction OA4MPServiceTransaction2 = (OA4MPServiceTransaction)this.getStore().create();
        OA4MPServiceTransaction2.setCallback(URI.create("http://callback"));
        OA4MPServiceTransaction2.setLifetime(36000000L);
        OA4MPServiceTransaction2.setUsername("FakeUserName");
        String mpUN = "myproxy username /with weird $$#@ in=it/#" + System.nanoTime();
        OA4MPServiceTransaction2.setMyproxyUsername(mpUN);
        Client client = (Client)this.getTSProvider().getClientStore().create();
        client.setIdentifier((Identifier)new BasicIdentifier(URI.create("test:client:1d/" + System.currentTimeMillis())));
        OA4MPServiceTransaction2.setAuthorizationGrant(this.newAG(new String[0]));
        OA4MPServiceTransaction2.setAuthGrantValid(false);
        client.setName("service test name #" + System.nanoTime());
        this.getStore().save((Identifiable)OA4MPServiceTransaction2);
        assert (this.getStore().containsKey((Object)OA4MPServiceTransaction2.getIdentifier()));
        assert (OA4MPServiceTransaction2.equals(this.getStore().get((Object)OA4MPServiceTransaction2.getIdentifier())));
        assert (OA4MPServiceTransaction2.equals((Object)this.getStore().get(OA4MPServiceTransaction2.getAuthorizationGrant())));
        String r = TransactionStoreTest.getRandomString((int)12);
        OA4MPServiceTransaction2.setAccessToken(this.newAT(new String[0]));
        OA4MPServiceTransaction2.setAuthGrantValid(false);
        OA4MPServiceTransaction2.setAccessTokenValid(true);
        this.getStore().save((Identifiable)OA4MPServiceTransaction2);
        assert (OA4MPServiceTransaction2.equals(this.getStore().get((Object)OA4MPServiceTransaction2.getIdentifier())));
        assert (OA4MPServiceTransaction2.equals((Object)this.getStore().get(OA4MPServiceTransaction2.getAccessToken())));
        OA4MPServiceTransaction2.setAccessTokenValid(false);
        this.getStore().save((Identifiable)OA4MPServiceTransaction2);
        assert (OA4MPServiceTransaction2.equals(this.getStore().get((Object)OA4MPServiceTransaction2.getIdentifier())));
        this.getStore().remove((Object)OA4MPServiceTransaction2.getIdentifier());
        assert (!this.getStore().containsKey((Object)OA4MPServiceTransaction2.getIdentifier()));
    }
}

