/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.test.file;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.FilePermissionsException;
import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import edu.uiuc.ncsa.security.core.util.IdentifiableProviderImpl;
import edu.uiuc.ncsa.security.storage.FileStore;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import java.io.File;
import java.util.List;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.delegation.server.storage.impl.FSClientApprovalStore;
import org.oa4mp.server.api.ClientApprovalProvider;
import org.oa4mp.server.api.storage.filestore.DSFSClientApprovalStore;
import org.oa4mp.server.api.util.ClientApproverConverter;
import org.oa4mp.server.test.CAStoreTest;
import org.oa4mp.server.test.TestStoreProviderInterface;
import org.oa4mp.server.test.TestUtils;

public class FSCAStoreTest
extends CAStoreTest {
    @Override
    protected Class getStoreClass() {
        return FileStore.class;
    }

    @Override
    public TestStoreProviderInterface getTSProvider() {
        return TestUtils.getFsStoreProvider();
    }

    public void testPermissions() throws Exception {
        File storeDirectory = File.createTempFile("fs-store", "-tmp");
        File indexDirectory = File.createTempFile("fs-index", "-tmp");
        storeDirectory.setWritable(false);
        indexDirectory.setWritable(false);
        assert (!storeDirectory.canWrite());
        FSClientApprovalStore x = null;
        ClientApprovalProvider caProvider = new ClientApprovalProvider();
        try {
            x = new FSClientApprovalStore(null, null, null, null, true, true){

                public List<Identifier> statusSearch(String status) {
                    return null;
                }

                public List getMostRecent(int n, List attributes) {
                    throw new UnsupportedOperationException("get most recent not supported for this test store");
                }

                public Object put(Object key, Object value) {
                    return null;
                }
            };
            assert (false) : "Could make a new object without being properly configured";
        }
        catch (MyConfigurationException myConfigurationException) {
            // empty catch block
        }
        x = new DSFSClientApprovalStore(storeDirectory, indexDirectory, (IdentifiableProviderImpl)caProvider, (MapConverter)new ClientApproverConverter((IdentifiableProviderImpl)caProvider), true, true);
        try {
            x.create();
            assert (false);
        }
        catch (FilePermissionsException filePermissionsException) {
            // empty catch block
        }
        storeDirectory.setWritable(true);
        indexDirectory.setWritable(true);
        ClientApproval ca = (ClientApproval)x.create();
        storeDirectory.setReadable(false);
        try {
            x.get((Object)ca.getIdentifier());
            assert (false);
        }
        catch (FilePermissionsException filePermissionsException) {
            // empty catch block
        }
    }
}

