/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server;

import edu.uiuc.ncsa.security.core.util.StringUtils;
import java.security.SecureRandom;
import java.util.HashSet;
import org.apache.commons.codec.binary.Base64;
import org.oa4mp.delegation.server.server.InvalidNonceException;

public class NonceHerder {
    static HashSet<String> nonces = null;
    static SecureRandom random = new SecureRandom();

    public static HashSet<String> getNonces() {
        if (nonces == null) {
            nonces = new HashSet();
        }
        return nonces;
    }

    public static void removeNonce(String nonce) {
        NonceHerder.getNonces().remove(nonce);
    }

    public static boolean hasNonce(String nonce) {
        return NonceHerder.getNonces().contains(nonce);
    }

    public static void checkNonce(String nonce) {
        if (StringUtils.isTrivial((String)nonce)) {
            return;
        }
        if (NonceHerder.hasNonce(nonce)) {
            throw new InvalidNonceException(" nonce used");
        }
        NonceHerder.putNonce(nonce);
    }

    public static void putNonce(String nonce) {
        NonceHerder.getNonces().add(nonce);
    }

    public static String createNonce() {
        return NonceHerder.createNonce(32);
    }

    public static String createNonce(int length) {
        byte[] bytes = new byte[length];
        random.nextBytes(bytes);
        String nonce = Base64.encodeBase64URLSafeString((byte[])bytes);
        NonceHerder.putNonce(nonce);
        return nonce;
    }
}

