/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server;

import java.net.URI;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.server.OA2JSONException;
import org.oa4mp.delegation.server.OA2RedirectableError;

public class OA2ATException
extends OA2JSONException {
    URI errorURI;

    public OA2ATException(OA2RedirectableError error) {
        super(error);
    }

    public OA2ATException(String error, String description) {
        this(error, description, (String)null);
    }

    public OA2ATException(String error, String description, BaseClient client) {
        this(error, description);
        this.client = client;
    }

    public OA2ATException(String error, String description, String state) {
        super(error, description, 400, state);
    }

    public OA2ATException(String error, String description, String state, BaseClient client) {
        super(error, description, 400, state, client);
    }

    public OA2ATException(String error, String description, int httpStatus, String state) {
        super(error, description, httpStatus, state);
    }

    public OA2ATException(String error, String description, int httpStatus, String state, BaseClient client) {
        this(error, description, httpStatus, state);
        this.client = client;
    }

    public OA2ATException(String error, String description, int httpStatus, URI errorURI, String state) {
        super(error, description, httpStatus, state);
        this.errorURI = errorURI;
    }

    public OA2ATException(String error, String description, int httpStatus, URI errorURI, String state, BaseClient client) {
        this(error, description, httpStatus, errorURI, state);
        this.client = client;
    }

    @Override
    public String toString() {
        return "OA2ATException{httpStatus=" + this.httpStatus + ", error='" + this.error + "', description='" + this.description + "', errorURI='" + String.valueOf(this.errorURI) + "', state='" + this.state + "', client='" + (this.hasClient() ? "(none)" : this.getClient().getIdentifierString()) + "'}";
    }

    public URI getErrorURI() {
        return this.errorURI;
    }

    public void setErrorURI(URI errorURI) {
        this.errorURI = errorURI;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject jsonObject = super.toJSON();
        if (this.getErrorURI() != null) {
            jsonObject.put((Object)"error_uri", (Object)this.getErrorURI().toString());
        }
        return jsonObject;
    }
}

