/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;

public interface OA2Scopes {
    public static final String SCOPE_ADDRESS = "address";
    public static final String SCOPE_EMAIL = "email";
    public static final String SCOPE_MYPROXY = "edu.uiuc.ncsa.myproxy.getcert";
    public static final String SCOPE_OFFLINE_ACCESS = "offline_access";
    public static final String SCOPE_OPENID = "openid";
    public static final String SCOPE_PHONE = "phone";
    public static final String SCOPE_PROFILE = "profile";
    public static final String EDU_PERSON_ORC_ID = "eduPersonOrcid";
    public static final String SCOPE_CILOGON_INFO = "org.cilogon.userinfo";
    public static final String SCOPE_USER_INFO = "org.oa4mp:userinfo";
    public static final String SCOPE_TOKEN_MANAGER = "org.oa4mp:tokenmanager ";
    public static final String[] basicScopes = new String[]{"email", "edu.uiuc.ncsa.myproxy.getcert", "org.oa4mp:userinfo", "org.cilogon.userinfo", "openid", "profile"};
    public static final String[] nonPublicScopes = new String[]{"email", "edu.uiuc.ncsa.myproxy.getcert", "org.cilogon.userinfo", "profile"};

    public static class ScopeUtil {
        protected static Collection<String> bList = null;
        static Collection<String> scopes;

        public static Collection<String> getBasicScopes() {
            if (bList == null) {
                bList = Arrays.asList(basicScopes);
            }
            return bList;
        }

        public static void setBasicScopes(Collection<String> scopes) {
            bList = scopes;
        }

        public static Collection<String> intersection(Collection<String> x, Collection<String> y) {
            HashSet<String> x0 = new HashSet<String>();
            x0.addAll(x);
            HashSet<String> y0 = new HashSet<String>();
            y0.addAll(y);
            x0.retainAll(y0);
            return x0;
        }

        public static Collection<String> getScopes() {
            return scopes;
        }

        public static void setScopes(Collection<String> scopes) {
            ScopeUtil.scopes = scopes;
        }

        public static boolean hasScope(String targetScope) {
            for (String x : ScopeUtil.getScopes()) {
                if (!x.equals(targetScope)) continue;
                return true;
            }
            return false;
        }

        public static Collection<String> toScopes(String x) {
            HashSet<String> out = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(x, " ");
            while (st.hasMoreTokens()) {
                out.add(st.nextToken());
            }
            return out;
        }

        public static String toString(Collection<String> scopes) {
            Object ss = "";
            if (!scopes.isEmpty()) {
                boolean firstPass = true;
                for (String s : scopes) {
                    ss = (String)ss + (firstPass ? "" : " ") + s;
                    if (!firstPass) continue;
                    firstPass = false;
                }
            }
            return ss;
        }
    }
}

