/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.InvalidTokenException;
import edu.uiuc.ncsa.security.core.exceptions.NotImplementedException;
import edu.uiuc.ncsa.security.core.util.IP2;
import java.net.URI;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.common.token.TokenForge;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.AuthorizationGrantImpl;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenUtils;
import org.oa4mp.delegation.server.MissingTokenException;
import org.oa4mp.delegation.server.OA2Utilities;
import org.oa4mp.delegation.server.request.ATRequest;
import org.oa4mp.delegation.server.request.IssuerRequest;
import org.oa4mp.delegation.server.server.AGRequest2;
import org.oa4mp.delegation.server.server.OIDCServiceTransactionInterface;
import org.oa4mp.delegation.server.server.RTIRequest;

public class OA2TokenForge
implements TokenForge {
    URI serverURI = null;
    String server;
    public String authzGrant = "authzGrant";
    public String accessToken = "accessToken";
    public String refreshToken = "refreshToken";
    public String idToken = "idToken";
    public String asset = "asset";
    public String userInfo = "userInfo";
    public static final int TYPE_AUTH_GRANT = 1;
    public static final int TYPE_ACCESS_TOKEN = 10;
    public static final int TYPE_REFRESH_TOKEN = 100;
    public static final int TYPE_ID_TOKEN = 200;
    public static final int TYPE_UNKNOWN = 0;
    IP2<Identifier> atIdProvider;
    IP2<Identifier> agIdProvider;
    IP2<Identifier> refreshTokenProvider;
    IP2<Identifier> idTokenprovider = null;

    public AuthorizationGrantImpl createToken(AGRequest2 request) {
        return new AuthorizationGrantImpl(this.getAgIdProvider().get(request.getLifetime()));
    }

    public AccessTokenImpl createToken(ATRequest request) {
        return new AccessTokenImpl(this.metaCT((IssuerRequest)request, this.getAtIdProvider()));
    }

    public RefreshTokenImpl createToken(RTIRequest request) {
        return new RefreshTokenImpl(this.metaCT(request, this.getRefreshTokenProvider()));
    }

    protected URI metaCT(IssuerRequest request, IP2 ip2) {
        OIDCServiceTransactionInterface t = (OIDCServiceTransactionInterface)request.getTransaction();
        long lifetime = -1L;
        switch (request.getType()) {
            case 1: {
                lifetime = t.getAuthzGrantLifetime();
                break;
            }
            case 2: {
                lifetime = t.getAccessTokenLifetime();
                break;
            }
            case 5: {
                lifetime = t.getRefreshTokenLifetime();
                break;
            }
            default: {
                throw new NotImplementedException("Lifetime for request of type " + request.getClass().getSimpleName() + " not implemented.");
            }
        }
        return ip2.get(lifetime);
    }

    public OA2TokenForge(String server) {
        this.server = server;
    }

    protected String authzGrant(String ... x) {
        if (1 == x.length) {
            this.authzGrant = x[0];
        }
        return this.authzGrant;
    }

    protected String accessToken(String ... x) {
        if (1 == x.length) {
            this.accessToken = x[0];
        }
        return this.accessToken;
    }

    protected String refreshToken(String ... x) {
        if (1 == x.length) {
            this.refreshToken = x[0];
        }
        return this.refreshToken;
    }

    protected String asset(String ... x) {
        if (1 == x.length) {
            this.asset = x[0];
        }
        return this.asset;
    }

    protected String userInfo(String ... x) {
        if (1 == x.length) {
            this.userInfo = x[0];
        }
        return this.userInfo;
    }

    protected String idToken(String ... x) {
        if (1 == x.length) {
            this.idToken = x[0];
        }
        return this.idToken;
    }

    public String getServer() {
        return this.server;
    }

    protected URI getServerURI() {
        if (this.serverURI == null) {
            this.serverURI = URI.create(this.getServer());
        }
        return this.serverURI;
    }

    public AccessToken getAccessToken(Map<String, String> parameters) {
        String tokenVal = parameters.get("access_token");
        if (tokenVal != null) {
            return new AccessTokenImpl(URI.create(tokenVal));
        }
        String authCode = parameters.get("code");
        if (authCode == null) {
            throw new GeneralException(" missing authorization code");
        }
        return this.getAccessToken(authCode);
    }

    public String getStringType(String x) {
        switch (this.getType(x)) {
            case 10: {
                return "access token";
            }
            case 100: {
                return "refresh token";
            }
            case 1: {
                return "authz grant";
            }
            case 200: {
                return "id token";
            }
        }
        return "unknown token";
    }

    public int getType(String x) {
        Object s = this.getServer();
        if (!((String)s).endsWith("/")) {
            s = (String)s + "/";
        }
        if (!x.startsWith((String)s)) {
            return 0;
        }
        try {
            URI uRI = URI.create(x);
        }
        catch (Throwable t) {
            return 0;
        }
        x = x.substring(((String)s).length());
        if (x.startsWith(this.accessToken(new String[0]) + "/")) {
            return 10;
        }
        if (x.startsWith(this.authzGrant(new String[0]) + "/")) {
            return 1;
        }
        if (x.startsWith(this.refreshToken(new String[0]) + "/")) {
            return 100;
        }
        if (x.startsWith(this.idToken(new String[0]) + "/")) {
            return 200;
        }
        return 0;
    }

    public AuthorizationGrant getAuthorizationGrant(Map<String, String> parameters) {
        String token = parameters.get("code");
        if (token == null) {
            throw new MissingTokenException(" the authorization grant token is missing.");
        }
        return this.getAuthorizationGrant(token);
    }

    public AuthorizationGrant getAuthorizationGrant(HttpServletRequest request) {
        try {
            return this.getAuthorizationGrant(OA2Utilities.getParameters(request));
        }
        catch (Exception e) {
            throw new GeneralException(" could not create the authorization grant", (Throwable)e);
        }
    }

    public AuthorizationGrant getAuthorizationGrant(String ... tokens) {
        switch (tokens.length) {
            case 0: {
                return new AuthorizationGrantImpl(this.getAgIdProvider().get().getUri());
            }
        }
        if (tokens[0] == null) {
            return new AuthorizationGrantImpl(null);
        }
        if (TokenUtils.isBase32((String)tokens[0])) {
            return new AuthorizationGrantImpl(tokens[0] == null ? null : URI.create(TokenUtils.b32DecodeToken((String)tokens[0])));
        }
        return new AuthorizationGrantImpl(URI.create(tokens[0]));
    }

    public TokenImpl getIDToken(String ... tokens) {
        switch (tokens.length) {
            case 0: {
                return new TokenImpl(this.getIDTokenProvider().get().getUri());
            }
        }
        return new TokenImpl(tokens[0] == null ? null : URI.create(tokens[0]));
    }

    public AccessToken getAccessToken(HttpServletRequest request) {
        try {
            return this.getAccessToken(OA2Utilities.getParameters(request));
        }
        catch (Exception e) {
            throw new GeneralException("Could not create a token", (Throwable)e);
        }
    }

    public IP2<Identifier> getAgIdProvider() {
        if (this.agIdProvider == null) {
            this.agIdProvider = new IP2<Identifier>(URI.create(this.getServer()), this.authzGrant(new String[0]), true){};
        }
        return this.agIdProvider;
    }

    public IP2<Identifier> getAtIdProvider() {
        if (this.atIdProvider == null) {
            this.atIdProvider = new IP2<Identifier>(URI.create(this.getServer()), this.accessToken(new String[0]), true){};
        }
        return this.atIdProvider;
    }

    public IP2<Identifier> getRefreshTokenProvider() {
        if (this.refreshTokenProvider == null) {
            this.refreshTokenProvider = new IP2<Identifier>(URI.create(this.getServer()), this.refreshToken(new String[0]), true){};
        }
        return this.refreshTokenProvider;
    }

    public IP2<Identifier> getIDTokenProvider() {
        if (this.idTokenprovider == null) {
            this.idTokenprovider = new IP2<Identifier>(URI.create(this.getServer()), this.idToken(new String[0]), true){};
        }
        return this.idTokenprovider;
    }

    protected URI getURI(String token) {
        try {
            return URI.create(token);
        }
        catch (Throwable t) {
            throw new InvalidTokenException("Invalid token \"" + token + "\"", t);
        }
    }

    public RefreshTokenImpl getRefreshToken(String ... tokens) {
        switch (tokens.length) {
            case 0: {
                return new RefreshTokenImpl(this.getRefreshTokenProvider().get().getUri());
            }
        }
        return new RefreshTokenImpl(tokens[0] == null ? null : URI.create(tokens[0]));
    }

    public AccessTokenImpl getAccessToken(String ... tokens) {
        switch (tokens.length) {
            case 0: {
                return new AccessTokenImpl(this.getAtIdProvider().get().getUri());
            }
        }
        return new AccessTokenImpl(URI.create(tokens[0]));
    }
}

