/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.client;

import edu.uiuc.ncsa.security.servlet.ServiceClient;
import java.net.URI;
import java.security.SecureRandom;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Hex;
import org.oa4mp.delegation.client.request.AGRequest;
import org.oa4mp.delegation.client.request.AGResponse;
import org.oa4mp.delegation.client.server.AGServer;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.common.token.impl.AuthorizationGrantImpl;
import org.oa4mp.delegation.server.NonceHerder;
import org.oa4mp.delegation.server.OA2Constants;
import org.oa4mp.delegation.server.client.ASImpl;

public class AGServer2
extends ASImpl
implements AGServer,
OA2Constants {
    public static int STATE_LENGTH = 16;
    ServiceClient serviceClient;
    SecureRandom secureRandom = new SecureRandom();

    public ServiceClient getServiceClient() {
        return this.serviceClient;
    }

    public AGServer2(ServiceClient serviceClient) {
        super(serviceClient.host(new URI[0]));
        this.serviceClient = serviceClient;
    }

    public AGResponse processAGRequest(AGRequest agRequest) {
        String responseString;
        JSONObject json;
        String accessCode;
        String nonce = NonceHerder.createNonce();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("response_type", "code");
        m.put("client_id", agRequest.getClient().getIdentifierString());
        m.put("scope", "openid edu.uiuc.ncsa.myproxy.getcert profile");
        m.put("redirect_uri", (String)agRequest.getParameters().get("redirect_uri"));
        byte[] bytes = new byte[STATE_LENGTH];
        this.secureRandom.nextBytes(bytes);
        String sentState = Hex.encodeHexString((byte[])bytes);
        m.put("state", sentState);
        m.put("nonce", nonce);
        m.put("prompt", "login");
        if (agRequest.getParameters().containsKey("response_mode")) {
            m.put("response_mode", (String)agRequest.getParameters().get("response_mode"));
        }
        if ((accessCode = (json = JSONObject.fromObject((Object)(responseString = this.getServiceClient().doGet(m)))).getString("code")) == null) {
            throw new IllegalArgumentException(" server did not return an access code.");
        }
        String state = json.getString("state");
        if (!sentState.equals(state)) {
            throw new IllegalStateException("The state string returned by the server does not match the one sent.");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("state", state);
        AuthorizationGrantImpl agi = new AuthorizationGrantImpl(URI.create(accessCode));
        AGResponse agr = new AGResponse((AuthorizationGrant)agi);
        agr.setParameters(map);
        return agr;
    }
}

