/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.client;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.servlet.ServiceClient;
import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.client.request.ATRequest;
import org.oa4mp.delegation.client.request.ATResponse;
import org.oa4mp.delegation.client.server.ATServer;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.IDTokenImpl;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenFactory;
import org.oa4mp.delegation.server.client.ATResponse2;
import org.oa4mp.delegation.server.client.RFC7523Utils;
import org.oa4mp.delegation.server.client.TokenAwareServer;

public class ATServer2
extends TokenAwareServer
implements ATServer {
    static HashMap<URI, IDTokenImpl> idTokenStore = new HashMap();
    boolean useBasicAuth = false;

    public static HashMap<URI, IDTokenImpl> getIDTokenStore() {
        return idTokenStore;
    }

    public ATServer2(ServiceClient serviceClient, URI issuer, String wellKnown, boolean oidcEnabled, long expiresIn, boolean useBasicAuth) {
        super(serviceClient, issuer, wellKnown, oidcEnabled);
        this.useBasicAuth = useBasicAuth;
    }

    public ATResponse processATRequest(ATRequest atRequest) {
        return this.getAccessToken(atRequest);
    }

    protected ATResponse2 getAccessToken(ATRequest atRequest) {
        HashMap<String, String> m = new HashMap<String, String>();
        Map params = atRequest.getParameters();
        if (atRequest.getParameters() != null) {
            m.putAll(params);
        }
        if (atRequest.isRfc8628()) {
            DebugUtil.trace((Object)this, (String)("rfc 8628 case, use http header for token? " + this.useBasicAuth));
            m.put("device_code", atRequest.getAuthorizationGrant().getToken());
            m.put("grant_type", "urn:ietf:params:oauth:grant-type:device_code");
            m.put("client_id", atRequest.getClient().getIdentifierString());
        } else {
            if (params.get("redirect_uri") == null) {
                throw new GeneralException(" the client redirect uri was not set in the request.");
            }
            DebugUtil.trace((Object)this, (String)("getting access token, use http header for token? " + this.useBasicAuth));
            m.put("code", atRequest.getAuthorizationGrant().getToken());
            m.put("grant_type", "authorization_code");
            m.put("redirect_uri", (String)params.get("redirect_uri"));
        }
        String response = null;
        if (atRequest.getClient().hasJWKS()) {
            response = RFC7523Utils.doPost(this.getServiceClient(), (BaseClient)atRequest.getClient(), this.getTokenEndpoint(), atRequest.getKeyID(), m);
        } else {
            String clientID = atRequest.getClient().getIdentifierString();
            String clientSecret = atRequest.getClient().getSecret();
            if (this.useBasicAuth) {
                response = this.getServiceClient().doGet(m, clientID, clientSecret);
            } else {
                m.put("client_id", clientID);
                m.put("client_secret", clientSecret);
                response = this.getServiceClient().doGet(m);
            }
        }
        JSONObject jsonObject = this.getAndCheckResponse(response);
        if (!jsonObject.containsKey((Object)"access_token")) {
            throw new IllegalArgumentException(" No access token found in server response");
        }
        AccessTokenImpl at = TokenFactory.createAT((String)jsonObject.getString("access_token"));
        if (jsonObject.containsKey((Object)"expires_in") && at.getLifetime() / 1000L != jsonObject.getLong("expires_in")) {
            at.setLifetime(jsonObject.getLong("expires_in") * 1000L);
            at.setExpiresAt(at.getIssuedAt() + at.getLifetime());
        }
        RefreshTokenImpl rt = null;
        if (jsonObject.containsKey((Object)"refresh_token")) {
            rt = TokenFactory.createRT((String)jsonObject.getString("refresh_token"));
            if (jsonObject.containsKey((Object)"refresh_token_lifetime")) {
                rt.setLifetime(jsonObject.getLong("refresh_token_lifetime") * 1000L);
                rt.setIssuedAt(jsonObject.getLong("refresh_token_iat") * 1000L);
                rt.setExpiresAt(rt.getIssuedAt() + rt.getLifetime());
            }
        }
        ServletDebugUtil.trace((Object)this, (String)("Is OIDC enabled? " + this.serverOIDCEnabled));
        IDTokenImpl idToken = null;
        if (jsonObject.containsKey((Object)"id_token")) {
            idToken = TokenFactory.createIDT((String)jsonObject.getString("id_token"));
            ATServer2.getIDTokenStore().put(at.getJti(), idToken);
        }
        if (this.serverOIDCEnabled && idToken != null) {
            if (m.containsKey("nonce") && !idToken.getPayload().getString("nonce").equals(atRequest.getParameters().get("nonce"))) {
                throw new GeneralException(" Incorrect nonce \"" + String.valueOf(atRequest.getParameters().get("nonce")) + "\" returned from server");
            }
        } else {
            ServletDebugUtil.trace((Object)this, (String)"Skipping id token entry...");
        }
        ATResponse2 atr = this.createResponse(at, rt, idToken);
        atr.setRawResponse(response);
        atr.setParameters(params);
        return atr;
    }

    protected ATResponse2 createResponse(AccessTokenImpl at, RefreshTokenImpl rt, IDTokenImpl idToken) {
        return new ATResponse2(at, rt, idToken);
    }

    public static class IDTokenEntry {
        public JSONObject idToken;
        public String rawToken;

        public String toString() {
            return this.getClass().getSimpleName() + "[idToken=" + (this.idToken == null ? "(null)" : this.idToken.toString(2)) + ", rawToken=" + (this.rawToken == null ? "(null)" : this.rawToken) + "]";
        }
    }
}

